/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.system.casts.handlers;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.init.HotkeyRegistry;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.abilities.SpellCastPacket;
import it.hurts.sskirillss.relics.system.casts.abilities.AbilityCache;
import it.hurts.sskirillss.relics.system.casts.abilities.AbilityReference;
import it.hurts.sskirillss.relics.system.casts.handlers.CacheHandler;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@OnlyIn(value=Dist.CLIENT)
public class HUDRenderHandler {
    public static final ResourceLocation CARD_FRAME_ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/card_frame_active.png");
    public static final ResourceLocation CARD_FRAME_INACTIVE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/card_frame_inactive.png");
    public static final ResourceLocation CARD_POINTER_ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/card_pointer_active.png");
    public static final ResourceLocation CARD_POINTER_INACTIVE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/card_pointer_inactive.png");
    public static final ResourceLocation ARROW_RIGHT = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/arrow_right.png");
    public static final ResourceLocation ARROW_LEFT = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/arrow_left.png");
    public static final ResourceLocation ARROW_RIGHT_OUTLINE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/arrow_right_outline.png");
    public static final ResourceLocation ARROW_LEFT_OUTLINE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/arrow_left_outline.png");
    public static final ResourceLocation STATE_TOGGLEABLE = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/widgets/toggleable.png");
    public static final ResourceLocation STATE_CYCLICAL = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/widgets/cyclical.png");
    private static final Minecraft MC = Minecraft.getInstance();
    private static int selectedIndex = 0;
    private static boolean animationDown = false;
    private static int animationDelta = 0;
    private static int castShakeDelta = 0;
    private static int mouseDelta = 0;

    public static void render(GuiGraphics guiGraphics, float partialTicks) {
        if (animationDelta == 0) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        Window window = MC.getWindow();
        LocalPlayer player = HUDRenderHandler.MC.player;
        if (player == null || CacheHandler.REFERENCES.isEmpty()) {
            return;
        }
        int x = window.getGuiScaledWidth() / 2;
        int y = -38;
        poseStack.pushPose();
        poseStack.translate(0.0f, ((float)animationDelta - (animationDelta != 5 ? partialTicks * (float)(animationDown ? -1 : 1) : 0.0f)) * 16.0f, 0.0f);
        float shakeOffset = castShakeDelta > 0 ? ((float)castShakeDelta - partialTicks) * 0.25f : 0.0f;
        HUDRenderHandler.drawAbility(guiGraphics, player, -2, (float)(x - 74) - shakeOffset, y, partialTicks);
        HUDRenderHandler.drawAbility(guiGraphics, player, -1, (float)(x - 39) - shakeOffset, y, partialTicks);
        HUDRenderHandler.drawAbility(guiGraphics, player, 0, x, y, partialTicks);
        HUDRenderHandler.drawAbility(guiGraphics, player, 1, (float)(x + 39) + shakeOffset, y, partialTicks);
        HUDRenderHandler.drawAbility(guiGraphics, player, 2, (float)(x + 74) + shakeOffset, y, partialTicks);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARROW_LEFT);
        RenderUtils.renderTextureFromCenter(poseStack, (float)(x - 100) - shakeOffset, y + 2, 0.0f, 0.0f, 11.0f, 30.0f, 11.0f, 30.0f, 1.0f + (mouseDelta < 0 ? (float)Math.abs(mouseDelta) * 0.01f : 0.0f));
        if (mouseDelta < 0) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARROW_LEFT_OUTLINE);
            RenderUtils.renderTextureFromCenter(poseStack, (float)(x - 100) - shakeOffset, y + 2, 0.0f, 0.0f, 13.0f, 32.0f, 13.0f, 32.0f, 1.0f + (float)Math.abs(mouseDelta) * 0.01f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARROW_RIGHT);
        RenderUtils.renderTextureFromCenter(poseStack, (float)(x + 100) + shakeOffset, y + 2, 0.0f, 0.0f, 11.0f, 30.0f, 11.0f, 30.0f, 1.0f + (mouseDelta > 0 ? (float)Math.abs(mouseDelta) * 0.01f : 0.0f));
        if (mouseDelta > 0) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ARROW_RIGHT_OUTLINE);
            RenderUtils.renderTextureFromCenter(poseStack, (float)(x + 100) + shakeOffset, y + 2, 0.0f, 0.0f, 13.0f, 32.0f, 13.0f, 32.0f, 1.0f + (float)Math.abs(mouseDelta) * 0.01f);
        }
        RenderSystem.disableBlend();
        AbilityReference selectedAbility = HUDRenderHandler.getAbilityByIndex(selectedIndex);
        AbilityCache selectedCache = HUDRenderHandler.getCacheByIndex(selectedIndex);
        if (selectedAbility == null || selectedCache == null) {
            return;
        }
        ItemStack stack = selectedAbility.getSlot().gatherStack((Player)player);
        String registryName = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        MutableComponent name = Component.translatable((String)("tooltip.relics." + registryName + ".ability." + selectedAbility.getId()));
        guiGraphics.drawString(HUDRenderHandler.MC.font, (Component)name, x - HUDRenderHandler.MC.font.width((FormattedText)name) / 2, y - 38, 0xFFFFFF, true);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(((float)animationDelta - (animationDelta != 5 ? partialTicks * (float)(animationDown ? -1 : 1) : 0.0f)) * 16.0f, 0.0f, 0.0f);
        int yOff = 0;
        x = -70;
        y = 25;
        for (Map.Entry<String, Boolean> entry : selectedCache.getPredicates().entrySet()) {
            String predicateName = entry.getKey();
            boolean isCompleted = entry.getValue();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(isCompleted ? ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/icons/completed.png") : ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/icons/" + registryName + "/" + predicateName + ".png"))));
            RenderUtils.renderTextureFromCenter(poseStack, x, y + yOff, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f, 16.0f, 0.5f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(HUDRenderHandler.MC.font, (Component)Component.translatable((String)("tooltip.relics." + registryName + ".ability." + selectedAbility.getId() + ".predicate." + predicateName)).withStyle(isCompleted ? ChatFormatting.STRIKETHROUGH : ChatFormatting.RESET), (x + 7) * 2, (y - 2 + yOff) * 2, isCompleted ? 12517304 : 15826844, true);
            poseStack.scale(2.0f, 2.0f, 2.0f);
            yOff += 10;
        }
        poseStack.popPose();
    }

    private static void drawAbility(GuiGraphics guiGraphics, LocalPlayer player, int realIndex, float x, float y, float partialTicks) {
        int relativeIndex = HUDRenderHandler.getRelativeIndex(realIndex);
        AbilityReference ability = HUDRenderHandler.getAbilityByIndex(relativeIndex);
        AbilityCache cache = HUDRenderHandler.getCacheByIndex(relativeIndex);
        if (ability == null || cache == null) {
            return;
        }
        ItemStack stack = ability.getSlot().gatherStack((Player)player);
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        boolean isLocked = !relic.canUseAbility((Player)player, stack, ability.getId());
        ResourceLocation card = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/abilities/" + BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath() + "/" + (String)relic.getAbilityData(ability.getId()).getIcon().apply((Object)player, (Object)stack, (Object)ability.getId()) + ".png"));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)card);
        RenderSystem.enableBlend();
        poseStack.pushPose();
        int width = 20;
        int height = 29;
        float scale = (float)(1.0 + Mth.clamp((double)Math.pow(15.0, -Math.abs(realIndex)), (double)0.0, (double)0.2f) + (realIndex == 0 ? Math.sin(((float)player.tickCount + partialTicks) * 0.1f) * (double)0.05f + (double)(castShakeDelta > 0 ? ((float)castShakeDelta - partialTicks) * 0.02f : 0.0f) : 0.0));
        RenderUtils.renderTextureFromCenter(poseStack, x - scale + 1.0f, y - scale + 2.0f, width, height, scale + 0.025f);
        int cooldown = relic.getAbilityCooldown(stack, ability.getId());
        int cap = relic.getAbilityCooldownCap(stack, ability.getId());
        Object iconDescription = "";
        if (cooldown > 0) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)card);
            RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
            float percentage = (float)cooldown / ((float)cap / 100.0f) / 100.0f;
            RenderUtils.renderTextureFromCenter(poseStack, x - scale, y + 2.0f - scale + (float)height * scale / 2.0f - (float)height * scale / 2.0f * percentage, 0.0f, (float)height - (float)height * percentage, width, height, width, (float)height * percentage, scale + 0.025f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(isLocked ? CARD_FRAME_INACTIVE : CARD_FRAME_ACTIVE));
        RenderUtils.renderTextureFromCenter(poseStack, x, y + 1.0f, 0.0f, 0.0f, 30.0f, 41.0f, 30.0f, 41.0f, scale);
        if (relic.isAbilityTicking(stack, ability.getId())) {
            CastType type = relic.getAbilityData(ability.getId()).getCastData().getType();
            if (type == CastType.TOGGLEABLE) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)STATE_TOGGLEABLE);
                RenderSystem.enableBlend();
                RenderUtils.renderAnimatedTextureFromCenter(poseStack, x, y + 1.0f, 34.0f, 630.0f, 34.0f, 45.0f, scale, AnimationData.builder().frame(0, 1).frame(1, 1).frame(2, 1).frame(3, 1).frame(4, 1).frame(5, 1).frame(6, 1).frame(7, 1).frame(8, 1).frame(9, 1).frame(10, 1).frame(11, 1).frame(12, 1).frame(13, 1));
                RenderSystem.disableBlend();
            } else {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(Math.sin((float)player.tickCount * 0.5f) * 0.25 + 0.75)));
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)STATE_CYCLICAL);
                RenderUtils.renderTextureFromCenter(poseStack, x - 0.5f, y + 1.0f, 33.0f, 45.0f, scale);
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (realIndex == 0) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(isLocked ? CARD_POINTER_INACTIVE : CARD_POINTER_ACTIVE));
            RenderUtils.renderTextureFromCenter(poseStack, x, y - 20.0f, 0.0f, 0.0f, 6.0f, 11.0f, 6.0f, 11.0f, scale);
        }
        if (cooldown > 0) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/widgets/icons/cooldown.png"));
            RenderSystem.enableBlend();
            HUDRenderHandler.drawAbilityStatusIcon(cache, guiGraphics, x - scale, y - scale, 22.0f, 352.0f, scale - 0.1f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 1).frame(10, 1).frame(11, 1).frame(12, 1).frame(13, 1).frame(14, 1).frame(15, 1), cap - cooldown, partialTicks);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            iconDescription = String.valueOf(MathUtils.round((double)cooldown / 20.0, 1));
        } else {
            Collection<Boolean> infoEntries = cache.getPredicates().values();
            int successPredicates = 0;
            for (boolean value : infoEntries) {
                if (!value) continue;
                ++successPredicates;
            }
            int failedPredicates = infoEntries.size() - successPredicates;
            if (failedPredicates > 0) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/hud/abilities/widgets/icons/locked.png"));
                RenderSystem.enableBlend();
                HUDRenderHandler.drawAbilityStatusIcon(cache, guiGraphics, x - scale, y - scale, 20.0f, 20.0f, scale - 0.1f, null, player.tickCount, partialTicks);
                RenderSystem.disableBlend();
                iconDescription = successPredicates + "/" + infoEntries.size();
            }
        }
        if (!((String)iconDescription).isEmpty()) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
            MutableComponent descriptionComponent = Component.literal((String)iconDescription).withStyle(ChatFormatting.BOLD);
            guiGraphics.drawString(HUDRenderHandler.MC.font, (Component)descriptionComponent, (int)(x * 2.0f - (float)HUDRenderHandler.MC.font.width((FormattedText)descriptionComponent) / 2.0f), (int)((y - 6.0f + scale * 15.0f) * 2.0f), 0xFFFFFF, true);
        }
        poseStack.popPose();
    }

    private static void drawAbilityStatusIcon(AbilityCache cache, GuiGraphics guiGraphics, float x, float y, float texWidth, float texHeight, float scale, @Nullable AnimationData animation, long ticks, float partialTicks) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(x + 1.0f, y, 0.0f);
        if (cache.getIconShakeDelta() != 0) {
            float color = (float)cache.getIconShakeDelta() * 0.04f;
            RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - color), (float)(1.0f - color), (float)1.0f);
            poseStack.mulPose(Axis.ZP.rotation((float)Math.sin(((float)ticks + partialTicks) * 0.75f) * 0.1f));
            scale += ((float)cache.getIconShakeDelta() - partialTicks) * 0.025f;
        }
        if (animation != null) {
            RenderUtils.renderAnimatedTextureFromCenter(poseStack, 0.0f, 0.0f, texWidth, texHeight, texWidth, texWidth, scale, animation, ticks);
        } else {
            RenderUtils.renderTextureFromCenter(poseStack, 0.0f, 0.0f, texWidth, texHeight, scale);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    private static int getRelativeIndex(int offset) {
        int current = selectedIndex;
        int sum = current + offset;
        int max = CacheHandler.REFERENCES.size() - 1;
        return sum > max ? Math.min(max, sum - (max + 1)) : (sum < 0 ? Math.max(0, sum + (max + 1)) : sum);
    }

    @Nullable
    private static AbilityReference getAbilityByIndex(int index) {
        if (CacheHandler.REFERENCES.isEmpty()) {
            return null;
        }
        return (AbilityReference)CacheHandler.REFERENCES.keySet().toArray()[Mth.clamp((int)index, (int)0, (int)(CacheHandler.REFERENCES.size() - 1))];
    }

    @Nullable
    private static AbilityCache getCacheByIndex(int index) {
        if (CacheHandler.REFERENCES.isEmpty()) {
            return null;
        }
        return (AbilityCache)CacheHandler.REFERENCES.values().toArray()[Mth.clamp((int)index, (int)0, (int)(CacheHandler.REFERENCES.size() - 1))];
    }

    private static void applyDelta(int delta) {
        int current = selectedIndex;
        int sum = current + delta;
        int max = CacheHandler.REFERENCES.size() - 1;
        selectedIndex = sum > max ? sum - max - 1 : (sum < 0 ? max : sum);
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class CastEvents {
        @SubscribeEvent
        public static void onKeyPressed(InputEvent.MouseButton.Pre event) {
            if (animationDelta == 0 || event.getAction() != 1 || event.getButton() != 0) {
                return;
            }
            Minecraft MC = Minecraft.getInstance();
            if (MC.screen != null) {
                return;
            }
            LocalPlayer player = MC.player;
            if (player == null) {
                return;
            }
            AbilityReference ability = HUDRenderHandler.getAbilityByIndex(selectedIndex);
            AbilityCache cache = HUDRenderHandler.getCacheByIndex(selectedIndex);
            if (ability == null || cache == null) {
                return;
            }
            ItemStack stack = ability.getSlot().gatherStack((Player)player);
            Item item = stack.getItem();
            if (!(item instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)item;
            if (!relic.canUseAbility((Player)player, stack, ability.getId())) {
                int delta;
                cache.setIconShakeDelta(Math.min(20, delta + ((delta = cache.getIconShakeDelta()) > 0 ? 5 : 15)));
                MC.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)(relic.isAbilityOnCooldown(stack, ability.getId()) ? (SoundEvent)SoundRegistry.ABILITY_COOLDOWN.get() : (SoundEvent)SoundRegistry.ABILITY_LOCKED.get()), (float)1.0f));
                event.setCanceled(true);
                return;
            }
            boolean isTicking = relic.isAbilityTicking(stack, ability.getId());
            CastType type = relic.getAbilityData(ability.getId()).getCastData().getType();
            MC.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.ABILITY_CAST.get()), (float)1.0f));
            switch (type) {
                case INSTANTANEOUS: {
                    NetworkHandler.sendToServer(new SpellCastPacket(CastType.INSTANTANEOUS, CastStage.END, ability.serializeNBT()));
                    relic.castActiveAbility(stack, (Player)player, ability.getId(), type, CastStage.END);
                    break;
                }
                case CYCLICAL: {
                    NetworkHandler.sendToServer(new SpellCastPacket(CastType.CYCLICAL, CastStage.START, ability.serializeNBT()));
                    relic.castActiveAbility(stack, (Player)player, ability.getId(), type, CastStage.START);
                    break;
                }
                case INTERRUPTIBLE: {
                    CastStage stage = isTicking ? CastStage.END : CastStage.START;
                    NetworkHandler.sendToServer(new SpellCastPacket(CastType.INTERRUPTIBLE, stage, ability.serializeNBT()));
                    relic.castActiveAbility(stack, (Player)player, ability.getId(), type, stage);
                    break;
                }
                case TOGGLEABLE: {
                    CastStage stage = isTicking ? CastStage.END : CastStage.START;
                    NetworkHandler.sendToServer(new SpellCastPacket(CastType.TOGGLEABLE, stage, ability.serializeNBT()));
                    relic.castActiveAbility(stack, (Player)player, ability.getId(), type, stage);
                }
            }
            castShakeDelta = 10;
            Minecraft.getInstance().mouseHandler.releaseMouse();
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            IRelicItem relic;
            Player player = event.getEntity();
            if (!(player instanceof LocalPlayer)) {
                return;
            }
            AbilityReference ability = HUDRenderHandler.getAbilityByIndex(selectedIndex);
            if (ability == null) {
                return;
            }
            ItemStack stack = ability.getSlot().gatherStack(player);
            Item item = stack.getItem();
            if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).getAbilitiesData().getAbilities().containsKey(ability.getId())) {
                return;
            }
            boolean isTicking = relic.isAbilityTicking(stack, ability.getId());
            boolean isCasting = Minecraft.getInstance().mouseHandler.isLeftPressed();
            AbilityData entry = relic.getAbilityData(ability.getId());
            if (entry == null) {
                return;
            }
            CastType type = entry.getCastData().getType();
            switch (type) {
                case CYCLICAL: {
                    if (!isTicking) break;
                    if (isCasting) {
                        NetworkHandler.sendToServer(new SpellCastPacket(CastType.CYCLICAL, CastStage.TICK, ability.serializeNBT()));
                        relic.castActiveAbility(stack, player, ability.getId(), type, CastStage.TICK);
                        break;
                    }
                    NetworkHandler.sendToServer(new SpellCastPacket(CastType.CYCLICAL, CastStage.END, ability.serializeNBT()));
                    relic.castActiveAbility(stack, player, ability.getId(), type, CastStage.END);
                    break;
                }
                case INTERRUPTIBLE: {
                    if (!isTicking) break;
                    NetworkHandler.sendToServer(new SpellCastPacket(CastType.INTERRUPTIBLE, CastStage.TICK, ability.serializeNBT()));
                    relic.castActiveAbility(stack, player, ability.getId(), type, CastStage.TICK);
                    break;
                }
                case TOGGLEABLE: {
                    if (!isTicking) break;
                    NetworkHandler.sendToServer(new SpellCastPacket(CastType.TOGGLEABLE, CastStage.TICK, ability.serializeNBT()));
                    relic.castActiveAbility(stack, player, ability.getId(), type, CastStage.TICK);
                }
            }
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class GeneralEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
            if (!HotkeyRegistry.ABILITY_LIST.isDown() || CacheHandler.REFERENCES.isEmpty()) {
                return;
            }
            int current = selectedIndex;
            HUDRenderHandler.applyDelta(event.getScrollDeltaY() > 0.0 ? -1 : 1);
            if (current != selectedIndex) {
                mouseDelta = event.getScrollDeltaY() > 0.0 ? -10 : 10;
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.5f + player.getRandom().nextFloat() * 0.25f);
                }
            }
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            Player player = event.getEntity();
            if (!(player instanceof LocalPlayer)) {
                return;
            }
            if (castShakeDelta > 0) {
                --castShakeDelta;
            }
            if (mouseDelta > 0) {
                --mouseDelta;
            } else if (mouseDelta < 0) {
                ++mouseDelta;
            }
            if (HotkeyRegistry.ABILITY_LIST.isDown()) {
                IRelicItem relic;
                ItemStack stack;
                Item item;
                AbilityReference ability = HUDRenderHandler.getAbilityByIndex(selectedIndex);
                if (ability != null && (item = (stack = ability.getSlot().gatherStack(player)).getItem()) instanceof IRelicItem && (relic = (IRelicItem)item).getAbilityData(ability.getId()) != null && relic.canUseAbility(player, stack, ability.getId())) {
                    relic.tickActiveAbilitySelection(stack, player, ability.getId());
                }
                if (animationDelta < 5) {
                    ++animationDelta;
                }
                animationDown = true;
            } else {
                if (animationDelta > 0) {
                    --animationDelta;
                }
                animationDown = false;
            }
            if (animationDelta == 0) {
                return;
            }
            if (selectedIndex > CacheHandler.REFERENCES.size() || selectedIndex < 0) {
                selectedIndex = 0;
            }
        }
    }
}

