/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.api.events.common.LivingSlippingEvent;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @ModifyVariable(method={"travel"}, name={"f2"}, index=8, ordinal=0, at=@At(value="STORE"))
    protected float setBlockFriction(float original) {
        LivingEntity entity = (LivingEntity)this;
        LivingSlippingEvent event = new LivingSlippingEvent(entity, entity.getCommandSenderWorld().getBlockState(entity.getOnPos()), original);
        NeoForge.EVENT_BUS.post((Event)event);
        return event.getFriction();
    }

    @Inject(method={"isImmobile"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onAiStep(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.hasEffect(EffectRegistry.STUN)) {
            cir.setReturnValue((Object)true);
        }
        if (entity.hasEffect(EffectRegistry.PARALYSIS)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"canBeSeenByAnyone"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canBeSeenByAnyone(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity entity = (LivingEntity)this;
        if (entity.hasEffect(EffectRegistry.VANISHING)) {
            cir.setReturnValue((Object)false);
        }
    }
}

