/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Function3;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.entities.DeathEssenceEntity;
import it.hurts.sskirillss.relics.entities.LifeEssenceEntity;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.PredicateType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.network.packets.sync.SyncTargetPacket;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class HolyLocketItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("belief").active(CastData.builder().type(CastType.INSTANTANEOUS).build()).icon((Function3<Player, ItemStack, String, String>)((Function3)(player, stack, ability) -> ability + ((Boolean)stack.getOrDefault(DataComponentRegistry.TOGGLED, (Object)true) != false ? "_holy" : "_wicked"))).stat(StatData.builder("radius").icon(StatIcons.DISTANCE).initialValue(3.0, 6.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("amount").icon(StatIcons.MULTIPLIER).initialValue(0.1, 0.25).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)(MathUtils.round(value, 3) * 100.0)).build()).stat(StatData.builder("count").icon(StatIcons.COUNT).initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("capacity").icon(StatIcons.CAPACITY).initialValue(8.0, 12.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).ability(AbilityData.builder("repentance").requiredLevel(5).stat(StatData.builder("radius").icon(StatIcons.DISTANCE).initialValue(2.0, 6.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("damage").icon(StatIcons.DEALT_DAMAGE).initialValue(0.1, 0.2).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 2)).build()).build()).ability(AbilityData.builder("blessing").maxLevel(5).requiredPoints(2).requiredLevel(10).active(CastData.builder().type(CastType.TOGGLEABLE).predicate("blessing", PredicateType.CAST, (player, stack) -> this.getCharges((ItemStack)stack) > 0).build()).stat(StatData.builder("consumption").icon(StatIcons.CAPACITY).initialValue(8.0, 6.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).build()).leveling(new LevelingData(100, 15, 100)).style(StyleData.builder().build()).loot(LootData.builder().entry(LootCollections.DESERT).build()).build();
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (ability.equals("belief")) {
            stack.set(DataComponentRegistry.TOGGLED, (Object)((Boolean)stack.getOrDefault(DataComponentRegistry.TOGGLED, (Object)true) == false ? 1 : 0));
        }
    }

    public List<Monster> gatherMonsters(Player player, ItemStack stack) {
        return player.getCommandSenderWorld().getEntitiesOfClass(Monster.class, player.getBoundingBox().inflate(this.getStatValue(stack, "repentance", "radius"))).stream().filter(LivingEntity::isInvertedHealAndHarm).toList();
    }

    public int getMaxCharges(ItemStack stack) {
        return (int)this.getStatValue(stack, "belief", "capacity");
    }

    public void setCharges(ItemStack stack, int amount) {
        stack.set(DataComponentRegistry.CHARGE, (Object)Mth.clamp((int)amount, (int)0, (int)this.getMaxCharges(stack)));
    }

    public void addCharge(ItemStack stack, int amount) {
        this.setCharges(stack, this.getCharges(stack) + amount);
    }

    public int getCharges(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        List<Monster> monsters;
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || player.tickCount % 20 != 0) {
            return;
        }
        Level level = player.getCommandSenderWorld();
        int charges = this.getCharges(stack);
        if (this.isAbilityTicking(stack, "blessing")) {
            this.setCharges(stack, (int)((double)charges - this.getStatValue(stack, "blessing", "consumption")));
            if (charges <= 0) {
                this.setAbilityTicking(stack, "blessing", false);
            }
        }
        if ((monsters = this.gatherMonsters(player, stack)).isEmpty() || charges <= 0) {
            return;
        }
        for (Monster entity : monsters) {
            if (!EntityUtils.hurt((LivingEntity)entity, player.level().damageSources().playerAttack(player), (float)((double)charges * this.getStatValue(stack, "repentance", "damage")))) continue;
            entity.setRemainingFireTicks(50);
            this.spreadRelicExperience((LivingEntity)player, stack, 1);
            RandomSource random = level.getRandom();
            ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark(new Color(200, 150 + random.nextInt(50), random.nextInt(50)), 0.4f, 20, 0.95f), entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ(), 10, (double)(entity.getBbWidth() / 2.0f), (double)(entity.getBbHeight() / 2.0f), (double)(entity.getBbWidth() / 2.0f), (double)0.025f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.translateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.rotateIfSneaking((PoseStack)matrixStack, (LivingEntity)entity);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        matrixStack.scale(0.5f, 0.5f, 0.5f);
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.scale(2.0f, 2.0f, 2.0f);
        matrixStack.popPose();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition bone = mesh.getRoot().addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 3).addBox(-8.0f, -1.15f, -4.15f, 16.0f, 7.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)1.15f, (float)0.0f));
        bone.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 18).addBox(-2.6096f, -0.8646f, -0.2f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0571f, (float)6.6447f, (float)-4.9f, (float)0.0f, (float)0.0f, (float)0.2568f));
        bone.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(12, 18).addBox(-1.0f, -1.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.15f)), PartPose.offsetAndRotation((float)0.0877f, (float)6.2393f, (float)-5.2f, (float)0.0f, (float)0.0f, (float)0.7854f));
        bone.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0322f, -2.5947f, -0.225f, 2.0f, 6.0f, 1.0f, new CubeDeformation(0.05f)), PartPose.offsetAndRotation((float)0.0571f, (float)6.6447f, (float)-4.9f, (float)0.0f, (float)0.0f, (float)-0.004f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    @Override
    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"body"});
    }

    @EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingIncomingDamageEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.HOLY_LOCKET.get());
                Item item = stack.getItem();
                if (item instanceof HolyLocketItem) {
                    int charges;
                    HolyLocketItem relic = (HolyLocketItem)item;
                    if (relic.isAbilityTicking((ItemStack)stack, "blessing")) {
                        event.setCanceled(true);
                        return;
                    }
                    if (((Boolean)stack.getOrDefault(DataComponentRegistry.TOGGLED, (Object)false)).booleanValue() && (charges = relic.getCharges((ItemStack)stack)) > 0) {
                        event.setAmount(event.getAmount() * ((float)charges / 100.0f));
                    }
                }
            } else {
                Player player;
                Item charges;
                stack = event.getSource().getEntity();
                if (stack instanceof Player && (charges = (stack = EntityUtils.findEquippedCurio((Entity)(player = (Player)stack), (Item)ItemRegistry.HOLY_LOCKET.get())).getItem()) instanceof HolyLocketItem) {
                    HolyLocketItem relic = (HolyLocketItem)charges;
                    if (!((Boolean)stack.getOrDefault(DataComponentRegistry.TOGGLED, (Object)false)).booleanValue() && (charges = relic.getCharges((ItemStack)stack)) > 0) {
                        event.setAmount(event.getAmount() + event.getAmount() * (float)charges * 0.01f);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void onLivingHeal(LivingHealEvent event) {
            block10: {
                block7: {
                    HolyLocketItem relic;
                    Level level;
                    ItemStack stack;
                    Player player;
                    block9: {
                        block8: {
                            LivingEntity livingEntity = event.getEntity();
                            if (!(livingEntity instanceof Player)) break block7;
                            player = (Player)livingEntity;
                            stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.HOLY_LOCKET.get());
                            level = player.getCommandSenderWorld();
                            Item item = stack.getItem();
                            if (!(item instanceof HolyLocketItem)) break block8;
                            relic = (HolyLocketItem)item;
                            if (!((Boolean)stack.getOrDefault(DataComponentRegistry.TOGGLED, (Object)true)).booleanValue()) break block9;
                        }
                        return;
                    }
                    for (LivingEntity target : level.getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(relic.getStatValue(stack, "belief", "radius"))).stream().filter(arg_0 -> ((Player)player).hasLineOfSight(arg_0)).sorted(Comparator.comparing(entity -> entity.position().distanceTo(player.position()))).limit((int)relic.getStatValue(stack, "belief", "count")).toList()) {
                        if (target.getStringUUID().equals(player.getStringUUID())) continue;
                        int amount = (int)Math.max((double)event.getAmount() * relic.getStatValue(stack, "belief", "amount"), 1.0);
                        DeathEssenceEntity essence = new DeathEssenceEntity((EntityType<? extends DeathEssenceEntity>)((EntityType)EntityRegistry.DEATH_ESSENCE.get()), level);
                        essence.setPos(player.position().add(0.0, (double)(player.getBbHeight() / 2.0f), 0.0));
                        essence.setDirectionChoice(MathUtils.randomFloat(player.getRandom()));
                        essence.setTarget(target);
                        essence.setDamage(amount);
                        level.addFreshEntity((Entity)essence);
                        if (!level.isClientSide()) {
                            ((ServerLevel)level).getChunkSource().broadcastAndSend((Entity)player, (Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new SyncTargetPacket(essence.getId(), target.getId())));
                        }
                        relic.spreadRelicExperience((LivingEntity)player, stack, amount);
                        relic.addCharge(stack, 1);
                    }
                    break block10;
                }
                LivingEntity entity2 = event.getEntity();
                Level level = entity2.getCommandSenderWorld();
                for (ServerPlayer playerSearched : level.getEntitiesOfClass(ServerPlayer.class, event.getEntity().getBoundingBox().inflate(32.0))) {
                    HolyLocketItem relic;
                    ItemStack stack = EntityUtils.findEquippedCurio((Entity)playerSearched, (Item)ItemRegistry.HOLY_LOCKET.get());
                    Item essence = stack.getItem();
                    if (!(essence instanceof HolyLocketItem) || (relic = (HolyLocketItem)essence).getStatValue(stack, "belief", "radius") < playerSearched.position().distanceTo(event.getEntity().position()) || !((Boolean)stack.getOrDefault(DataComponentRegistry.TOGGLED, (Object)true)).booleanValue()) continue;
                    int amount = (int)Math.max((double)event.getAmount() * relic.getStatValue(stack, "belief", "amount"), 0.5);
                    LifeEssenceEntity essence2 = new LifeEssenceEntity((EntityType<? extends LifeEssenceEntity>)((EntityType)EntityRegistry.LIFE_ESSENCE.get()), level);
                    essence2.setPos(entity2.position().add(0.0, (double)(entity2.getBbHeight() / 2.0f), 0.0));
                    essence2.setDirectionChoice(MathUtils.randomFloat(playerSearched.getRandom()));
                    essence2.setTarget((LivingEntity)playerSearched);
                    essence2.setHeal(amount);
                    playerSearched.level().addFreshEntity((Entity)essence2);
                    if (!level.isClientSide()) {
                        ((ServerLevel)level).getChunkSource().broadcastAndSend((Entity)playerSearched, (Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new SyncTargetPacket(essence2.getId(), playerSearched.getId())));
                    }
                    relic.spreadRelicExperience((LivingEntity)playerSearched, stack, amount);
                    relic.addCharge(stack, 1);
                }
            }
        }
    }
}

