/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base;

import it.hurts.sskirillss.relics.api.events.leveling.ExperienceAddEvent;
import it.hurts.sskirillss.relics.components.AbilitiesComponent;
import it.hurts.sskirillss.relics.components.AbilityComponent;
import it.hurts.sskirillss.relics.components.DataComponent;
import it.hurts.sskirillss.relics.components.LevelingComponent;
import it.hurts.sskirillss.relics.components.StatComponent;
import it.hurts.sskirillss.relics.entities.RelicExperienceOrbEntity;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.RegistryRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicSlotModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStorage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.containers.base.RelicContainer;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.PredicateType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.tuple.Pair;

public interface IRelicItem {
    @Nullable
    default public Item getItem() {
        Item item;
        IRelicItem iRelicItem = this;
        return iRelicItem instanceof Item ? (item = (Item)iRelicItem) : null;
    }

    public RelicData constructDefaultRelicData();

    default public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
    }

    default public void tickActiveAbilitySelection(ItemStack stack, Player player, String ability) {
    }

    @Nullable
    default public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().build();
    }

    @Nullable
    default public RelicSlotModifier getSlotModifiers(ItemStack stack) {
        return RelicSlotModifier.builder().build();
    }

    default public RelicData getRelicData() {
        if (!RelicStorage.RELICS.containsKey(this)) {
            RelicStorage.RELICS.put(this, this.constructDefaultRelicData());
        }
        return RelicStorage.RELICS.get(this);
    }

    default public void setRelicData(RelicData data) {
        RelicStorage.RELICS.put(this, data);
    }

    default public AbilitiesData getAbilitiesData() {
        return this.getRelicData().getAbilities();
    }

    default public AbilityData getAbilityData(String ability) {
        return this.getAbilitiesData().getAbilities().get(ability);
    }

    default public StatData getStatData(String ability, String stat) {
        return this.getAbilityData(ability).getStats().get(stat);
    }

    default public LevelingData getLevelingData() {
        return this.getRelicData().getLeveling();
    }

    default public LootData getLootData() {
        return this.getRelicData().getLoot();
    }

    default public StyleData getStyleData() {
        return this.getRelicData().getStyle();
    }

    default public int getMaxQuality() {
        return 10;
    }

    default public int getStatQuality(ItemStack stack, String ability, String stat) {
        double max;
        StatData statData = this.getStatData(ability, stat);
        if (statData == null) {
            return 0;
        }
        Function<Double, ? extends Number> format = statData.getFormatValue();
        double initial = format.apply(this.getStatInitialValue(stack, ability, stat)).doubleValue();
        double min = format.apply((Double)statData.getInitialValue().getKey()).doubleValue();
        if (min == (max = format.apply((Double)statData.getInitialValue().getValue()).doubleValue())) {
            return this.getMaxQuality();
        }
        if (initial == min) {
            return 0;
        }
        if (initial == max) {
            return this.getMaxQuality();
        }
        return Mth.clamp((int)((int)Math.round((initial - min) / ((max - min) / (double)this.getMaxQuality()))), (int)1, (int)(this.getMaxQuality() - 1));
    }

    default public double getStatValueByQuality(String ability, String stat, int quality) {
        double max;
        StatData statData = this.getStatData(ability, stat);
        if (statData == null) {
            return 0.0;
        }
        double min = (Double)statData.getInitialValue().getKey();
        if (min == (max = ((Double)statData.getInitialValue().getValue()).doubleValue())) {
            return max;
        }
        return MathUtils.round(min + (max - min) / (double)this.getMaxQuality() * (double)quality, 5);
    }

    default public int getAbilityQuality(ItemStack stack, String ability) {
        Map<String, StatData> stats = this.getAbilityData(ability).getStats();
        if (stats.isEmpty()) {
            return 0;
        }
        double sum = 0.0;
        for (String stat : stats.keySet()) {
            sum += (double)this.getStatQuality(stack, ability, stat);
        }
        sum = (int)Math.floor(sum / (double)stats.size());
        int min = 0;
        int max = this.getMaxQuality();
        if (sum == (double)min) {
            return min;
        }
        if (sum == (double)max) {
            return max;
        }
        return (int)Mth.clamp((double)sum, (double)(min + 1), (double)(max - 1));
    }

    default public int getRelicQuality(ItemStack stack) {
        Map<String, AbilityData> abilities = this.getRelicData().getAbilities().getAbilities();
        if (abilities.isEmpty()) {
            return 0;
        }
        int size = abilities.size();
        double sum = 0.0;
        for (Map.Entry<String, AbilityData> entry : abilities.entrySet()) {
            if (entry.getValue().getMaxLevel() == 0) {
                --size;
                continue;
            }
            sum += (double)this.getAbilityQuality(stack, entry.getKey());
        }
        sum = (int)Math.floor(sum / (double)size);
        int min = 0;
        int max = this.getMaxQuality();
        if (sum == (double)min) {
            return min;
        }
        if (sum == (double)max) {
            return max;
        }
        return (int)Mth.clamp((double)sum, (double)(min + 1), (double)(max - 1));
    }

    default public int getRelicLevelingPoints(ItemStack stack) {
        return this.getLevelingComponent(stack).points();
    }

    default public void setRelicLevelingPoints(ItemStack stack, int amount) {
        this.setLevelingComponent(stack, this.getLevelingComponent(stack).toBuilder().points(Math.max(0, amount)).build());
    }

    default public void addRelicLevelingPoints(ItemStack stack, int amount) {
        this.setRelicLevelingPoints(stack, this.getRelicLevelingPoints(stack) + amount);
    }

    default public int getRelicLevel(ItemStack stack) {
        return this.getLevelingComponent(stack).level();
    }

    default public void setRelicLevel(ItemStack stack, int level) {
        this.setLevelingComponent(stack, this.getLevelingComponent(stack).toBuilder().level(Math.max(0, level)).build());
    }

    default public void addRelicLevel(ItemStack stack, int amount) {
        if (amount > 0) {
            this.addRelicLevelingPoints(stack, Mth.clamp((int)amount, (int)0, (int)(this.getLevelingData().getMaxLevel() - this.getRelicLevel(stack))));
        }
        this.setRelicLevel(stack, this.getRelicLevel(stack) + amount);
    }

    default public int getMaxLuck() {
        return 100;
    }

    default public double getLuckModifier() {
        return 1.25;
    }

    default public int getRelicLuck(ItemStack stack) {
        return this.getLevelingComponent(stack).luck();
    }

    default public void setRelicLuck(ItemStack stack, int amount) {
        this.setLevelingComponent(stack, this.getLevelingComponent(stack).toBuilder().luck(Mth.clamp((int)amount, (int)0, (int)this.getMaxLuck())).build());
    }

    default public void addRelicLuck(ItemStack stack, int amount) {
        this.setRelicLuck(stack, this.getRelicLuck(stack) + amount);
    }

    default public int getRelicExperience(ItemStack stack) {
        return this.getLevelingComponent(stack).experience();
    }

    default public void setRelicExperience(ItemStack stack, int experience) {
        this.setLevelingComponent(stack, this.getLevelingComponent(stack).toBuilder().experience(Math.clamp((long)experience, 0, this.getTotalRelicExperienceForLevel(this.getRelicLevel(stack) + 1))).build());
    }

    default public boolean addRelicExperience(ItemStack stack, int amount) {
        return this.addRelicExperience(null, stack, amount);
    }

    default public boolean addRelicExperience(@Nullable LivingEntity entity, ItemStack stack, int amount) {
        ExperienceAddEvent event = new ExperienceAddEvent((LivingEntity)(entity instanceof LivingEntity ? entity : null), stack, amount);
        NeoForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            int resultLevel;
            int diff;
            int currentExperience = this.getRelicExperience(stack);
            int currentLevel = this.getRelicLevel(stack);
            int toAdd = event.getAmount();
            int resultExperience = 0;
            for (resultLevel = currentLevel; toAdd > 0 && resultLevel < this.getLevelingData().getMaxLevel(); toAdd -= diff, ++resultLevel) {
                int requiredExperience = this.getTotalRelicExperienceBetweenLevels(resultLevel, resultLevel + 1);
                diff = requiredExperience - currentExperience;
                if (toAdd >= diff) {
                    currentExperience = 0;
                    continue;
                }
                resultExperience = currentExperience + toAdd;
                break;
            }
            this.setRelicExperience(stack, resultExperience);
            if (currentLevel != resultLevel) {
                this.setRelicLevel(stack, resultLevel);
                this.addRelicLevelingPoints(stack, resultLevel - currentLevel);
            }
            return true;
        }
        return false;
    }

    default public void spreadRelicExperience(@Nullable LivingEntity entity, ItemStack stack, int experience) {
        this.spreadRelicExperience(entity, stack, experience, 0.25);
    }

    default public void spreadRelicExperience(@Nullable LivingEntity entity, ItemStack stack, int experience, double percentage) {
        int toSpread;
        boolean isMaxLevel = this.isRelicMaxLevel(stack);
        int n = toSpread = isMaxLevel ? experience : (int)Math.ceil((double)experience * percentage);
        if (!isMaxLevel) {
            this.addRelicExperience(entity, stack, experience);
        }
        if (toSpread <= 0 || entity == null) {
            return;
        }
        ArrayList<ItemStack> relics = new ArrayList<ItemStack>();
        for (RelicContainer source : RegistryRegistry.RELIC_CONTAINER_REGISTRY.entrySet().stream().map(Map.Entry::getValue).toList()) {
            relics.addAll(source.gatherRelics().apply(entity).stream().filter(entry -> !this.isRelicMaxLevel((ItemStack)entry) && !stack.equals(entry)).toList());
        }
        if (relics.isEmpty()) {
            return;
        }
        ItemStack relicStack = (ItemStack)relics.get(entity.level().getRandom().nextInt(relics.size()));
        Item item = relicStack.getItem();
        if (item instanceof IRelicItem) {
            IRelicItem relic = (IRelicItem)item;
            relic.addRelicExperience(entity, relicStack, toSpread);
        }
    }

    default public void dropRelicExperience(Level level, Vec3 pos, int amount) {
        if (amount <= 0) {
            return;
        }
        RandomSource random = level.getRandom();
        int orbs = Math.max(amount / RelicExperienceOrbEntity.getMaxExperience(), random.nextInt(amount) + 1);
        for (int i = 0; i < orbs; ++i) {
            RelicExperienceOrbEntity orb = new RelicExperienceOrbEntity((EntityType<? extends RelicExperienceOrbEntity>)((EntityType)EntityRegistry.RELIC_EXPERIENCE_ORB.get()), level);
            orb.setPos(pos);
            orb.setExperience(amount / orbs);
            orb.setDeltaMovement((-1.0f + 2.0f * random.nextFloat()) * 0.15f, 0.1f + random.nextFloat() * 0.2f, (-1.0f + 2.0f * random.nextFloat()) * 0.15f);
            level.addFreshEntity((Entity)orb);
        }
    }

    default public int getRelicExperienceLeftForLevelUp(ItemStack stack, int level) {
        int currentLevel = this.getRelicLevel(stack);
        return this.getTotalRelicExperienceBetweenLevels(currentLevel, level) - this.getRelicExperience(stack);
    }

    default public int getTotalRelicExperienceBetweenLevels(int from, int to) {
        return this.getTotalRelicExperienceForLevel(to) - this.getTotalRelicExperienceForLevel(from);
    }

    default public int getTotalRelicExperienceForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        LevelingData levelingData = this.getLevelingData();
        if (levelingData == null) {
            return 0;
        }
        int result = levelingData.getInitialCost();
        for (int i = 1; i < level; ++i) {
            result += levelingData.getInitialCost() + levelingData.getStep() * i;
        }
        return result;
    }

    default public int getRelicLevelFromExperience(int experience) {
        int amount;
        int result = 0;
        while ((amount = this.getTotalRelicExperienceForLevel(++result)) <= experience) {
        }
        return result - 1;
    }

    default public boolean isRelicMaxLevel(ItemStack stack) {
        return this.getRelicLevel(stack) >= this.getLevelingData().getMaxLevel();
    }

    default public boolean isRelicMaxQuality(ItemStack stack) {
        return this.getRelicQuality(stack) >= this.getMaxQuality();
    }

    default public boolean isRelicFlawless(ItemStack stack) {
        return this.isRelicMaxLevel(stack) && this.isRelicMaxQuality(stack);
    }

    default public boolean isAbilityMaxLevel(ItemStack stack, String ability) {
        return this.getAbilityLevel(stack, ability) >= this.getAbilityData(ability).getMaxLevel();
    }

    default public boolean isAbilityMaxQuality(ItemStack stack, String ability) {
        return this.getAbilityQuality(stack, ability) >= this.getMaxQuality();
    }

    default public boolean isAbilityFlawless(ItemStack stack, String ability) {
        return this.isAbilityMaxLevel(stack, ability) && this.isAbilityMaxQuality(stack, ability);
    }

    default public CastData getAbilityCastData(String ability) {
        return this.getAbilityData(ability).getCastData();
    }

    default public Map<String, Pair<PredicateType, BiFunction<Player, ItemStack, Boolean>>> getAbilityPredicates(String ability) {
        return this.getAbilityCastData(ability).getPredicates();
    }

    default public Map<String, BiFunction<Player, ItemStack, Boolean>> getAbilityPredicates(String ability, PredicateType type) {
        return this.getAbilityPredicates(ability).entrySet().stream().filter(entry -> ((Pair)entry.getValue()).getKey() == type).collect(Collectors.toMap(Map.Entry::getKey, entry -> (BiFunction)((Pair)entry.getValue()).getValue()));
    }

    default public boolean testAbilityPredicate(Player player, ItemStack stack, String ability, String predicate) {
        return (Boolean)((BiFunction)this.getAbilityPredicates(ability).get(predicate).getValue()).apply(player, stack);
    }

    default public boolean testAbilityPredicates(Player player, ItemStack stack, String ability, PredicateType type) {
        for (Map.Entry<String, BiFunction<Player, ItemStack, Boolean>> entry : this.getAbilityPredicates(ability, type).entrySet()) {
            if (this.testAbilityPredicate(player, stack, ability, entry.getKey())) continue;
            return false;
        }
        return true;
    }

    default public DataComponent getDataComponent(ItemStack stack) {
        return (DataComponent)stack.getOrDefault(DataComponentRegistry.DATA, (Object)DataComponent.EMPTY);
    }

    default public void setDataComponent(ItemStack stack, DataComponent component) {
        stack.set(DataComponentRegistry.DATA, (Object)component);
    }

    default public LevelingComponent getLevelingComponent(ItemStack stack) {
        return this.getDataComponent(stack).leveling();
    }

    default public void setLevelingComponent(ItemStack stack, LevelingComponent component) {
        this.setDataComponent(stack, this.getDataComponent(stack).toBuilder().leveling(component).build());
    }

    default public AbilitiesComponent getAbilitiesComponent(ItemStack stack) {
        return this.getDataComponent(stack).abilities();
    }

    default public void setAbilitiesComponent(ItemStack stack, AbilitiesComponent component) {
        this.setDataComponent(stack, this.getDataComponent(stack).toBuilder().abilities(component).build());
    }

    default public AbilityComponent getAbilityComponent(ItemStack stack, String ability) {
        AbilitiesComponent abilitiesComponent = this.getAbilitiesComponent(stack);
        AbilityComponent abilityComponent = abilitiesComponent.abilities().get(ability);
        AbilityData abilityData = this.getAbilityData(ability);
        if (abilityComponent != null) {
            return abilityComponent;
        }
        if (abilityData != null) {
            AbilityComponent.AbilityComponentBuilder builder = AbilityComponent.EMPTY.toBuilder();
            if (abilityData.getCastData().getType() == CastType.TOGGLEABLE) {
                builder.ticking(true);
            }
            abilityComponent = builder.build();
            this.setAbilitiesComponent(stack, abilitiesComponent.toBuilder().ability(ability, abilityComponent).build());
            return abilityComponent;
        }
        return null;
    }

    default public void setAbilityComponent(ItemStack stack, String ability, AbilityComponent component) {
        this.setAbilitiesComponent(stack, this.getAbilitiesComponent(stack).toBuilder().ability(ability, component).build());
    }

    default public StatComponent getStatComponent(ItemStack stack, String ability, String stat) {
        AbilityComponent abilityComponent = this.getAbilityComponent(stack, ability);
        StatComponent statComponent = abilityComponent.stats().get(stat);
        StatData statData = this.getStatData(ability, stat);
        if (statComponent != null) {
            return statComponent;
        }
        if (statData != null) {
            statComponent = StatComponent.EMPTY.toBuilder().initialValue(MathUtils.round(MathUtils.randomBetween(new Random(), (Double)statData.getInitialValue().getKey(), (Double)statData.getInitialValue().getValue()), 5)).build();
            this.setAbilityComponent(stack, ability, abilityComponent.toBuilder().stat(stat, statComponent).build());
            return statComponent;
        }
        return null;
    }

    default public void setStatComponent(ItemStack stack, String ability, String stat, StatComponent component) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().stat(stat, component).build());
    }

    default public double getStatInitialValue(ItemStack stack, String ability, String stat) {
        return this.getStatComponent(stack, ability, stat).initialValue();
    }

    default public void setStatInitialValue(ItemStack stack, String ability, String stat, double value) {
        this.setStatComponent(stack, ability, stat, this.getStatComponent(stack, ability, stat).toBuilder().initialValue(value).build());
    }

    default public void addStatInitialValue(ItemStack stack, String ability, String stat, double value) {
        this.setStatInitialValue(stack, ability, stat, this.getStatInitialValue(stack, ability, stat) + value);
    }

    default public int getAbilityLevel(ItemStack stack, String ability) {
        return this.getAbilityComponent(stack, ability).points();
    }

    default public void setAbilityLevel(ItemStack stack, String ability, int points) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().points(points).build());
    }

    default public void addAbilityLevel(ItemStack stack, String ability, int points) {
        this.setAbilityLevel(stack, ability, this.getAbilityLevel(stack, ability) + points);
    }

    default public AbilityComponent randomizeAbilityStats(ItemStack stack, String ability, int luck) {
        int maxQuality;
        double modifier;
        int maxLuck;
        double bias;
        double randomValue;
        double biasedValue;
        double weightedRandom;
        double targetQuality;
        Map<String, StatData> stats = this.getAbilityData(ability).getStats();
        Random random = new Random();
        do {
            maxQuality = this.getMaxQuality();
            maxLuck = this.getMaxLuck();
        } while ((targetQuality = Mth.clamp((double)(weightedRandom = Math.floor(((biasedValue = Math.tanh((randomValue = random.nextDouble() * 2.0 - 1.0) + (bias = ((double)luck - (double)maxLuck / 2.0) / (double)maxLuck * (modifier = this.getLuckModifier())))) + 1.0) / 2.0 * ((double)maxQuality + 1.0))), (double)0.0, (double)maxQuality)) == (double)this.getAbilityQuality(stack, ability));
        double sumQuality = 0.0;
        HashMap<String, Double> generatedQualities = new HashMap<String, Double>();
        for (String stat : stats.keySet()) {
            double randomQuality = MathUtils.randomBetween(random, 0, this.getMaxQuality());
            generatedQualities.put(stat, randomQuality);
            sumQuality += randomQuality;
        }
        double currentAverageQuality = sumQuality / (double)stats.size();
        while (Math.abs(currentAverageQuality - targetQuality) > 0.01) {
            if (currentAverageQuality < targetQuality) {
                String minStat = (String)generatedQualities.entrySet().stream().min(Map.Entry.comparingByValue()).get().getKey();
                double increment = Math.min((targetQuality - currentAverageQuality) * (double)stats.size(), (double)this.getMaxQuality() - (Double)generatedQualities.get(minStat));
                generatedQualities.put(minStat, (Double)generatedQualities.get(minStat) + increment);
            } else if (currentAverageQuality > targetQuality) {
                String maxStat = (String)generatedQualities.entrySet().stream().max(Map.Entry.comparingByValue()).get().getKey();
                double decrement = Math.min((currentAverageQuality - targetQuality) * (double)stats.size(), (Double)generatedQualities.get(maxStat));
                generatedQualities.put(maxStat, (Double)generatedQualities.get(maxStat) - decrement);
            }
            sumQuality = generatedQualities.values().stream().mapToDouble(Double::doubleValue).sum();
            currentAverageQuality = sumQuality / (double)stats.size();
        }
        for (Map.Entry entry : generatedQualities.entrySet()) {
            this.randomizeStat(stack, ability, (String)entry.getKey(), (int)Math.round((Double)entry.getValue()));
        }
        return this.getAbilityComponent(stack, ability);
    }

    default public StatComponent randomizeStat(ItemStack stack, String ability, String stat, int quality) {
        StatData entry = this.getStatData(ability, stat);
        double minValue = (Double)entry.getInitialValue().getKey();
        double maxValue = (Double)entry.getInitialValue().getValue();
        double diff = maxValue - minValue;
        double result = minValue + diff * ((double)quality / (double)this.getMaxQuality());
        this.setStatInitialValue(stack, ability, stat, result);
        return this.getStatComponent(stack, ability, stat);
    }

    default public StatComponent randomizeStat(ItemStack stack, String ability, String stat) {
        return this.randomizeStat(stack, ability, stat, new Random().nextInt(this.getMaxQuality() + 1));
    }

    default public double getStatValue(ItemStack stack, String ability, String stat, int points) {
        StatData data = this.getStatData(ability, stat);
        double result = 0.0;
        if (data == null) {
            return result;
        }
        double current = this.getStatInitialValue(stack, ability, stat);
        double step = (Double)data.getUpgradeModifier().getValue();
        switch ((UpgradeOperation)((Object)data.getUpgradeModifier().getKey())) {
            case ADD: {
                result = current + (double)points * step;
                break;
            }
            case MULTIPLY_BASE: {
                result = current + current * step * (double)points;
                break;
            }
            case MULTIPLY_TOTAL: {
                result = current * Math.pow(step + 1.0, points);
            }
        }
        Pair<Double, Double> threshold = data.getThresholdValue();
        return MathUtils.round(Mth.clamp((double)result, (double)((Double)threshold.getKey()), (double)((Double)threshold.getValue())), 5);
    }

    default public double getStatValue(ItemStack stack, String ability, String stat) {
        return this.getStatValue(stack, ability, stat, this.getAbilityLevel(stack, ability));
    }

    @Deprecated(since="1.21", forRemoval=true)
    default public boolean canUseAbility(ItemStack stack, String ability) {
        return this.getRelicLevel(stack) >= this.getAbilityData(ability).getRequiredLevel();
    }

    default public boolean canUseAbility(Player player, ItemStack stack, String ability) {
        return this.canUseAbility(stack, ability) && this.testAbilityPredicates(player, stack, ability, PredicateType.CAST) && this.getAbilityCooldown(stack, ability) <= 0;
    }

    default public boolean canSeeAbility(Player player, ItemStack stack, String ability) {
        return this.testAbilityPredicates(player, stack, ability, PredicateType.VISIBILITY);
    }

    default public int getUpgradeRequiredLevel(ItemStack stack, String ability) {
        return this.getAbilityLevel(stack, ability) * 2 + 5;
    }

    default public boolean mayUpgrade(ItemStack stack, String ability) {
        AbilityData entry = this.getAbilityData(ability);
        return !entry.getStats().isEmpty() && !this.isAbilityMaxLevel(stack, ability) && this.getRelicLevelingPoints(stack) >= entry.getRequiredPoints() && this.canUseAbility(stack, ability);
    }

    default public boolean mayPlayerUpgrade(Player player, ItemStack stack, String ability) {
        return this.mayUpgrade(stack, ability) && player.experienceLevel >= this.getUpgradeRequiredLevel(stack, ability);
    }

    default public boolean upgrade(Player player, ItemStack stack, String ability) {
        if (!this.mayPlayerUpgrade(player, stack, ability)) {
            return false;
        }
        player.giveExperienceLevels(-this.getUpgradeRequiredLevel(stack, ability));
        this.setAbilityLevel(stack, ability, this.getAbilityLevel(stack, ability) + 1);
        this.addRelicLevelingPoints(stack, -this.getAbilityData(ability).getRequiredPoints());
        return true;
    }

    default public int getRerollRequiredLevel(ItemStack stack, String ability) {
        return (int)Math.floor((double)this.getRelicLuck(stack) / 25.0) + 1;
    }

    default public boolean mayReroll(ItemStack stack, String ability) {
        return !this.getAbilityData(ability).getStats().isEmpty() && this.canUseAbility(stack, ability);
    }

    default public boolean mayPlayerReroll(Player player, ItemStack stack, String ability) {
        return this.mayReroll(stack, ability) && player.experienceLevel >= this.getRerollRequiredLevel(stack, ability);
    }

    default public boolean reroll(Player player, ItemStack stack, String ability) {
        if (!this.mayPlayerReroll(player, stack, ability)) {
            return false;
        }
        player.giveExperienceLevels(-this.getRerollRequiredLevel(stack, ability));
        int prevQuality = this.getAbilityQuality(stack, ability);
        this.randomizeAbilityStats(stack, ability, this.getRelicLuck(stack));
        int newQuality = this.getAbilityQuality(stack, ability);
        if (newQuality < prevQuality) {
            this.addRelicLuck(stack, (int)Math.ceil((double)(prevQuality - newQuality) / 2.0));
        }
        return true;
    }

    default public int getResetRequiredLevel(ItemStack stack, String ability) {
        return this.getAbilityLevel(stack, ability) * 5;
    }

    default public boolean mayReset(ItemStack stack, String ability) {
        return this.getAbilityLevel(stack, ability) > 0 && this.canUseAbility(stack, ability);
    }

    default public boolean mayPlayerReset(Player player, ItemStack stack, String ability) {
        return !this.getAbilityData(ability).getStats().isEmpty() && this.mayReset(stack, ability) && player.experienceLevel >= this.getResetRequiredLevel(stack, ability);
    }

    default public boolean reset(Player player, ItemStack stack, String ability) {
        if (!this.mayPlayerReset(player, stack, ability)) {
            return false;
        }
        player.giveExperienceLevels(-this.getResetRequiredLevel(stack, ability));
        this.addRelicLevelingPoints(stack, this.getAbilityLevel(stack, ability) * this.getAbilityData(ability).getRequiredPoints());
        this.setAbilityLevel(stack, ability, 0);
        return true;
    }

    default public int getAbilityCooldownCap(ItemStack stack, String ability) {
        return this.getAbilityComponent(stack, ability).cooldownCap();
    }

    default public void setAbilityCooldownCap(ItemStack stack, String ability, int amount) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().cooldownCap(amount).build());
    }

    default public int getAbilityCooldown(ItemStack stack, String ability) {
        return this.getAbilityComponent(stack, ability).cooldown();
    }

    default public void setAbilityCooldown(ItemStack stack, String ability, int amount) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().cooldownCap(amount).cooldown(amount).build());
    }

    default public void addAbilityCooldown(ItemStack stack, String ability, int amount) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().cooldown(this.getAbilityCooldown(stack, ability) + amount).build());
    }

    default public void setAbilityTicking(ItemStack stack, String ability, boolean ticking) {
        this.setAbilityComponent(stack, ability, this.getAbilityComponent(stack, ability).toBuilder().ticking(ticking).build());
    }

    default public boolean isAbilityTicking(ItemStack stack, String ability) {
        return this.getAbilityComponent(stack, ability).ticking();
    }

    default public boolean isAbilityOnCooldown(ItemStack stack, String ability) {
        return this.getAbilityCooldown(stack, ability) > 0;
    }
}

