/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics;

import com.google.common.collect.Lists;
import it.hurts.sskirillss.relics.entities.ShadowGlaiveEntity;
import it.hurts.sskirillss.relics.entities.ShadowSawEntity;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import top.theillusivec4.curios.api.SlotContext;

public class ShadowGlaiveItem
extends RelicItem {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("glaive").stat(StatData.builder("recharge").icon(StatIcons.DURATION).initialValue(30.0, 10.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.09).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("bounces").icon(StatIcons.REFLECT).initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("damage").icon(StatIcons.DEALT_DAMAGE).initialValue(2.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).stat(StatData.builder("radius").icon(StatIcons.DISTANCE).initialValue(2.5, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability(AbilityData.builder("saw").requiredLevel(5).stat(StatData.builder("speed").icon(StatIcons.SPEED).initialValue(20.0, 15.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> MathUtils.round(value / 20.0, 2)).build()).stat(StatData.builder("damage").icon(StatIcons.DEALT_DAMAGE).initialValue(0.75, 1.5).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.END).entry(LootCollections.SCULK).build()).build();
    }

    @Override
    public List<ItemStack> processCreativeTab() {
        ItemStack stack = this.getDefaultInstance();
        stack.set(DataComponentRegistry.CHARGE, (Object)8);
        return Lists.newArrayList((Object[])new ItemStack[]{stack});
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (worldIn.isClientSide()) {
            return;
        }
        int charges = (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0);
        if (entityIn.tickCount % 20 != 0 || charges >= 8) {
            return;
        }
        int time = (Integer)stack.getOrDefault(DataComponentRegistry.TIME, (Object)0);
        if (this.getSaw(stack, worldIn) != null) {
            return;
        }
        if ((double)time >= this.getStatValue(stack, "glaive", "recharge")) {
            stack.set(DataComponentRegistry.CHARGE, (Object)(charges + 1));
            stack.set(DataComponentRegistry.TIME, (Object)0);
        } else {
            stack.set(DataComponentRegistry.TIME, (Object)(++time));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        int charges = (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0);
        RandomSource random = playerIn.getRandom();
        if (playerIn.getCooldowns().isOnCooldown(stack.getItem())) {
            return InteractionResultHolder.fail((Object)stack);
        }
        ShadowSawEntity entity = this.getSaw(stack, worldIn);
        if (entity != null) {
            if (!entity.isReturning) {
                entity.isReturning = true;
            }
        } else if (playerIn.isShiftKeyDown() && this.canUseAbility(stack, "saw")) {
            if (charges == 8 && this.getSaw(stack, worldIn) == null) {
                ShadowSawEntity saw = new ShadowSawEntity(stack, (LivingEntity)playerIn);
                saw.setStack(stack);
                saw.setOwner((Entity)playerIn);
                saw.teleportTo(playerIn.getX(), playerIn.getY() + (double)(playerIn.getBbHeight() * 0.5f), playerIn.getZ());
                saw.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.75f, 1.0f, 0.0f);
                worldIn.addFreshEntity((Entity)saw);
                worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)SoundRegistry.THROW.get(), SoundSource.MASTER, 0.5f, 0.35f + random.nextFloat() * 0.25f);
                stack.set(DataComponentRegistry.CHARGE, (Object)0);
                stack.set(DataComponentRegistry.SAW, (Object)saw.getStringUUID());
            }
        } else if (charges > 0) {
            Entity entity2;
            ShadowGlaiveEntity glaive = new ShadowGlaiveEntity(worldIn, (LivingEntity)playerIn);
            glaive.setStack(stack);
            glaive.setOwner((Entity)playerIn);
            glaive.teleportTo(playerIn.getX(), playerIn.getY() + (double)(playerIn.getBbHeight() * 0.5f), playerIn.getZ());
            glaive.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.75f, 1.0f, 0.0f);
            worldIn.addFreshEntity((Entity)glaive);
            EntityHitResult result = EntityUtils.rayTraceEntity((Entity)playerIn, entry -> !EntityUtils.isAlliedTo((Entity)playerIn, entry), 32.0);
            if (result != null && (entity2 = result.getEntity()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity2;
                glaive.setTarget(target);
            }
            worldIn.playSound(null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)SoundRegistry.THROW.get(), SoundSource.MASTER, 0.5f, 0.75f + random.nextFloat() * 0.5f);
            stack.set(DataComponentRegistry.CHARGE, (Object)(charges - 1));
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Nullable
    public ShadowSawEntity getSaw(ItemStack stack, Level level) {
        try {
            UUID uuid = UUID.fromString((String)stack.getOrDefault(DataComponentRegistry.SAW, (Object)""));
            if (level.isClientSide()) {
                return null;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.getEntity(uuid);
            if (entity instanceof ShadowSawEntity) {
                ShadowSawEntity saw = (ShadowSawEntity)entity;
                return saw;
            }
            stack.set(DataComponentRegistry.SAW, (Object)"");
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return false;
    }
}

