/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.init;

import it.hurts.sskirillss.relics.client.gui.layers.ActiveAbilitiesLayer;
import it.hurts.sskirillss.relics.client.gui.layers.InfoTileLayer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.layers.WingsLayer;
import it.hurts.sskirillss.relics.client.renderer.entities.BlockSimulationRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.DissectionRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.NullRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.RelicExperienceOrbRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.ShadowGlaiveRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.ShadowSawRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.SolidSnowballRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.SporeRenderer;
import it.hurts.sskirillss.relics.client.renderer.entities.StalactiteRenderer;
import it.hurts.sskirillss.relics.client.renderer.items.items.CurioRenderer;
import it.hurts.sskirillss.relics.client.renderer.tiles.ResearchingTableRenderer;
import it.hurts.sskirillss.relics.init.BlockRegistry;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.TileRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@EventBusSubscriber(modid="relics", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class RemoteRegistry {
    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockRegistry.RESEARCHING_TABLE.get()), (RenderType)RenderType.cutout());
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ItemRegistry.INFINITY_HAM.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"pieces"), (stack, world, entity, id) -> Math.min(10, (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0)));
            ItemProperties.register((Item)((Item)ItemRegistry.SHADOW_GLAIVE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"charges"), (stack, world, entity, id) -> Math.min(8, (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0)));
            ItemProperties.register((Item)((Item)ItemRegistry.MAGIC_MIRROR.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"world"), (stack, world, entity, id) -> {
                Entity e = Minecraft.getInstance().getCameraEntity();
                if (e == null) {
                    return 0.0f;
                }
                return switch (e.getCommandSenderWorld().dimension().location().getPath()) {
                    case "overworld" -> 1.0f;
                    case "the_nether" -> 2.0f;
                    case "the_end" -> 3.0f;
                    default -> 0.0f;
                };
            });
            ItemProperties.register((Item)((Item)ItemRegistry.SHADOW_GLAIVE.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"charges"), (stack, world, entity, id) -> Math.min(8, (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0)));
            ItemProperties.register((Item)((Item)ItemRegistry.MAGMA_WALKER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"heat"), (stack, world, entity, id) -> (double)((Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0)).intValue() >= ((IRelicItem)stack.getItem()).getStatValue(stack, "pace", "time") ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemRegistry.AQUA_WALKER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"drench"), (stack, world, entity, id) -> (double)((Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0)).intValue() >= ((IRelicItem)stack.getItem()).getStatValue(stack, "walking", "time") ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemRegistry.ELYTRA_BOOSTER.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"fuel"), (stack, world, entity, id) -> (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0) > 0 ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemRegistry.SOLID_SNOWBALL.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"snow"), (stack, world, entity, id) -> {
                ItemStack relic = EntityUtils.findEquippedCurio((Entity)entity, (Item)ItemRegistry.WOOL_MITTEN.get());
                if (relic.isEmpty()) {
                    return 3.0f;
                }
                return (int)Math.floor((double)((Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0)).intValue() / (((IRelicItem)relic.getItem()).getStatValue(relic, "mold", "size") / 3.0));
            });
            ItemProperties.register((Item)((Item)ItemRegistry.ROLLER_SKATES.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"active"), (stack, world, entity, id) -> (Integer)stack.getOrDefault(DataComponentRegistry.CHARGE, (Object)0) > 0 ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ItemRegistry.BLAZING_FLASK.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"active"), (stack, world, entity, id) -> stack.get(DataComponentRegistry.WORLD_POSITION) == null ? 0.0f : 1.0f);
        });
        for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
            if (!(item instanceof IRenderableCurio)) continue;
            CuriosRendererRegistry.register((Item)item, CurioRenderer::new);
        }
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
            if (!(item instanceof IRenderableCurio)) continue;
            IRenderableCurio renderable = (IRenderableCurio)item;
            event.registerLayerDefinition(CurioModel.getLayerLocation(item), renderable::constructLayerDefinition);
        }
    }

    @SubscribeEvent
    public static void onPlayerRendererRegister(EntityRenderersEvent.AddLayers event) {
        for (PlayerSkin.Model skinType : event.getSkins()) {
            EntityRenderer renderer = event.getSkin(skinType);
            if (!(renderer instanceof PlayerRenderer)) continue;
            PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
            playerRenderer.addLayer(new WingsLayer(playerRenderer));
        }
    }

    @SubscribeEvent
    public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityRegistry.SHADOW_GLAIVE.get(), ShadowGlaiveRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.BLOCK_SIMULATION.get(), BlockSimulationRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.SHOCKWAVE.get(), NullRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.LIFE_ESSENCE.get(), NullRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.DEATH_ESSENCE.get(), NullRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.STALACTITE.get(), StalactiteRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.DISSECTION.get(), DissectionRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.SPORE.get(), SporeRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.SHADOW_SAW.get(), ShadowSawRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.SOLID_SNOWBALL.get(), SolidSnowballRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.RELIC_EXPERIENCE_ORB.get(), RelicExperienceOrbRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.THROWN_RELIC_EXPERIENCE_BOTTLE.get(), ThrownItemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TileRegistry.RESEARCHING_TABLE.get(), ResearchingTableRenderer::new);
    }

    @SubscribeEvent
    public static void onOverlayRegistry(RegisterGuiLayersEvent event) {
        event.registerBelowAll(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"info_tile"), (LayeredDraw.Layer)new InfoTileLayer());
        event.registerBelowAll(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"active_abilities"), (LayeredDraw.Layer)new ActiveAbilitiesLayer());
    }
}

