/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.init;

import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.ICreativeTabEntry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CreativeTabRegistry {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"relics");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> RELICS_TAB = CREATIVE_TABS.register("relics", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.relics")).icon(() -> ((RelicItem)ItemRegistry.BASTION_RING.get()).getDefaultInstance()).build());

    public static void register(IEventBus bus) {
        CREATIVE_TABS.register(bus);
        bus.addListener(CreativeTabRegistry::fillCreativeTabs);
    }

    private static void fillCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == RELICS_TAB.get()) {
            for (Item item : BuiltInRegistries.ITEM.stream().toList()) {
                if (!(item instanceof ICreativeTabEntry)) continue;
                ICreativeTabEntry entry = (ICreativeTabEntry)item;
                event.acceptAll(entry.processCreativeTab());
            }
        }
    }
}

