/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;

public class RelicExperienceWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private static final int FILLER_WIDTH = 125;
    private final RelicDescriptionScreen screen;

    public RelicExperienceWidget(int x, int y, RelicDescriptionScreen screen) {
        super(x, y, 139, 15);
        this.screen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = this.screen.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float color = (float)((double)1.025f + Math.sin((float)player.tickCount * 0.5f) * (double)0.05f);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        RenderSystem.enableBlend();
        guiGraphics.blit(DescriptionTextures.EXPERIENCE_FILLER, this.getX() + 3, this.getY() + 2, 0.0f, 0.0f, this.calculateFillerWidth(relic), 11, 125, 11);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isHovered()) {
            guiGraphics.blit(DescriptionTextures.EXPERIENCE_OUTLINE, this.getX() - 1, this.getY() - 6, 0.0f, 0.0f, 141, 23, 141, 23);
        }
        poseStack.scale(0.5f, 0.5f, 0.5f);
        MutableComponent percentage = Component.literal((String)(relic.isRelicMaxLevel(this.screen.stack) ? "MAX" : MathUtils.round(this.calculateFillerPercentage(relic), 1) + "%")).withStyle(ChatFormatting.BOLD);
        guiGraphics.drawString(this.MC.font, (Component)percentage, (this.getX() + 67) * 2 - this.MC.font.width((FormattedText)percentage) / 2, (this.getY() + 6) * 2, 6696723, false);
        poseStack.popPose();
    }

    @Override
    public void onTick() {
        IRelicItem relic;
        block6: {
            block5: {
                Item item = this.screen.stack.getItem();
                if (!(item instanceof IRelicItem)) break block5;
                relic = (IRelicItem)item;
                if (this.MC.player != null) break block6;
            }
            return;
        }
        RandomSource random = this.MC.player.getRandom();
        int fillerWidth = this.calculateFillerWidth(relic);
        if (this.MC.player.tickCount % 5 == 0) {
            for (float i = 0.0f; i < (float)fillerWidth / 40.0f; i += 1.0f) {
                ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200, 255, 0), this.getX() + 5 + random.nextInt(fillerWidth), this.getY() + random.nextInt(2), 1.0f + random.nextFloat() * 0.25f, 50 + random.nextInt(50)));
            }
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 150;
        int renderWidth = 0;
        int level = relic.getRelicLevel(this.screen.stack);
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.experience.title").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)).append(" " + (String)(relic.isRelicMaxLevel(this.screen.stack) ? "MAX" : relic.getRelicExperience(this.screen.stack) + "/" + relic.getTotalRelicExperienceBetweenLevels(level, level + 1))), Component.literal((String)" ")});
        if (Screen.hasShiftDown()) {
            entries.add(Component.translatable((String)"tooltip.relics.researching.relic.experience.extra_info").withStyle(ChatFormatting.ITALIC));
        } else {
            entries.add(Component.translatable((String)"tooltip.relics.researching.general.extra_info"));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.MC.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.MC.font.split((FormattedText)entry, maxWidth * 2));
        }
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, tooltip.size() * 5, mouseX - 9 - renderWidth / 2, mouseY);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.MC.font, entry, (mouseX - renderWidth / 2 + 1) * 2, (mouseY + yOff + 9) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.popPose();
    }

    @Override
    public void playDownSound(SoundManager handler) {
    }

    private float calculateFillerPercentage(IRelicItem relic) {
        int level = relic.getRelicLevel(this.screen.stack);
        return (float)relic.getRelicExperience(this.screen.stack) / ((float)relic.getTotalRelicExperienceBetweenLevels(level, level + 1) / 100.0f);
    }

    private int calculateFillerWidth(IRelicItem relic) {
        return relic.isRelicMaxLevel(this.screen.stack) ? 125 : (int)Math.ceil(this.calculateFillerPercentage(relic) / 100.0f * 125.0f);
    }
}

