/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.relic;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.ITickingWidget;
import it.hurts.sskirillss.relics.client.screen.description.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.widgets.base.AbstractDescriptionWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class AbilityCardWidget
extends AbstractDescriptionWidget
implements IHoverableWidget,
ITickingWidget {
    private final RelicDescriptionScreen screen;
    private final String ability;
    private float scale = 1.0f;
    private float scaleOld = 1.0f;
    private int shakeDelta = 0;

    public AbilityCardWidget(int x, int y, RelicDescriptionScreen screen, String ability) {
        super(x, y, 32, 47);
        this.screen = screen;
        this.ability = ability;
    }

    @Override
    public void onPress() {
        IRelicItem relic;
        Item item = this.screen.getStack().getItem();
        if (item instanceof IRelicItem && (relic = (IRelicItem)item).canUseAbility(this.screen.stack, this.ability)) {
            this.MC.setScreen((Screen)new AbilityDescriptionScreen((Player)this.MC.player, this.screen.container, this.screen.slot, this.screen.screen, this.ability));
        } else {
            this.shakeDelta = Math.min(20, this.shakeDelta + (this.shakeDelta > 0 ? 5 : 15));
            this.MC.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.CHAIN_BREAK, (float)1.0f));
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Item item;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || !((item = this.screen.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        TextureManager manager = this.MC.getTextureManager();
        PoseStack poseStack = guiGraphics.pose();
        boolean canUse = relic.canUseAbility(this.screen.stack, this.ability);
        boolean canUpgrade = relic.mayPlayerUpgrade((Player)this.MC.player, this.screen.stack, this.ability);
        ResourceLocation card = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/abilities/" + BuiltInRegistries.ITEM.getKey((Object)this.screen.stack.getItem()).getPath() + "/" + (String)relic.getAbilityData(this.ability).getIcon().apply((Object)this.MC.player, (Object)this.screen.stack, (Object)this.ability) + ".png"));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.pushPose();
        float partialTicks = this.MC.getTimer().getGameTimeDeltaPartialTick(false);
        float lerpedScale = Mth.lerp((float)partialTicks, (float)this.scaleOld, (float)this.scale);
        poseStack.scale(lerpedScale, lerpedScale, lerpedScale);
        poseStack.translate(((float)this.getX() + (float)this.width / 2.0f) / lerpedScale, ((float)this.getY() + (float)this.height / 2.0f) / lerpedScale, 0.0f);
        float color = canUse ? (float)((double)1.05f + Math.sin((float)(player.tickCount + this.ability.length() * 10) * 0.2f) * (double)0.1f) : (canUpgrade ? 0.5f : 0.25f);
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        guiGraphics.blit(card, -11, -16, 0.0f, 0.0f, 22, 31, 22, 31);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(canUse ? DescriptionTextures.SMALL_CARD_FRAME_ACTIVE : DescriptionTextures.SMALL_CARD_FRAME_INACTIVE, -(this.width / 2), -(this.height / 2) - 1, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        if (!canUse) {
            guiGraphics.blit(DescriptionTextures.CHAINS, -(this.width / 2), -(this.height / 2) + 1, 0.0f, 0.0f, 32, 41, 32, 41);
            MutableComponent level = Component.literal((String)String.valueOf(relic.getAbilityData(this.ability).getRequiredLevel())).withStyle(ChatFormatting.BOLD);
            color = (float)this.shakeDelta * 0.04f;
            RenderSystem.setShaderColor((float)1.0f, (float)(1.0f - color), (float)(1.0f - color), (float)1.0f);
            poseStack.pushPose();
            if (this.shakeDelta > 0) {
                poseStack.mulPose(Axis.ZP.rotation((float)Math.sin(((float)player.tickCount + partialTick) * 0.75f) * 0.1f));
            }
            guiGraphics.blit(DescriptionTextures.LOCK_INACTIVE, -(this.width / 2) + 9, -(this.height / 2) + 14, 0.0f, 0.0f, 14, 17, 14, 17);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(this.MC.font, (Component)level, (-(this.width / 2) + 16) * 2 - this.MC.font.width((FormattedText)level) / 2, (-(this.height / 2) + 24) * 2, 12037849, true);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.popPose();
        }
        if (canUpgrade) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.UPGRADE);
            manager.bindForSetup(DescriptionTextures.UPGRADE);
            RenderSystem.enableBlend();
            RenderUtils.renderAnimatedTextureFromCenter(poseStack, 0.0f, -1.0f, 20.0f, 400.0f, 20.0f, 20.0f, 0.9f + (float)(Math.sin(((float)player.tickCount + partialTick) * 0.25f) * (double)0.025f), AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2).frame(14, 2).frame(15, 2).frame(16, 2).frame(17, 2).frame(18, 2).frame(19, 2));
            RenderSystem.disableBlend();
        }
        int xOff = 0;
        for (int i = 0; i < 5; ++i) {
            guiGraphics.blit(DescriptionTextures.SMALL_STAR_HOLE, -(this.width / 2) + xOff + 4, -(this.height / 2) + 40, 0.0f, 0.0f, 4, 4, 4, 4);
            xOff += 5;
        }
        xOff = 0;
        int quality = relic.getAbilityQuality(this.screen.stack, this.ability);
        boolean isAliquot = quality % 2 == 1;
        int i = 0;
        while ((double)i < Math.floor((double)quality / 2.0)) {
            guiGraphics.blit(canUse ? DescriptionTextures.SMALL_STAR_ACTIVE : DescriptionTextures.SMALL_STAR_INACTIVE, -(this.width / 2) + xOff + 4, -(this.height / 2) + 40, 0.0f, 0.0f, 4, 4, 4, 4);
            xOff += 5;
            ++i;
        }
        if (isAliquot) {
            guiGraphics.blit(canUse ? DescriptionTextures.SMALL_STAR_ACTIVE : DescriptionTextures.SMALL_STAR_INACTIVE, -(this.width / 2) + xOff + 4, -(this.height / 2) + 40, 0.0f, 0.0f, 2, 4, 4, 4);
        }
        if (this.isHovered()) {
            guiGraphics.blit(DescriptionTextures.SMALL_CARD_FRAME_OUTLINE, -(this.width / 2) - 1, -(this.height / 2) - 2, 0.0f, 0.0f, this.width + 2, this.height + 3, this.width + 2, this.height + 3);
        }
        MutableComponent title = Component.literal((String)(canUse ? String.valueOf(relic.getAbilityLevel(this.screen.stack, this.ability)) : "?")).withStyle(ChatFormatting.BOLD);
        float textScale = 0.5f;
        poseStack.scale(textScale, textScale, textScale);
        guiGraphics.drawString(this.MC.font, (Component)title, -((this.width + 1) / 2) - this.MC.font.width((FormattedText)title) / 2 + 16, -(this.height / 2) - 19, canUse ? 16769656 : 12037849, true);
        poseStack.popPose();
    }

    @Override
    public void onTick() {
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        float maxScale = 1.1f;
        float minScale = 1.0f;
        RandomSource random = this.MC.player.getRandom();
        if (relic.mayPlayerUpgrade((Player)this.MC.player, this.screen.stack, this.ability) && this.MC.player.tickCount % 7 == 0) {
            ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0), this.getX() + 5 + random.nextInt(18), this.getY() + 18, 1.0f + random.nextFloat() * 0.5f, 100 + random.nextInt(50)));
        }
        this.scaleOld = this.scale;
        if (this.isHovered()) {
            if (this.MC.player.tickCount % 3 == 0) {
                ParticleStorage.addParticle(this.screen, new ExperienceParticleData(new Color(200 + random.nextInt(50), 150 + random.nextInt(100), 0), this.getX() + random.nextInt(this.width), this.getY() - 1, 1.0f + random.nextFloat() * 0.5f, 100 + random.nextInt(50)));
            }
            if (this.scale < maxScale) {
                this.scale = Math.min(maxScale, this.scale + 0.04f);
            }
        } else if (this.scale > minScale) {
            this.scale = Math.max(minScale, this.scale - 0.03f);
        }
        if (this.shakeDelta > 0) {
            --this.shakeDelta;
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int requiredLevel;
        Item item = this.screen.stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        AbilityData data = relic.getAbilityData(this.ability);
        if (data == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 110;
        int renderWidth = 0;
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)("tooltip.relics." + BuiltInRegistries.ITEM.getKey((Object)this.screen.stack.getItem()).getPath() + ".ability." + this.ability)).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE)});
        int level = relic.getRelicLevel(this.screen.stack);
        if (level < (requiredLevel = data.getRequiredLevel())) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.card.low_level", (Object[])new Object[]{Component.literal((String)String.valueOf(requiredLevel)).withStyle(ChatFormatting.BOLD)})));
        } else if (data.getMaxLevel() == 0) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.card.no_stats")));
        } else if (relic.mayPlayerUpgrade((Player)this.MC.player, this.screen.stack, this.ability)) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"").append((Component)Component.translatable((String)"tooltip.relics.researching.relic.card.ready_to_upgrade")));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = this.MC.font.width((FormattedText)entry) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth + 2, maxWidth);
            }
            tooltip.addAll(this.MC.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = tooltip.size() * 5;
        int y = this.getHeight() / 2;
        float partialTicks = this.MC.getTimer().getGameTimeDeltaPartialTick(false);
        float lerpedScale = Mth.lerp((float)partialTicks, (float)this.scaleOld, (float)this.scale);
        poseStack.scale(lerpedScale, lerpedScale, lerpedScale);
        poseStack.translate(((float)this.getX() + (float)this.getWidth() / 2.0f) / lerpedScale, ((float)this.getY() + (float)this.getHeight() / 2.0f) / lerpedScale, 0.0f);
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, -((renderWidth + 19) / 2), y);
        int yOff = 0;
        for (FormattedCharSequence entry : tooltip) {
            poseStack.pushPose();
            poseStack.scale(0.5f, 0.5f, 0.5f);
            guiGraphics.drawString(this.MC.font, entry, -(this.MC.font.width(entry) / 2), (y + yOff + 9) * 2, 6696723, false);
            yOff += 5;
            poseStack.popPose();
        }
    }

    @Override
    public void playDownSound(SoundManager handler) {
        IRelicItem relic;
        Item item = this.screen.getStack().getItem();
        if (item instanceof IRelicItem && (relic = (IRelicItem)item).canUseAbility(this.screen.stack, this.ability)) {
            super.playDownSound(handler);
        }
    }
}

