/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.widgets.ability;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.description.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.widgets.ability.base.AbstractActionWidget;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketRelicTweak;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class ResetActionWidget
extends AbstractActionWidget {
    public ResetActionWidget(int x, int y, AbilityDescriptionScreen screen, String ability) {
        super(x, y, PacketRelicTweak.Operation.RESET, screen, ability);
    }

    @Override
    public boolean isLocked() {
        IRelicItem relic;
        Item item = this.getProvider().getStack().getItem();
        return !(item instanceof IRelicItem) || !(relic = (IRelicItem)item).mayPlayerReset((Player)this.MC.player, this.getProvider().getStack(), this.getAbility());
    }

    @Override
    public void playDownSound(SoundManager handler) {
        if (!this.isLocked()) {
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.TABLE_RESET.get()), (float)1.0f));
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IRelicItem relic;
        Item item = this.getProvider().getStack().getItem();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).canUseAbility(this.getProvider().getStack(), this.getAbility())) {
            return;
        }
        AbilityData data = relic.getAbilityData(this.getAbility());
        if (data.getStats().isEmpty()) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 100;
        int renderWidth = 0;
        int requiredLevel = relic.getResetRequiredLevel(this.getProvider().getStack(), this.getAbility());
        int level = this.MC.player.experienceLevel;
        MutableComponent negativeStatus = Component.translatable((String)"tooltip.relics.relic.status.negative");
        MutableComponent positiveStatus = Component.translatable((String)"tooltip.relics.relic.status.positive");
        ArrayList entries = Lists.newArrayList((Object[])new MutableComponent[]{Component.translatable((String)"tooltip.relics.relic.reset.description").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE), Component.literal((String)" ")});
        if (relic.getAbilityLevel(this.getProvider().getStack(), this.getAbility()) > 0) {
            entries.add(Component.translatable((String)"tooltip.relics.relic.reset.cost", (Object[])new Object[]{requiredLevel, requiredLevel > level ? negativeStatus : positiveStatus}));
        } else {
            entries.add(Component.translatable((String)"tooltip.relics.relic.reset.locked"));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = (this.MC.font.width((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.MC.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round((float)tooltip.size() * 5.0f);
        int renderX = this.getX() + this.width + 1;
        int renderY = mouseY - height / 2 - 9;
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.MC.font, entry, (renderX + 10) * 2, (renderY + 9 + yOff) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.scale(1.0f, 1.0f, 1.0f);
    }
}

