/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.description.RelicDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.data.BurnPoint;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.widgets.general.LogoWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.general.LuckPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.general.PlayerExperiencePlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.general.PointsPlateWidget;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector2f;

@OnlyIn(value=Dist.CLIENT)
public class AbilityResearchScreen
extends Screen
implements IAutoScaledScreen,
IRelicScreenProvider {
    public final Screen screen;
    public final int container;
    public final int slot;
    public ItemStack stack;
    public final String ability;
    public int backgroundHeight = 256;
    public int backgroundWidth = 418;
    public int ticksExisted = 0;
    private List<BurnPoint> points = new ArrayList<BurnPoint>();

    public AbilityResearchScreen(Player player, int container, int slot, Screen screen, String ability) {
        super((Component)Component.empty());
        this.container = container;
        this.slot = slot;
        this.screen = screen;
        this.ability = ability;
        this.stack = DescriptionUtils.gatherRelicStack(player, slot);
    }

    protected void init() {
        Item item;
        if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        int x = (this.width - this.backgroundWidth) / 2;
        int y = (this.height - this.backgroundHeight) / 2;
        this.addRenderableWidget((GuiEventListener)new LogoWidget(x + 313, y + 57, this));
        this.addRenderableWidget((GuiEventListener)new PointsPlateWidget(x + 313, y + 77, this));
        this.addRenderableWidget((GuiEventListener)new PlayerExperiencePlateWidget(x + 313, y + 102, this));
        this.addRenderableWidget((GuiEventListener)new LuckPlateWidget(x + 313, y + 127, this));
    }

    public void tick() {
        super.tick();
        ++this.ticksExisted;
        this.stack = DescriptionUtils.gatherRelicStack((Player)this.minecraft.player, this.slot);
        Window window = this.minecraft.getWindow();
        float mouseX = (float)(this.minecraft.mouseHandler.xpos() * (double)window.getGuiScaledWidth() / (double)window.getScreenWidth());
        float mouseY = (float)(this.minecraft.mouseHandler.ypos() * (double)window.getGuiScaledHeight() / (double)window.getScreenHeight());
        float partialTick = this.minecraft.getTimer().getGameTimeDeltaPartialTick(false);
        ArrayList<BurnPoint> toRemove = new ArrayList<BurnPoint>();
        for (BurnPoint point : this.points) {
            if (point.getLifeTime() > 0) {
                point.setLifeTime(point.getLifeTime() - 1);
                float scale = point.getScale();
                point.setScale(scale * point.getScaleMultiplier());
                point.setX(point.getX() + point.getDeltaX() + partialTick);
                point.setY(point.getY() + point.getDeltaY());
                continue;
            }
            toRemove.add(point);
        }
        if (!toRemove.isEmpty()) {
            this.points.removeAll(toRemove);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        IRelicItem relic;
        block8: {
            block7: {
                Item item;
                super.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTick);
                LocalPlayer player = this.minecraft.player;
                if (this.stack == null || !((item = this.stack.getItem()) instanceof IRelicItem)) break block7;
                relic = (IRelicItem)item;
                if (player != null) break block8;
            }
            return;
        }
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.SPACE_BACKGROUND);
        int x = (this.width - this.backgroundWidth) / 2;
        int y = (this.height - this.backgroundHeight) / 2;
        boolean yOff = false;
        boolean xOff = false;
        RenderUtils.renderAnimatedTextureFromCenter(poseStack, (float)x + (float)this.backgroundWidth / 2.0f, (float)y + (float)this.backgroundHeight / 2.0f, 418.0f, 4096.0f, this.backgroundWidth, this.backgroundHeight, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2).frame(14, 2).frame(15, 2));
        ResourceLocation card = ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/abilities/" + BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem()).getPath() + "/" + (String)relic.getAbilityData(this.ability).getIcon().apply((Object)this.minecraft.player, (Object)this.stack, (Object)this.ability) + ".png"));
        guiGraphics.blit(card, x + 67, y + 54, 0.0f, 0.0f, 110, 155, 110, 155);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/test_fog.png"));
        this.points.add(new BurnPoint(pMouseX, pMouseY, 0.0f, 0.0f, 20, 0.2f, 0.95f));
        try {
            ArrayList positions = Lists.newArrayList((Object[])new Vector2f[]{new Vector2f((float)pMouseX, (float)pMouseY)});
            ArrayList scales = Lists.newArrayList((Object[])new Float[]{Float.valueOf(0.15f)});
            ArrayList noises = Lists.newArrayList((Object[])new Float[]{Float.valueOf(10.0f)});
            for (BurnPoint point : this.points) {
                positions.add(new Vector2f(point.getX(), point.getY()));
                scales.add(Float.valueOf(point.getScale()));
                noises.add(Float.valueOf(10.0f));
            }
            RenderUtils.renderRevealingPanel(poseStack, x + 67, y + 54, 110.0f, 155.0f, positions, scales, noises, ((float)this.ticksExisted + pPartialTick) / 50.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)"textures/gui/description/test_background.png"), x + 60, y + 45, 0.0f, 0.0f, 242, 176, 242, 176);
    }

    public void render(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.children()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).isHovered() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)pKeyCode, (int)pScanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)new RelicDescriptionScreen((Player)this.minecraft.player, this.container, this.slot, this.screen));
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }

    @Override
    public int getContainer() {
        return this.container;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }
}

