/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundSpecialActionPacket(byte screenID, byte typeOfAction, double scrollDelta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundSpecialActionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"special_action"));
    public static final StreamCodec<FriendlyByteBuf, ServerboundSpecialActionPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, ServerboundSpecialActionPacket::screenID, (StreamCodec)ByteBufCodecs.BYTE, ServerboundSpecialActionPacket::typeOfAction, (StreamCodec)ByteBufCodecs.DOUBLE, ServerboundSpecialActionPacket::scrollDelta, ServerboundSpecialActionPacket::new);

    public static void handle(ServerboundSpecialActionPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (message.typeOfAction == 0) {
                    ServerActions.swapTool((Player)serverPlayer, message.scrollDelta);
                } else if (message.typeOfAction == 1) {
                    ServerActions.switchHoseMode((Player)serverPlayer, message.scrollDelta);
                } else if (message.typeOfAction == 2) {
                    ServerActions.toggleHoseTank((Player)serverPlayer);
                } else if (message.typeOfAction == 3) {
                    ServerActions.emptyTank(message.scrollDelta, (Player)serverPlayer, (Level)serverPlayer.serverLevel(), message.screenID);
                } else if (message.typeOfAction == 4 && AttachmentUtils.isWearingBackpack((Player)serverPlayer)) {
                    TravelersBackpackContainer.openGUI(serverPlayer, AttachmentUtils.getWearingBackpack((Player)serverPlayer), (byte)2);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

