/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundSorterPacket(byte screenID, byte button, boolean shiftPressed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundSorterPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"sorter"));
    public static final StreamCodec<FriendlyByteBuf, ServerboundSorterPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, ServerboundSorterPacket::screenID, (StreamCodec)ByteBufCodecs.BYTE, ServerboundSorterPacket::button, (StreamCodec)ByteBufCodecs.BOOL, ServerboundSorterPacket::shiftPressed, ServerboundSorterPacket::new);

    public static void handle(ServerboundSorterPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerActions.sortBackpack((Player)serverPlayer, message.screenID, message.button, message.shiftPressed);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

