/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundSettingsPacket(byte screenID, byte dataArray, int place, byte value) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundSettingsPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"settings"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundSettingsPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, ServerboundSettingsPacket::screenID, (StreamCodec)ByteBufCodecs.BYTE, ServerboundSettingsPacket::dataArray, (StreamCodec)ByteBufCodecs.INT, ServerboundSettingsPacket::place, (StreamCodec)ByteBufCodecs.BYTE, ServerboundSettingsPacket::value, ServerboundSettingsPacket::new);

    public static void handle(ServerboundSettingsPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                SettingsManager manager;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (message.screenID == 2) {
                    manager = AttachmentUtils.getBackpackInv((Player)serverPlayer).getSettingsManager();
                    manager.set(message.dataArray, message.place, message.value);
                }
                if (message.screenID == 1) {
                    manager = ((TravelersBackpackItemMenu)serverPlayer.containerMenu).container.getSettingsManager();
                    manager.set(message.dataArray, message.place, message.value);
                }
                if (message.screenID == 3) {
                    manager = ((TravelersBackpackBlockEntityMenu)serverPlayer.containerMenu).container.getSettingsManager();
                    manager.set(message.dataArray, message.place, message.value);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

