/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundOpenBackpackPacket(int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundOpenBackpackPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"open_backpack"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundOpenBackpackPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ServerboundOpenBackpackPacket::index, ServerboundOpenBackpackPacket::new);

    public static void handle(ServerboundOpenBackpackPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Slot slot = serverPlayer.containerMenu.getSlot(message.index);
                if (slot != null && slot.hasItem() && slot.getItem().getItem() instanceof TravelersBackpackItem) {
                    serverPlayer.closeContainer();
                    TravelersBackpackContainer.openGUI(serverPlayer, slot.getItem(), (byte)1);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

