/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundMemoryPacket(byte screenID, boolean isActive, List<Integer> selectedSlots, List<ItemStack> stacks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundMemoryPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"memory"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundMemoryPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, ServerboundMemoryPacket::screenID, (StreamCodec)ByteBufCodecs.BOOL, ServerboundMemoryPacket::isActive, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), ServerboundMemoryPacket::selectedSlots, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), ServerboundMemoryPacket::stacks, ServerboundMemoryPacket::new);

    public static void handle(ServerboundMemoryPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                SlotManager manager;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (message.screenID == 2) {
                    manager = AttachmentUtils.getBackpackInv((Player)serverPlayer).getSlotManager();
                    manager.setSelectorActive((byte)1, message.isActive);
                    manager.setMemorySlots(message.selectedSlots(), message.stacks, true);
                    manager.setSelectorActive((byte)1, !message.isActive);
                }
                if (message.screenID == 1) {
                    manager = ((TravelersBackpackItemMenu)serverPlayer.containerMenu).container.getSlotManager();
                    manager.setSelectorActive((byte)1, message.isActive);
                    manager.setMemorySlots(message.selectedSlots(), message.stacks, true);
                    manager.setSelectorActive((byte)1, !message.isActive);
                }
                if (message.screenID == 3) {
                    manager = ((TravelersBackpackBlockEntityMenu)serverPlayer.containerMenu).container.getSlotManager();
                    manager.setSelectorActive((byte)1, message.isActive);
                    manager.setMemorySlots(message.selectedSlots, message.stacks, true);
                    manager.setSelectorActive((byte)1, !message.isActive);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

