/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundEquipBackpackPacket(boolean equip) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundEquipBackpackPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"equip_backpack"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundEquipBackpackPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ServerboundEquipBackpackPacket::equip, ServerboundEquipBackpackPacket::new);

    public static void handle(ServerboundEquipBackpackPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (message.equip) {
                    if (!TravelersBackpack.enableIntegration()) {
                        if (!AttachmentUtils.isWearingBackpack((Player)serverPlayer)) {
                            ServerActions.equipBackpack((Player)serverPlayer);
                        } else {
                            serverPlayer.closeContainer();
                            serverPlayer.sendSystemMessage((Component)Component.translatable((String)"action.travelersbackpack.equip_otherbackpack"));
                        }
                    }
                } else if (!TravelersBackpack.enableIntegration()) {
                    if (AttachmentUtils.isWearingBackpack((Player)serverPlayer)) {
                        ServerActions.unequipBackpack((Player)serverPlayer);
                    } else {
                        serverPlayer.closeContainer();
                        serverPlayer.sendSystemMessage((Component)Component.translatable((String)"action.travelersbackpack.unequip_nobackpack"));
                    }
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

