/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundAbilitySliderPacket(byte screenID, boolean sliderValue) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundAbilitySliderPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"ability_slider"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundAbilitySliderPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, ServerboundAbilitySliderPacket::screenID, (StreamCodec)ByteBufCodecs.BOOL, ServerboundAbilitySliderPacket::sliderValue, ServerboundAbilitySliderPacket::new);

    public static void handle(ServerboundAbilitySliderPacket message, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                AbstractContainerMenu patt0$temp;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (message.screenID == 2 && AttachmentUtils.isWearingBackpack((Player)serverPlayer)) {
                    ServerActions.switchAbilitySlider((Player)serverPlayer, message.sliderValue);
                } else if (message.screenID == 3 && (patt0$temp = serverPlayer.containerMenu) instanceof TravelersBackpackBlockEntityMenu) {
                    TravelersBackpackBlockEntityMenu menu = (TravelersBackpackBlockEntityMenu)patt0$temp;
                    ServerActions.switchAbilitySliderBlockEntity((Player)serverPlayer, menu.container.getPosition(), message.sliderValue);
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

