/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.entity.IEntityTravelersBackpack;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientboundSyncAttachmentPacket(int entityID, boolean isPlayer, ItemStack stack) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"sync_attachment");
    public static final CustomPacketPayload.Type<ClientboundSyncAttachmentPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundSyncAttachmentPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClientboundSyncAttachmentPacket::entityID, (StreamCodec)ByteBufCodecs.BOOL, ClientboundSyncAttachmentPacket::isPlayer, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ClientboundSyncAttachmentPacket::stack, ClientboundSyncAttachmentPacket::new);

    public static void handle(ClientboundSyncAttachmentPacket message, IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(() -> {
                if (message.isPlayer) {
                    Player playerEntity = (Player)Minecraft.getInstance().player.level().getEntity(message.entityID);
                    ITravelersBackpack data = AttachmentUtils.getAttachment(playerEntity).orElseThrow(() -> new RuntimeException("No player attachment data found!"));
                    if (data != null) {
                        data.setWearable(message.stack());
                        data.setContents(message.stack());
                    }
                } else {
                    LivingEntity livingEntity = (LivingEntity)Minecraft.getInstance().player.level().getEntity(message.entityID);
                    IEntityTravelersBackpack data = AttachmentUtils.getEntityAttachment(livingEntity).orElseThrow(() -> new RuntimeException("No entity attachment data found!"));
                    if (data != null) {
                        data.setWearable(message.stack());
                    }
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

