/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class UpgradeItem
extends Item {
    private final Upgrade type;
    public static List<Supplier<Item>> upgrades = Arrays.asList(() -> (Item)ModItems.IRON_TIER_UPGRADE.get(), () -> (Item)ModItems.GOLD_TIER_UPGRADE.get(), () -> (Item)ModItems.DIAMOND_TIER_UPGRADE.get(), () -> (Item)ModItems.NETHERITE_TIER_UPGRADE.get());

    public UpgradeItem(Item.Properties pProperties, Upgrade type) {
        super(pProperties);
        this.type = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.enableTierUpgrades.get()).booleanValue()) {
            switch (this.type.ordinal()) {
                case 0: {
                    tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.blank_upgrade_tooltip").withStyle(ChatFormatting.BLUE));
                    break;
                }
                case 1: {
                    tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.LEATHER.getName()}).withStyle(ChatFormatting.BLUE));
                    break;
                }
                case 2: {
                    tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.IRON.getName()}).withStyle(ChatFormatting.BLUE));
                    break;
                }
                case 3: {
                    tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.GOLD.getName()}).withStyle(ChatFormatting.BLUE));
                    break;
                }
                case 4: {
                    tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.tier_upgrade_tooltip", (Object[])new Object[]{Tiers.DIAMOND.getName()}).withStyle(ChatFormatting.BLUE));
                }
            }
        } else if (this.type != Upgrade.CRAFTING_UPGRADE) {
            tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.upgrade_disabled"));
        }
        if (this.type == Upgrade.CRAFTING_UPGRADE) {
            if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.craftingUpgrade.enableUpgrade.get()).booleanValue()) {
                tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.crafting_upgrade_tooltip").withStyle(ChatFormatting.BLUE));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.upgrade_disabled").withStyle(ChatFormatting.RED));
            }
        }
    }

    public static NonNullList<ItemStack> getUpgrades(ITravelersBackpackContainer container) {
        NonNullList list = NonNullList.create();
        for (int i = 1; i <= container.getTier().getOrdinal(); ++i) {
            list.add((Object)upgrades.get(i - 1).get().getDefaultInstance());
        }
        if (container.getSettingsManager().hasCraftingGrid()) {
            list.add((Object)((UpgradeItem)((Object)ModItems.CRAFTING_UPGRADE.get())).getDefaultInstance());
        }
        return list;
    }

    public static enum Upgrade {
        BLANK_UPGRADE,
        IRON_TIER_UPGRADE,
        GOLD_TIER_UPGRADE,
        DIAMOND_TIER_UPGRADE,
        NETHERITE_TIER_UPGRADE,
        CRAFTING_UPGRADE;

    }
}

