/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.items;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackItemStackRenderer;
import com.tiviacz.travelersbackpack.client.screens.tooltip.BackpackTooltipComponent;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class TravelersBackpackItem
extends BlockItem {
    public final ResourceLocation texture;

    public TravelersBackpackItem(Block block, ResourceLocation texture) {
        super(block, new Item.Properties().stacksTo(1).component(ModDataComponents.TIER, (Object)0));
        this.texture = texture;
    }

    public TravelersBackpackItem(Block block, String name) {
        super(block, new Item.Properties().stacksTo(1).component(ModDataComponents.TIER, (Object)0));
        this.texture = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)("textures/model/" + name.toLowerCase(Locale.ENGLISH) + ".png"));
    }

    public ResourceLocation getBackpackTexture() {
        return this.texture;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (hand == InteractionHand.OFF_HAND || player.isCrouching()) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.allowOnlyEquippedBackpack.get()).booleanValue()) {
            if (!level.isClientSide) {
                TravelersBackpackContainer.openGUI((ServerPlayer)player, player.getInventory().getSelected(), (byte)1);
            }
        } else if (!AttachmentUtils.isWearingBackpack(player)) {
            ServerActions.equipBackpack(player);
            player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult interactionResult = this.place(new BlockPlaceContext(context));
        return !interactionResult.consumesAction() ? this.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult() : interactionResult;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.canPlace() || context.getHand() == InteractionHand.MAIN_HAND && context.getPlayer() != null && !context.getPlayer().isCrouching()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockitemusecontext = this.updatePlacementContext(context);
        if (blockitemusecontext == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(blockitemusecontext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockitemusecontext, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = blockitemusecontext.getClickedPos();
        Level level = blockitemusecontext.getLevel();
        Player player = blockitemusecontext.getPlayer();
        ItemStack itemstack = blockitemusecontext.getItemInHand();
        BlockState blockstate1 = level.getBlockState(blockpos);
        if (blockstate1.is(blockstate.getBlock())) {
            this.updateCustomBlockEntityTag(blockpos, level, player, itemstack, blockstate1);
            blockstate1.getBlock().setPlacedBy(level, blockpos, blockstate1, (LivingEntity)player, itemstack);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.PLACED_BLOCK.trigger(serverPlayer, blockpos, itemstack);
            }
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, blockpos);
        SoundType soundtype = blockstate1.getSoundType((LevelReader)level, blockpos, (Entity)context.getPlayer());
        level.playSound(player, blockpos, this.getPlaceSound(blockstate1, level, blockpos, player), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
        if (player == null || !player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pPos, Level pLevel, @Nullable Player pPlayer, ItemStack pStack, BlockState pState) {
        return TravelersBackpackItem.updateCustomBlockEntityTag(pLevel, pPlayer, pPos, pStack);
    }

    public static boolean updateCustomBlockEntityTag(Level pLevel, @Nullable Player pPlayer, BlockPos pPos, ItemStack pStack) {
        MinecraftServer minecraftserver = pLevel.getServer();
        if (minecraftserver == null) {
            return false;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity != null && (pLevel.isClientSide || !blockEntity.onlyOpCanSetNbt() || pPlayer != null && pPlayer.canUseGameMasterBlocks())) {
            blockEntity.applyComponentsFromItemStack(pStack);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.has(ModDataComponents.TIER)) {
            tooltipComponents.add((Component)Component.translatable((String)("tier.travelersbackpack." + Tiers.of((Integer)stack.get(ModDataComponents.TIER)).getName())));
        }
        if (stack.has(ModDataComponents.BACKPACK_CONTAINER) && !BackpackUtils.isCtrlPressed()) {
            tooltipComponents.add((Component)Component.translatable((String)"item.travelersbackpack.inventory_tooltip").withStyle(ChatFormatting.BLUE));
        }
        if (((Boolean)TravelersBackpackConfig.CLIENT.obtainTips.get()).booleanValue()) {
            if (stack.getItem() == ModItems.BAT_TRAVELERS_BACKPACK.get()) {
                tooltipComponents.add((Component)Component.translatable((String)"obtain.travelersbackpack.bat").withStyle(ChatFormatting.BLUE));
            }
            if (stack.getItem() == ModItems.VILLAGER_TRAVELERS_BACKPACK.get()) {
                tooltipComponents.add((Component)Component.translatable((String)"obtain.travelersbackpack.villager").withStyle(ChatFormatting.BLUE));
            }
            if (stack.getItem() == ModItems.IRON_GOLEM_TRAVELERS_BACKPACK.get()) {
                tooltipComponents.add((Component)Component.translatable((String)"obtain.travelersbackpack.iron_golem").withStyle(ChatFormatting.BLUE));
            }
        }
        if (BackpackAbilities.isOnList(BackpackAbilities.ALL_ABILITIES_LIST, stack)) {
            if (BackpackUtils.isShiftPressed()) {
                tooltipComponents.add((Component)Component.translatable((String)("ability.travelersbackpack." + this.getDescriptionId(stack).replaceAll("block.travelersbackpack.", ""))).withStyle(ChatFormatting.BLUE));
                if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((Component)Component.translatable((String)"ability.travelersbackpack.item_and_block"));
                } else if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((Component)Component.translatable((String)"ability.travelersbackpack.block"));
                } else if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, stack) && !BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, stack)) {
                    tooltipComponents.add((Component)Component.translatable((String)"ability.travelersbackpack.item"));
                }
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"ability.travelersbackpack.hold_shift").withStyle(ChatFormatting.BLUE));
            }
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        return Optional.of(new BackpackTooltipComponent(pStack));
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(this){
            private final Supplier<BlockEntityWithoutLevelRenderer> renderer = () -> new TravelersBackpackItemStackRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer.get();
            }
        });
    }

    public static void registerCauldronInteraction() {
        CauldronInteraction.WATER.map().put((Item)ModItems.STANDARD_TRAVELERS_BACKPACK.get(), CauldronInteraction.DYED_ITEM);
    }
}

