/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.components.Slots;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class SlotManager {
    protected final ITravelersBackpackContainer container;
    protected List<Integer> unsortableSlots = new ArrayList<Integer>();
    protected List<Pair<Integer, ItemStack>> memorySlots = new ArrayList<Pair<Integer, ItemStack>>();
    protected boolean isUnsortableActive = false;
    protected boolean isMemoryActive = false;
    public static final String UNSORTABLE_SLOTS = "UnsortableSlots";
    public static final String MEMORY_SLOTS = "MemorySlots";
    public static final byte UNSORTABLE = 0;
    public static final byte MEMORY = 1;

    public SlotManager(ITravelersBackpackContainer container) {
        this.container = container;
    }

    public List<Integer> getUnsortableSlots() {
        return this.unsortableSlots;
    }

    public List<Pair<Integer, ItemStack>> getMemorySlots() {
        return this.memorySlots;
    }

    public boolean isSlot(byte type, int slot) {
        if (type == 0) {
            return this.unsortableSlots.contains(slot);
        }
        if (type == 1) {
            for (Pair<Integer, ItemStack> pair : this.memorySlots) {
                if ((Integer)pair.getFirst() != slot) continue;
                return true;
            }
        }
        return false;
    }

    public void setUnsortableSlots(List<Integer> slots, boolean isFinal) {
        if (this.isSelectorActive((byte)0)) {
            this.unsortableSlots = slots;
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setMemorySlots(List<Integer> slots, List<ItemStack> stacks, boolean isFinal) {
        if (this.isSelectorActive((byte)1)) {
            ArrayList<Pair<Integer, ItemStack>> pairs = new ArrayList<Pair<Integer, ItemStack>>();
            for (int i = 0; i < stacks.size(); ++i) {
                pairs.add((Pair<Integer, ItemStack>)Pair.of((Object)slots.get(i), (Object)stacks.get(i)));
            }
            pairs.sort(Comparator.comparing(Pair::getFirst));
            this.memorySlots = pairs;
            if (isFinal) {
                this.setChanged();
            }
        }
    }

    public void setMemorySlot(int slot, ItemStack stack) {
        if (this.isSelectorActive((byte)1) && slot <= this.container.getHandler().getSlots() - 1) {
            if (this.isSlot((byte)1, slot)) {
                this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot);
            } else {
                this.memorySlots.add((Pair<Integer, ItemStack>)Pair.of((Object)slot, (Object)stack));
            }
        }
    }

    public void setUnsortableSlot(int slot) {
        if (this.isSelectorActive((byte)0) && slot <= this.container.getHandler().getSlots() - 1) {
            if (this.isSlot((byte)0, slot)) {
                this.unsortableSlots.remove((Object)slot);
            } else {
                this.unsortableSlots.add(slot);
            }
        }
    }

    public void clearUnsortables() {
        if (this.isSelectorActive((byte)0)) {
            this.unsortableSlots = new ArrayList<Integer>();
        }
    }

    public void setChanged() {
        if (this.container.getScreenID() != 3) {
            this.container.setDataChanged(9);
        } else {
            this.container.setDataChanged();
        }
    }

    public boolean isSelectorActive(byte type) {
        return switch (type) {
            case 0 -> this.isUnsortableActive;
            case 1 -> this.isMemoryActive;
            default -> false;
        };
    }

    public void setSelectorActive(byte type, boolean bool) {
        switch (type) {
            case 0: {
                this.isUnsortableActive = bool;
                break;
            }
            case 1: {
                this.isMemoryActive = bool;
            }
        }
    }

    public void saveUnsortableSlots(CompoundTag compound) {
        compound.putIntArray(UNSORTABLE_SLOTS, this.getUnsortableSlots().stream().mapToInt(i -> i).toArray());
    }

    public void saveUnsortableSlots(ItemStack stack) {
        Slots newSlots = new Slots(this.getUnsortableSlots(), this.getMemorySlots());
        stack.set(ModDataComponents.SLOTS, (Object)newSlots);
    }

    public void loadUnsortableSlots(CompoundTag compound) {
        this.unsortableSlots = Arrays.stream(compound.getIntArray(UNSORTABLE_SLOTS)).boxed().collect(Collectors.toList());
    }

    public void loadUnsortableSlots(ItemStack stack) {
        this.unsortableSlots = new ArrayList<Integer>(((Slots)stack.getOrDefault(ModDataComponents.SLOTS, (Object)Slots.createDefault())).unsortables());
    }

    public void saveMemorySlots(HolderLookup.Provider provider, CompoundTag compound) {
        ListTag memorySlotsList = new ListTag();
        for (Pair<Integer, ItemStack> pair : this.memorySlots) {
            if (((ItemStack)pair.getSecond()).isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putInt("Slot", ((Integer)pair.getFirst()).intValue());
            memorySlotsList.add((Object)((ItemStack)pair.getSecond()).save(provider, (Tag)itemTag));
        }
        compound.put(MEMORY_SLOTS, (Tag)memorySlotsList);
    }

    public void saveMemorySlots(ItemStack stack) {
        Slots newSlots = new Slots(this.getUnsortableSlots(), this.getMemorySlots());
        stack.set(ModDataComponents.SLOTS, (Object)newSlots);
    }

    public void loadMemorySlots(HolderLookup.Provider provider, CompoundTag compound) {
        ListTag tagList = compound.getList(MEMORY_SLOTS, 10);
        ArrayList<Pair<Integer, ItemStack>> pairs = new ArrayList<Pair<Integer, ItemStack>>();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot > this.container.getHandler().getSlots() - 1) continue;
            Pair pair = Pair.of((Object)slot, (Object)ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTags));
            pairs.add((Pair<Integer, ItemStack>)pair);
        }
        this.memorySlots = pairs;
    }

    public void loadMemorySlots(ItemStack stack) {
        this.memorySlots = new ArrayList<Pair<Integer, ItemStack>>(((Slots)stack.getOrDefault(ModDataComponents.SLOTS, (Object)Slots.createDefault())).memory());
    }

    public Slots getSlots() {
        return new Slots(this.getUnsortableSlots(), this.getMemorySlots());
    }

    public SlotManager getManager(Slots slots) {
        this.unsortableSlots = new ArrayList<Integer>(slots.unsortables());
        this.memorySlots = new ArrayList<Pair<Integer, ItemStack>>(slots.memory());
        return this;
    }
}

