/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.sorter;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.sorter.SortType;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class ContainerSorter {
    public static final byte SORT_BACKPACK = 0;
    public static final byte QUICK_STACK = 1;
    public static final byte TRANSFER_TO_BACKPACK = 2;
    public static final byte TRANSFER_TO_PLAYER = 3;
    public static final byte SORT = 4;
    public static final byte MEMORY = 5;

    public static void selectSort(ITravelersBackpackContainer container, Player player, byte button, boolean shiftPressed) {
        if (button == 0) {
            ContainerSorter.sortBackpack(container, player, SortType.Type.CATEGORY, shiftPressed);
        } else if (button == 1) {
            ContainerSorter.quickStackToBackpackNoSort(container, player, shiftPressed);
        } else if (button == 2) {
            ContainerSorter.transferToBackpackNoSort(container, player, shiftPressed);
        } else if (button == 3) {
            ContainerSorter.transferToPlayer(container, player);
        } else if (button == 4) {
            ContainerSorter.setUnsortable(container, player, shiftPressed);
        } else if (button == 5) {
            ContainerSorter.setMemory(container, player, shiftPressed);
        }
    }

    public static void sortBackpack(ITravelersBackpackContainer container, Player player, SortType.Type type, boolean shiftPressed) {
        if (!container.getSlotManager().isSelectorActive((byte)0)) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            CustomWrapper wrapper = new CustomWrapper(container, container.getHandler());
            for (int i = 0; i < wrapper.getSlots(); ++i) {
                ContainerSorter.addStackWithMerge(stacks, container.getSlotManager().isSlot((byte)0, i) ? ItemStack.EMPTY : wrapper.getStackInSlot(i));
            }
            if (!stacks.isEmpty()) {
                stacks.sort(Comparator.comparing(stack -> SortType.getStringForSort(stack, type)));
            }
            if (stacks.isEmpty()) {
                return;
            }
            int j = 0;
            for (int i = 0; i < wrapper.getSlots(); ++i) {
                if (container.getSlotManager().isSlot((byte)0, i)) continue;
                wrapper.setStackInSlot(i, j < stacks.size() ? (ItemStack)stacks.get(j) : ItemStack.EMPTY);
                ++j;
            }
        }
    }

    public static void quickStackToBackpackNoSort(ITravelersBackpackContainer container, Player player, boolean shiftPressed) {
        int i;
        InvWrapper playerStacks = new InvWrapper((Container)player.getInventory());
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            ItemStack playerStack = playerStacks.getStackInSlot(i);
            if (!(playerStack.isEmpty() || container.getScreenID() == 1 && i == player.getInventory().selected)) {
                CustomWrapper wrapper = new CustomWrapper(container, container.getHandler());
                boolean hasExistingStack = IntStream.range(0, wrapper.getSlots()).mapToObj(wrapper::getStackInSlot).filter(existing -> !existing.isEmpty()).anyMatch(existing -> existing.getItem() == playerStack.getItem());
                if (hasExistingStack) {
                    ItemStack ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                    for (int j = 0; j < wrapper.getSlots() && !(ext = wrapper.insertItem(j, ext, false)).isEmpty(); ++j) {
                    }
                    if (!ext.isEmpty()) {
                        playerStacks.insertItem(i, ext, false);
                    }
                }
            }
            ++i;
        }
    }

    public static void transferToBackpackNoSort(ITravelersBackpackContainer container, Player player, boolean shiftPressed) {
        int i;
        InvWrapper playerStacks;
        block10: {
            playerStacks = new InvWrapper((Container)player.getInventory());
            if (container.getSlotManager().getMemorySlots().isEmpty()) break block10;
            for (Pair<Integer, ItemStack> pair : container.getSlotManager().getMemorySlots()) {
                int i2;
                int n = i2 = shiftPressed ? 0 : 9;
                while (i2 < 36) {
                    block11: {
                        ItemStack ext;
                        block12: {
                            ItemStack playerStack = playerStacks.getStackInSlot(i2);
                            if (playerStack.isEmpty() || container.getScreenID() == 1 && i2 == player.getInventory().selected) break block11;
                            CustomWrapper wrapper = new CustomWrapper(container, container.getHandler());
                            ItemStack extSimulate = playerStacks.extractItem(i2, Integer.MAX_VALUE, true);
                            ext = ItemStack.EMPTY;
                            if (!ItemStackUtils.isSameItemSameTags((ItemStack)pair.getSecond(), extSimulate)) break block12;
                            ext = playerStacks.extractItem(i2, Integer.MAX_VALUE, false);
                            ext = wrapper.insertItem((Integer)pair.getFirst(), ext, false);
                            if (ext.isEmpty()) break block11;
                        }
                        if (!ext.isEmpty()) {
                            playerStacks.insertItem(i2, ext, false);
                        }
                    }
                    ++i2;
                }
            }
        }
        int n = i = shiftPressed ? 0 : 9;
        while (i < 36) {
            ItemStack playerStack = playerStacks.getStackInSlot(i);
            if (!(playerStack.isEmpty() || container.getScreenID() == 1 && i == player.getInventory().selected)) {
                CustomWrapper wrapper = new CustomWrapper(container, container.getHandler());
                ItemStack ext = playerStacks.extractItem(i, Integer.MAX_VALUE, false);
                for (int j = 0; j < wrapper.getSlots() && !(ext = wrapper.insertItem(j, ext, false)).isEmpty(); ++j) {
                }
                if (!ext.isEmpty()) {
                    playerStacks.insertItem(i, ext, false);
                }
            }
            ++i;
        }
    }

    public static void transferToPlayer(ITravelersBackpackContainer container, Player player) {
        InvWrapper playerStacks = new InvWrapper((Container)player.getInventory());
        CustomWrapper wrapper = new CustomWrapper(container, container.getHandler());
        for (int i = 0; i < wrapper.getSlots(); ++i) {
            ItemStack stack = wrapper.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ItemStack ext = wrapper.extractItem(i, Integer.MAX_VALUE, false);
            for (int j = 9; j < 36 && !(ext = playerStacks.insertItem(j, ext, false)).isEmpty(); ++j) {
            }
            if (ext.isEmpty()) continue;
            wrapper.isTransferToPlayer = true;
            wrapper.insertItem(i, ext, false);
            wrapper.isTransferToPlayer = false;
        }
    }

    public static void setUnsortable(ITravelersBackpackContainer container, Player player, boolean shiftPressed) {
        container.getSlotManager().setSelectorActive((byte)0, !container.getSlotManager().isSelectorActive((byte)0));
    }

    public static void setMemory(ITravelersBackpackContainer container, Player player, boolean shiftPressed) {
        container.getSlotManager().setSelectorActive((byte)1, !container.getSlotManager().isSelectorActive((byte)1));
    }

    private static void addStackWithMerge(List<ItemStack> stacks, ItemStack newStack) {
        if (newStack.isEmpty()) {
            return;
        }
        if (newStack.isStackable() && newStack.getCount() != newStack.getMaxStackSize()) {
            for (int j = stacks.size() - 1; j >= 0; --j) {
                ItemStack oldStack = stacks.get(j);
                if (!ContainerSorter.canMergeItems(newStack, oldStack)) continue;
                ContainerSorter.combineStacks(newStack, oldStack);
                if (!oldStack.isEmpty() && oldStack.getCount() != 0) continue;
                stacks.remove(j);
            }
        }
        stacks.add(newStack);
    }

    private static void combineStacks(ItemStack stack, ItemStack stack2) {
        if (stack.getMaxStackSize() >= stack.getCount() + stack2.getCount()) {
            stack.grow(stack2.getCount());
            stack2.setCount(0);
        }
        int maxInsertAmount = Math.min(stack.getMaxStackSize() - stack.getCount(), stack2.getCount());
        stack.grow(maxInsertAmount);
        stack2.shrink(maxInsertAmount);
    }

    private static boolean canMergeItems(ItemStack stack1, ItemStack stack2) {
        if (!stack1.isStackable() || !stack2.isStackable()) {
            return false;
        }
        if (stack1.getCount() == stack2.getMaxStackSize() || stack2.getCount() == stack2.getMaxStackSize()) {
            return false;
        }
        if (stack1.getItem() != stack2.getItem()) {
            return false;
        }
        if (stack1.getDamageValue() != stack2.getDamageValue()) {
            return false;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack2);
    }

    public static class CustomWrapper
    implements IItemHandlerModifiable {
        public ITravelersBackpackContainer container;
        public ItemStackHandler parent;
        public boolean isTransferToPlayer;

        public CustomWrapper(ITravelersBackpackContainer container, ItemStackHandler parent) {
            this(container, parent, false);
        }

        public CustomWrapper(ITravelersBackpackContainer container, ItemStackHandler parent, boolean isTransferToPlayer) {
            this.container = container;
            this.parent = parent;
            this.isTransferToPlayer = isTransferToPlayer;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            this.parent.setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.parent.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.parent.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (this.container.getSlotManager().isSlot((byte)1, slot)) {
                return this.container.getSlotManager().getMemorySlots().stream().noneMatch(pair -> (Integer)pair.getFirst() == slot && ItemStackUtils.isSameItemSameTags((ItemStack)pair.getSecond(), stack)) && !this.isTransferToPlayer ? stack : this.parent.insertItem(slot, stack, simulate);
            }
            return this.container.getSlotManager().isSlot((byte)0, slot) ? stack : this.parent.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.container.getSlotManager().isSlot((byte)0, slot) ? ItemStack.EMPTY : this.parent.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.parent.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.parent.isItemValid(slot, stack);
        }
    }
}

