/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu.slot;

import com.tiviacz.travelersbackpack.inventory.CraftingContainerImproved;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import java.util.Collections;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class ResultSlotExt
extends ResultSlot {
    protected final ResultContainer inv;
    protected final ITravelersBackpackContainer container;

    public ResultSlotExt(ITravelersBackpackContainer container, Player player, CraftingContainerImproved matrix, ResultContainer inv, int slotIndex, int xPosition, int yPosition) {
        super(player, (CraftingContainer)matrix, (Container)inv, slotIndex, xPosition, yPosition);
        this.inv = inv;
        this.container = container;
    }

    public boolean mayPickup(Player player) {
        return this.container.getSettingsManager().hasCraftingGrid();
    }

    public boolean isActive() {
        return this.container.getSettingsManager().hasCraftingGrid() && this.container.getSettingsManager().showCraftingGrid();
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return this.getItem().copy();
    }

    protected void onSwapCraft(int numItemsCrafted) {
        super.onSwapCraft(numItemsCrafted);
        this.inv.setItem(0, this.getItem().copy());
    }

    public void set(ItemStack stack) {
    }

    protected void checkTakeAchievements(ItemStack stack) {
        if (this.removeCount > 0) {
            stack.onCraftedBy(this.player.level(), this.player, this.removeCount);
            EventHooks.firePlayerCraftingEvent((Player)this.player, (ItemStack)stack, (Container)this.craftSlots);
        }
        this.removeCount = 0;
        RecipeHolder recipe = this.inv.getRecipeUsed();
        if (recipe != null) {
            this.player.triggerRecipeCrafted(this.inv.getRecipeUsed(), this.craftSlots.getItems());
            if (!recipe.value().isSpecial()) {
                this.player.awardRecipes(Collections.singleton(recipe));
            }
        }
    }

    public void onTake(Player player, ItemStack stack) {
        this.checkTakeAchievements(stack);
        CraftingInput.Positioned pos = this.craftSlots.asPositionedCraftInput();
        CraftingInput input = pos.input();
        int left = pos.left();
        int top = pos.top();
        RecipeHolder recipe = this.inv.getRecipeUsed();
        CommonHooks.setCraftingPlayer((Player)player);
        if (recipe != null && ((CraftingRecipe)recipe.value()).matches((RecipeInput)input, player.level())) {
            NonNullList remaining = ((CraftingRecipe)recipe.value()).getRemainingItems((RecipeInput)input);
            for (int x = 0; x < input.width(); ++x) {
                for (int y = 0; y < input.height(); ++y) {
                    int realIdx = x + left + (y + top) * this.craftSlots.getWidth();
                    ItemStack current = this.craftSlots.getItem(realIdx);
                    ItemStack remainder = (ItemStack)remaining.get(x + y * input.width());
                    if (!current.isEmpty()) {
                        this.craftSlots.removeItem(realIdx, 1);
                        current = this.craftSlots.getItem(realIdx);
                    }
                    if (remainder.isEmpty()) continue;
                    if (current.isEmpty()) {
                        this.craftSlots.setItem(realIdx, remainder);
                        continue;
                    }
                    if (ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)remainder)) {
                        remainder.grow(current.getCount());
                        this.craftSlots.setItem(realIdx, remainder);
                        continue;
                    }
                    if (this.player.getInventory().add(remainder)) continue;
                    this.player.drop(remainder, false);
                }
            }
        }
        CommonHooks.setCraftingPlayer(null);
    }

    public ItemStack getItem() {
        if (this.player.level().isClientSide) {
            return super.getItem();
        }
        RecipeHolder recipe = this.inv.getRecipeUsed();
        if (recipe != null && ((CraftingRecipe)recipe.value()).matches((RecipeInput)this.craftSlots.asCraftInput(), this.player.level())) {
            return super.getItem();
        }
        return ItemStack.EMPTY;
    }
}

