/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TravelersBackpackItemMenu
extends TravelersBackpackBaseMenu {
    public TravelersBackpackItemMenu(int windowID, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowID, playerInventory, TravelersBackpackItemMenu.createInventory(playerInventory, data));
    }

    public TravelersBackpackItemMenu(int windowID, Inventory playerInventory, ITravelersBackpackContainer container) {
        super((MenuType)ModMenuTypes.TRAVELERS_BACKPACK_ITEM.get(), windowID, playerInventory, container);
    }

    private static TravelersBackpackContainer createInventory(Inventory inventory, FriendlyByteBuf data) {
        ItemStack stack;
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        byte screenID = data.readByte();
        if (screenID == 1) {
            stack = inventory.player.getItemBySlot(EquipmentSlot.MAINHAND);
        } else if (data.readBoolean()) {
            int entityId = data.readInt();
            stack = AttachmentUtils.getWearingBackpack((Player)inventory.player.level().getEntity(entityId));
            if (stack.getItem() instanceof TravelersBackpackItem) {
                return AttachmentUtils.getBackpackInv((Player)inventory.player.level().getEntity(entityId));
            }
        } else {
            stack = AttachmentUtils.getWearingBackpack(inventory.player);
        }
        if (stack.getItem() instanceof TravelersBackpackItem) {
            if (screenID == 2) {
                return AttachmentUtils.getBackpackInv(inventory.player);
            }
            if (screenID == 1) {
                return new TravelersBackpackContainer(stack, inventory.player, screenID);
            }
        }
        throw new IllegalStateException("ItemStack is not correct! " + String.valueOf(stack));
    }

    @Override
    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (this.container.getScreenID() == 1 && clickType == ClickType.SWAP) {
            ItemStack stack = player.getInventory().getItem(dragType);
            ItemStack currentItem = player.getInventory().getSelected();
            if (!currentItem.isEmpty() && stack == currentItem) {
                return;
            }
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    @Override
    public void addPlayerInventoryAndHotbar(Inventory inventory, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 44 + x * 18, 71 + this.container.getYOffset() + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            if (x == currentItemIndex && this.container.getScreenID() == 1) {
                this.addSlot(new DisabledSlot((Container)inventory, x, 44 + x * 18, 129 + this.container.getYOffset()));
                continue;
            }
            this.addSlot(new Slot((Container)inventory, x, 44 + x * 18, 129 + this.container.getYOffset()));
        }
    }
}

