/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TravelersBackpackBlockEntityMenu
extends TravelersBackpackBaseMenu {
    public TravelersBackpackBlockEntityMenu(int windowID, Inventory inventory, FriendlyByteBuf data) {
        this(windowID, inventory, TravelersBackpackBlockEntityMenu.getBlockEntity(inventory, data));
    }

    public TravelersBackpackBlockEntityMenu(int windowID, Inventory inventory, ITravelersBackpackContainer container) {
        super((MenuType)ModMenuTypes.TRAVELERS_BACKPACK_BLOCK_ENTITY.get(), windowID, inventory, container);
        container.setUsingPlayer(inventory.player);
    }

    private static TravelersBackpackBlockEntity getBlockEntity(Inventory inventory, FriendlyByteBuf data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity blockEntityAtPos = inventory.player.level().getBlockEntity(data.readBlockPos());
        if (blockEntityAtPos instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity = (TravelersBackpackBlockEntity)blockEntityAtPos;
            return blockEntity;
        }
        throw new IllegalStateException("Block Entity is not correct! " + String.valueOf(blockEntityAtPos));
    }

    @Override
    public boolean stillValid(Player player) {
        BlockEntity blockEntity = player.level().getBlockEntity(this.container.getPosition());
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
            return blockEntity2.isUsableByPlayer(player);
        }
        return false;
    }
}

