/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.CraftingContainerImproved;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FluidSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ResultSlotExt;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.network.ClientboundUpdateRecipePacket;
import com.tiviacz.travelersbackpack.util.ItemStackUtils;
import java.util.Iterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class TravelersBackpackBaseMenu
extends AbstractContainerMenu {
    public Inventory inventory;
    public ITravelersBackpackContainer container;
    public CraftingContainerImproved craftSlots;
    public ResultContainer resultSlots = new ResultContainer();
    private final int BACKPACK_INV_START = 1;
    private final int BACKPACK_INV_END;
    private final int TOOL_START;
    private final int TOOL_END;
    private final int BUCKET_LEFT_IN;
    private final int BUCKET_LEFT_OUT;
    private final int BUCKET_RIGHT_IN;
    private final int BUCKET_RIGHT_OUT;
    private final int PLAYER_INV_START;
    private final int PLAYER_HOT_END;
    private final int CRAFTING_GRID_START;
    private final int CRAFTING_GRID_END;

    public TravelersBackpackBaseMenu(MenuType<?> type, int windowID, Inventory inventory, ITravelersBackpackContainer container) {
        super(type, windowID);
        this.inventory = inventory;
        this.container = container;
        this.craftSlots = new CraftingContainerImproved(container, this);
        this.BACKPACK_INV_END = 1 + container.getHandler().getSlots() - 1;
        this.TOOL_START = this.BACKPACK_INV_END + 1;
        this.TOOL_END = this.TOOL_START + container.getToolSlotsHandler().getSlots() - 1;
        this.BUCKET_LEFT_IN = this.TOOL_END + 1;
        this.BUCKET_LEFT_OUT = this.BUCKET_LEFT_IN + 1;
        this.BUCKET_RIGHT_IN = this.BUCKET_LEFT_OUT + 1;
        this.BUCKET_RIGHT_OUT = this.BUCKET_RIGHT_IN + 1;
        this.CRAFTING_GRID_START = this.BUCKET_RIGHT_OUT + 1;
        this.CRAFTING_GRID_END = this.CRAFTING_GRID_START + 8;
        this.PLAYER_INV_START = this.CRAFTING_GRID_END + 1;
        this.PLAYER_HOT_END = this.PLAYER_INV_START + 35;
        this.addCraftResult();
        this.addBackpackInventory(container);
        this.addToolSlots(container);
        this.addFluidSlots(container);
        this.addCraftingSlots();
        this.addPlayerInventoryAndHotbar(inventory, inventory.selected);
    }

    public void addCraftResult() {
        this.addSlot((Slot)new ResultSlotExt(this.container, this.inventory.player, this.craftSlots, this.resultSlots, 0, 270, 113));
    }

    public void addBackpackInventory(ITravelersBackpackContainer container) {
        int slot = 0;
        for (int i = 0; i < container.getRows(); ++i) {
            int lastRowSlots = container.getHandler().getSlots() % 9;
            if (lastRowSlots == 0) {
                lastRowSlots = 9;
            }
            int slotsInRow = i == container.getRows() - 1 ? lastRowSlots : 9;
            for (int j = 0; j < slotsInRow; ++j) {
                this.addSlot((Slot)new BackpackSlotItemHandler((IItemHandler)container.getHandler(), slot++, 44 + j * 18, 7 + i * 18));
            }
        }
    }

    public void addFluidSlots(ITravelersBackpackContainer container) {
        this.addSlot((Slot)new FluidSlotItemHandler(container, 0, 6, 7){

            @Override
            public boolean isActive() {
                return !TravelersBackpackBaseMenu.this.container.getSettingsManager().showToolSlots() && super.isActive();
            }
        });
        this.addSlot((Slot)new FluidSlotItemHandler(container, 1, 6, 37){

            @Override
            public boolean isActive() {
                return !TravelersBackpackBaseMenu.this.container.getSettingsManager().showToolSlots() && super.isActive();
            }
        });
        this.addSlot((Slot)new FluidSlotItemHandler(container, 2, 226, 7));
        this.addSlot((Slot)new FluidSlotItemHandler(container, 3, 226, 37));
    }

    public void addToolSlots(ITravelersBackpackContainer container) {
        for (int i = 0; i < container.getToolSlotsHandler().getSlots(); ++i) {
            this.addSlot((Slot)new ToolSlotItemHandler(this.inventory.player, container, i, 6, 7 + 18 * i));
        }
    }

    public void addCraftingSlots() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.craftSlots, j + i * 3, 252 + j * 18, 47 + i * 18){

                    public boolean isActive() {
                        return TravelersBackpackBaseMenu.this.container.getSettingsManager().showCraftingGrid();
                    }

                    public boolean mayPlace(ItemStack pStack) {
                        return TravelersBackpackBaseMenu.this.container.getSettingsManager().hasCraftingGrid();
                    }
                });
            }
        }
    }

    public void addPlayerInventoryAndHotbar(Inventory inventory, int currentItemIndex) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 44 + x * 18, 71 + this.container.getYOffset() + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 44 + x * 18, 129 + this.container.getYOffset()));
        }
    }

    protected void canCraft(Level level, Player player) {
        if (this.container.getSettingsManager().hasCraftingGrid()) {
            this.slotChangedCraftingGrid(level, player);
        }
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
        this.canCraft(this.inventory.player.level(), this.inventory.player);
    }

    public void sendAllDataToRemote() {
        super.sendAllDataToRemote();
        this.canCraft(this.inventory.player.level(), this.inventory.player);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.resultSlots && super.canTakeItemForPickAll(stack, slot);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = this.getSlot(index);
        ItemStack result = ItemStack.EMPTY;
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            result = stack.copy();
            if (index >= 0 && index <= this.CRAFTING_GRID_END) {
                if (index == 0) {
                    return this.handleShiftCraft(player, slot);
                }
                if (!this.moveItemStackTo(stack, this.PLAYER_INV_START, this.PLAYER_HOT_END + 1, true)) {
                    return ItemStack.EMPTY;
                }
            }
            if (index >= this.PLAYER_INV_START) {
                if (!this.container.getSlotManager().getMemorySlots().isEmpty()) {
                    Pair<Integer, ItemStack> pair;
                    Iterator<Pair<Integer, ItemStack>> iterator = this.container.getSlotManager().getMemorySlots().iterator();
                    while (!(!iterator.hasNext() || ItemStackUtils.isSameItemSameTags((ItemStack)(pair = iterator.next()).getSecond(), stack) && this.getSlot((Integer)pair.getFirst() + 1).getItem().getCount() != this.getSlot((Integer)pair.getFirst() + 1).getItem().getMaxStackSize() && this.moveItemStackTo(stack, (Integer)pair.getFirst() + 1, (Integer)pair.getFirst() + 2, false))) {
                    }
                }
                if (ToolSlotItemHandler.isValid(stack) && !this.moveItemStackTo(stack, this.TOOL_START, this.TOOL_END + 1, false) && !this.moveItemStackTo(stack, 1, this.BACKPACK_INV_END + 1, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(stack, 1, this.BACKPACK_INV_END + 1, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == result.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return result;
    }

    public ItemStack handleShiftCraft(Player player, Slot resultSlot) {
        ItemStack outputCopy = ItemStack.EMPTY;
        CraftingInput input = this.craftSlots.asCraftInput();
        if (resultSlot != null && resultSlot.hasItem()) {
            this.craftSlots.checkChanges = false;
            RecipeHolder recipe = this.resultSlots.getRecipeUsed();
            while (recipe != null && ((CraftingRecipe)recipe.value()).matches((RecipeInput)input, player.level())) {
                ItemStack recipeOutput = ((CraftingRecipe)recipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)player.level().registryAccess());
                if (recipeOutput.isEmpty()) {
                    throw new RuntimeException("A recipe matched but produced an empty output - Offending Recipe : " + String.valueOf(recipe.id()) + " - This is NOT a bug in Traveler's Backpack!");
                }
                outputCopy = recipeOutput.copy();
                recipeOutput.onCraftedBy(player.level(), player, 1);
                EventHooks.firePlayerCraftingEvent((Player)player, (ItemStack)recipeOutput, (Container)this.craftSlots);
                if (!player.level().isClientSide) {
                    if (this.container.getSettingsManager().shiftClickToBackpack()) {
                        if (!this.moveItemStackTo(recipeOutput, 1, this.BACKPACK_INV_END + 1, false) && !this.moveItemStackTo(recipeOutput, this.PLAYER_INV_START, this.PLAYER_HOT_END + 1, true)) {
                            this.craftSlots.checkChanges = true;
                            return ItemStack.EMPTY;
                        }
                    } else if (!this.moveItemStackTo(recipeOutput, this.PLAYER_INV_START, this.PLAYER_HOT_END + 1, true) && !this.moveItemStackTo(recipeOutput, 1, this.BACKPACK_INV_END + 1, false)) {
                        this.craftSlots.checkChanges = true;
                        return ItemStack.EMPTY;
                    }
                }
                ((ResultSlot)resultSlot).removeCount += outputCopy.getCount();
                resultSlot.onTake(player, recipeOutput);
                this.resetStackedContents(input);
            }
            this.craftSlots.checkChanges = true;
            this.slotChangedCraftingGrid(player.level(), player);
        }
        return outputCopy;
    }

    public void resetStackedContents(CraftingInput input) {
        StackedContents contents = input.stackedContents();
        contents.clear();
        for (ItemStack i : input.items()) {
            if (i.isEmpty()) continue;
            contents.accountStack(i, 1);
        }
    }

    public void slotChangedCraftingGrid(Level world, Player player) {
        if (!world.isClientSide && this.craftSlots.checkChanges) {
            ItemStack itemstack = ItemStack.EMPTY;
            CraftingInput input = this.craftSlots.asCraftInput();
            RecipeHolder oldRecipe = this.resultSlots.getRecipeUsed();
            RecipeHolder recipe = oldRecipe;
            if (recipe == null || !((CraftingRecipe)recipe.value()).matches((RecipeInput)input, world)) {
                recipe = world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)input, world).orElse(null);
            }
            if (recipe != null) {
                itemstack = ((CraftingRecipe)recipe.value()).assemble((RecipeInput)input, (HolderLookup.Provider)world.registryAccess());
            }
            if (oldRecipe != recipe || this.resultSlots.getItem(0).isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientboundUpdateRecipePacket((RecipeHolder<CraftingRecipe>)recipe, itemstack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.resultSlots.setItem(0, itemstack);
                this.resultSlots.setRecipeUsed(recipe);
            } else if (recipe != null && (((CraftingRecipe)recipe.value()).isSpecial() || !recipe.getClass().getName().startsWith("net.minecraft") && !ItemStack.matches((ItemStack)itemstack, (ItemStack)this.resultSlots.getItem(0)))) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientboundUpdateRecipePacket((RecipeHolder<CraftingRecipe>)recipe, itemstack), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.resultSlots.setItem(0, itemstack);
                this.resultSlots.setRecipeUsed(recipe);
            }
        }
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (this.container.getSlotManager().isSelectorActive((byte)0) || this.container.getSlotManager().isSelectorActive((byte)1)) {
            return;
        }
        super.clicked(slotId, dragType, clickType, player);
    }

    public void removed(Player player) {
        if (this.container.getScreenID() == 3) {
            if (this.container.getSlotManager().isSelectorActive((byte)0) || this.container.getSlotManager().isSelectorActive((byte)1)) {
                this.container.getSlotManager().setChanged();
            }
            this.container.setUsingPlayer(null);
        }
        if (this.container.getSlotManager().isSelectorActive((byte)0)) {
            this.container.getSlotManager().setSelectorActive((byte)0, false);
        }
        if (this.container.getSlotManager().isSelectorActive((byte)1)) {
            this.container.getSlotManager().setSelectorActive((byte)1, false);
        }
        this.clearSlotsAndPlaySound(player, this.container.getFluidSlotsHandler(), 4);
        this.shiftTools(this.container);
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.craftingUpgrade.savesItems.get()).booleanValue()) {
            this.clearSlotsAndPlaySound(player, this.container.getCraftingGridHandler(), 9);
        } else {
            this.checkCraftingGridAndPlaySound(player);
        }
        super.removed(player);
    }

    public void clearSlotsAndPlaySound(Player player, ItemStackHandler handler, int size) {
        boolean playSound = false;
        for (int i = 0; i < size; ++i) {
            boolean flag = this.clearSlot(player, handler, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            this.playSound(player);
        }
    }

    public boolean clearSlot(Player player, ItemStackHandler handler, int index) {
        if (!handler.getStackInSlot(index).isEmpty()) {
            ServerPlayer serverPlayer;
            if (player == null) {
                return false;
            }
            if (!player.isAlive() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hasDisconnected()) {
                ItemStack stack = handler.getStackInSlot(index).copy();
                handler.setStackInSlot(index, ItemStack.EMPTY);
                player.drop(stack, false);
                return false;
            }
            ItemStack stack = handler.getStackInSlot(index);
            handler.setStackInSlot(index, ItemStack.EMPTY);
            player.getInventory().placeItemBackInInventory(stack);
            return true;
        }
        return false;
    }

    public void playSound(Player player) {
        player.level().playSound(player, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, (1.0f + (player.level().getRandom().nextFloat() - player.level().getRandom().nextFloat()) * 0.2f) * 0.7f);
    }

    public void shiftTools(ITravelersBackpackContainer container) {
        boolean foundEmptySlot = false;
        boolean needsShifting = false;
        for (int i = 0; i < container.getToolSlotsHandler().getSlots(); ++i) {
            if (foundEmptySlot && !container.getToolSlotsHandler().getStackInSlot(i).isEmpty()) {
                needsShifting = true;
            }
            if (!container.getToolSlotsHandler().getStackInSlot(i).isEmpty() || foundEmptySlot) continue;
            foundEmptySlot = true;
        }
        if (needsShifting) {
            int i;
            NonNullList tools = NonNullList.withSize((int)container.getToolSlotsHandler().getSlots(), (Object)ItemStack.EMPTY);
            int j = 0;
            for (i = 0; i < container.getToolSlotsHandler().getSlots(); ++i) {
                if (container.getToolSlotsHandler().getStackInSlot(i).isEmpty()) continue;
                tools.set(j, (Object)container.getToolSlotsHandler().getStackInSlot(i));
                ++j;
            }
            j = 0;
            for (i = 0; i < container.getToolSlotsHandler().getSlots(); ++i) {
                if (tools.isEmpty()) continue;
                container.getToolSlotsHandler().setStackInSlot(i, (ItemStack)tools.get(j));
                ++j;
            }
        }
    }

    public void checkCraftingGridAndPlaySound(Player player) {
        boolean playSound = false;
        for (int i = 0; i < this.container.getCraftingGridHandler().getSlots(); ++i) {
            boolean flag = this.clearCraftingGridSlot(player, i);
            if (!flag) continue;
            playSound = true;
        }
        if (playSound) {
            this.playSound(player);
        }
    }

    public boolean clearCraftingGridSlot(Player player, int index) {
        if (!BackpackSlotItemHandler.isItemValid(this.container.getCraftingGridHandler().getStackInSlot(index))) {
            ServerPlayer serverPlayer;
            if (player == null) {
                return false;
            }
            if (!player.isAlive() || player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).hasDisconnected()) {
                ItemStack stack = this.container.getCraftingGridHandler().getStackInSlot(index).copy();
                this.container.getCraftingGridHandler().setStackInSlot(index, ItemStack.EMPTY);
                player.drop(stack, false);
                return false;
            }
            ItemStack stack = this.container.getCraftingGridHandler().getStackInSlot(index);
            this.container.getCraftingGridHandler().setStackInSlot(index, ItemStack.EMPTY);
            player.getInventory().placeItemBackInInventory(stack);
            return true;
        }
        return false;
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

