/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.FluidTanks;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.SettingsManager;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.sorter.SlotManager;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.network.PacketDistributor;

public class TravelersBackpackContainer
implements ITravelersBackpackContainer,
MenuProvider,
Nameable {
    private ItemStackHandler inventory = this.createHandler((NonNullList<ItemStack>)NonNullList.withSize((int)Tiers.LEATHER.getStorageSlots(), (Object)ItemStack.EMPTY), true);
    private ItemStackHandler craftingInventory = this.createHandler((NonNullList<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY), false);
    private ItemStackHandler toolSlots = this.createToolsHandler((NonNullList<ItemStack>)NonNullList.withSize((int)Tiers.LEATHER.getToolSlots(), (Object)ItemStack.EMPTY));
    private final ItemStackHandler fluidSlots = this.createTemporaryHandler();
    private final FluidTank leftTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private final FluidTank rightTank = this.createFluidHandler(Tiers.LEATHER.getTankCapacity());
    private final SlotManager slotManager = new SlotManager(this);
    private final SettingsManager settingsManager = new SettingsManager(this);
    private Player player;
    private ItemStack stack;
    private Tiers.Tier tier;
    private boolean ability;
    private int lastTime;
    private final byte screenID;

    public TravelersBackpackContainer(ItemStack stack, Player player, byte screenID) {
        this.player = player;
        this.stack = stack;
        this.screenID = screenID;
        if (!this.stack.isEmpty()) {
            this.loadAllData();
        }
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public void loadTier() {
        this.tier = Tiers.of((Integer)this.stack.getOrDefault(ModDataComponents.TIER, (Object)0));
    }

    @Override
    public ItemStackHandler getHandler() {
        return this.inventory;
    }

    @Override
    public ItemStackHandler getToolSlotsHandler() {
        return this.toolSlots;
    }

    @Override
    public ItemStackHandler getCraftingGridHandler() {
        return this.craftingInventory;
    }

    @Override
    public ItemStackHandler getFluidSlotsHandler() {
        return this.fluidSlots;
    }

    @Override
    public IItemHandlerModifiable getCombinedHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.getHandler(), this.getToolSlotsHandler(), this.getFluidSlotsHandler(), this.getCraftingGridHandler()});
    }

    @Override
    public FluidTank getLeftTank() {
        return this.leftTank;
    }

    @Override
    public FluidTank getRightTank() {
        return this.rightTank;
    }

    public void saveAllData() {
        this.saveTanks();
        this.saveItems();
        this.saveTime();
        this.saveAbility();
        this.slotManager.saveUnsortableSlots(this.stack);
        this.slotManager.saveMemorySlots(this.stack);
        this.settingsManager.saveSettings(this.stack);
    }

    public void loadAllData() {
        this.loadTier();
        this.loadTanks();
        this.loadItems();
        this.loadTime();
        this.loadAbility();
        this.slotManager.loadUnsortableSlots(this.stack);
        this.slotManager.loadMemorySlots(this.stack);
        this.settingsManager.loadSettings(this.stack);
    }

    public void saveItems() {
        this.stack.set((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get(), (Object)this.itemsToList(this.stack.has((DataComponentType)ModDataComponents.BACKPACK_CONTAINER.get()) ? this.inventory.getSlots() : this.tier.getStorageSlots(), this.inventory));
        this.stack.set((DataComponentType)ModDataComponents.CRAFTING_CONTAINER.get(), (Object)this.itemsToList(9, this.craftingInventory));
        this.stack.set((DataComponentType)ModDataComponents.TOOLS_CONTAINER.get(), (Object)this.itemsToList(this.stack.has((DataComponentType)ModDataComponents.TOOLS_CONTAINER.get()) ? this.toolSlots.getSlots() : this.tier.getToolSlots(), this.toolSlots));
    }

    public void loadItems() {
        this.inventory = this.createHandler(((BackpackContainerContents)this.stack.getOrDefault(ModDataComponents.BACKPACK_CONTAINER, (Object)BackpackContainerContents.fromItems(this.tier.getStorageSlots(), (List<ItemStack>)NonNullList.withSize((int)this.tier.getStorageSlots(), (Object)ItemStack.EMPTY)))).getItems(), true);
        this.toolSlots = this.createToolsHandler(((BackpackContainerContents)this.stack.getOrDefault(ModDataComponents.TOOLS_CONTAINER, (Object)BackpackContainerContents.fromItems(this.tier.getToolSlots(), (List<ItemStack>)NonNullList.withSize((int)this.tier.getToolSlots(), (Object)ItemStack.EMPTY)))).getItems());
        this.craftingInventory = this.createHandler(((BackpackContainerContents)this.stack.getOrDefault(ModDataComponents.CRAFTING_CONTAINER, (Object)BackpackContainerContents.fromItems(9, (List<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY)))).getItems(), false);
    }

    public void saveTanks() {
        this.stack.set((DataComponentType)ModDataComponents.FLUID_TANKS.get(), (Object)new FluidTanks(this.leftTank.getCapacity(), this.leftTank.getFluid(), this.rightTank.getFluid()));
    }

    public void loadTanks() {
        FluidTanks tanks = (FluidTanks)this.stack.getOrDefault((DataComponentType)ModDataComponents.FLUID_TANKS.get(), (Object)FluidTanks.createTanks(this.tier.getTankCapacity()));
        this.leftTank.setCapacity(tanks.capacity());
        this.leftTank.setFluid(tanks.leftFluidStack());
        this.rightTank.setCapacity(tanks.capacity());
        this.rightTank.setFluid(tanks.rightFluidStack());
    }

    public void saveAbility() {
        this.stack.set((DataComponentType)ModDataComponents.ABILITY.get(), (Object)this.ability);
    }

    public void loadAbility() {
        this.ability = (Boolean)this.stack.getOrDefault(ModDataComponents.ABILITY, (Object)((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.forceAbilityEnabled.get()));
    }

    public void saveTime() {
        this.stack.set((DataComponentType)ModDataComponents.LAST_TIME.get(), (Object)this.lastTime);
    }

    public void loadTime() {
        this.lastTime = (Integer)this.stack.getOrDefault((DataComponentType)ModDataComponents.LAST_TIME.get(), (Object)0);
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 0, this.player) || InventoryActions.transferContainerTank(this, this.getRightTank(), 2, this.player);
    }

    @Override
    public boolean hasColor() {
        return this.stack.has(DataComponents.DYED_COLOR);
    }

    @Override
    public int getColor() {
        if (this.hasColor()) {
            return ((DyedItemColor)this.stack.get(DataComponents.DYED_COLOR)).rgb();
        }
        return 0;
    }

    @Override
    public boolean hasSleepingBagColor() {
        return this.stack.has(ModDataComponents.SLEEPING_BAG_COLOR);
    }

    @Override
    public int getSleepingBagColor() {
        if (this.hasSleepingBagColor()) {
            return (Integer)this.stack.getOrDefault(ModDataComponents.SLEEPING_BAG_COLOR, (Object)DyeColor.RED.getId());
        }
        return DyeColor.RED.getId();
    }

    @Override
    public boolean getAbilityValue() {
        return ((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() ? (BackpackAbilities.ALLOWED_ABILITIES.contains(this.getItemStack().getItem()) ? this.ability : false) : false;
    }

    @Override
    public void setAbility(boolean value) {
        this.ability = value;
    }

    @Override
    public int getLastTime() {
        return this.lastTime;
    }

    @Override
    public void setLastTime(int time) {
        this.lastTime = time;
    }

    @Override
    public int getRows() {
        return (int)Math.ceil((double)this.getHandler().getSlots() / 9.0);
    }

    @Override
    public int getYOffset() {
        return 18 * Math.max(0, this.getRows() - 3);
    }

    @Override
    public boolean hasBlockEntity() {
        return false;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return false;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    @Override
    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    @Override
    public Tiers.Tier getTier() {
        return this.tier;
    }

    @Override
    public Level getLevel() {
        return this.player.level();
    }

    @Override
    public BlockPos getPosition() {
        return this.player.blockPosition();
    }

    @Override
    public byte getScreenID() {
        return this.screenID;
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public void setUsingPlayer(@Nullable Player player) {
        this.player = player;
    }

    @Override
    public void setDataChanged(byte ... dataIds) {
        if (this.getLevel().isClientSide) {
            return;
        }
        block8: for (byte data : dataIds) {
            switch (data) {
                case 4: {
                    this.saveTanks();
                    continue block8;
                }
                case 7: {
                    this.saveAbility();
                    continue block8;
                }
                case 8: {
                    this.saveTime();
                    continue block8;
                }
                case 9: {
                    this.slotManager.saveUnsortableSlots(this.stack);
                    this.slotManager.saveMemorySlots(this.stack);
                    this.sendMemorySlotsToClient();
                    continue block8;
                }
                case 10: {
                    this.settingsManager.saveSettings(this.stack);
                    continue block8;
                }
                case 11: {
                    this.saveAllData();
                }
            }
        }
        this.sendPackets();
    }

    public void setSlotChanged(int index, ItemStack stack, byte dataId) {
        switch (dataId) {
            case 0: {
                this.stack.update(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(this.getTier().getStorageSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
                break;
            }
            case 2: {
                this.stack.update(ModDataComponents.CRAFTING_CONTAINER, (Object)new BackpackContainerContents(9), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
                break;
            }
            case 1: {
                this.stack.update(ModDataComponents.TOOLS_CONTAINER, (Object)new BackpackContainerContents(this.tier.getToolSlots()), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
            }
        }
        this.sendPackets();
    }

    public void sendMemorySlotsToClient() {
        if (this.player != null && !this.getLevel().isClientSide && this.screenID == 1) {
            this.player.containerMenu.sendAllDataToRemote();
        }
    }

    public void sendPackets() {
        Player player;
        if (this.screenID == 2) {
            if (this.slotManager.isSelectorActive((byte)1) || this.slotManager.isSelectorActive((byte)0)) {
                return;
            }
            AttachmentUtils.synchronise(this.player);
            AttachmentUtils.synchroniseToOthers(this.player);
        }
        if (this.screenID == 1 && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)serverPlayer, (CustomPacketPayload)new ClientboundSyncItemStackPacket(serverPlayer.getId(), this.stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public BackpackContainerContents itemsToList(int size, ItemStackHandler handler) {
        int i;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(size);
        for (i = 0; i < handler.getSlots(); ++i) {
            list.add(handler.getStackInSlot(i));
        }
        for (i = handler.getSlots(); i < size; ++i) {
            list.add(ItemStack.EMPTY);
        }
        return BackpackContainerContents.fromItems(size, list);
    }

    @Override
    public void setDataChanged() {
    }

    public Component getName() {
        return Component.translatable((String)"screen.travelersbackpack.item");
    }

    public Component getDisplayName() {
        return Component.translatable((String)"screen.travelersbackpack.item");
    }

    public static void abilityTick(Player player) {
        if (player.isAlive() && AttachmentUtils.isWearingBackpack(player) && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, AttachmentUtils.getWearingBackpack(player))) {
            TravelersBackpackContainer container = AttachmentUtils.getBackpackInv(player);
            if (!player.level().isClientSide && container.getLastTime() > 0) {
                container.setLastTime(container.getLastTime() - 1);
                container.setDataChanged(8);
            }
            if (container.getAbilityValue()) {
                BackpackAbilities.ABILITIES.abilityTick(AttachmentUtils.getWearingBackpack(player), player, null);
            }
        }
    }

    public static void openGUI(ServerPlayer serverPlayerEntity, ItemStack stack, byte screenID) {
        if (!serverPlayerEntity.level().isClientSide) {
            if (screenID == 1) {
                serverPlayerEntity.openMenu((MenuProvider)new TravelersBackpackContainer(stack, (Player)serverPlayerEntity, screenID), packetBuffer -> packetBuffer.writeByte(screenID));
            }
            if (screenID == 2) {
                serverPlayerEntity.openMenu((MenuProvider)AttachmentUtils.getBackpackInv((Player)serverPlayerEntity), packetBuffer -> packetBuffer.writeByte(screenID).writeBoolean(false));
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory inventory, Player player) {
        return new TravelersBackpackItemMenu(windowID, inventory, this);
    }

    private ItemStackHandler createHandler(NonNullList<ItemStack> stacks, final boolean isInventory) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                if (isInventory) {
                    TravelersBackpackContainer.this.setSlotChanged(slot, this.getStackInSlot(slot), (byte)0);
                } else {
                    TravelersBackpackContainer.this.setSlotChanged(slot, this.getStackInSlot(slot), (byte)2);
                }
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return BackpackSlotItemHandler.isItemValid(stack);
            }
        };
    }

    private ItemStackHandler createToolsHandler(NonNullList<ItemStack> items) {
        return new ItemStackHandler(items){

            protected void onContentsChanged(int slot) {
                TravelersBackpackContainer.this.setSlotChanged(slot, this.getStackInSlot(slot), (byte)1);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return ToolSlotItemHandler.isValid(stack);
            }
        };
    }

    private FluidTank createFluidHandler(int capacity) {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                TravelersBackpackContainer.this.setDataChanged(4);
            }
        };
    }
}

