/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.components.Settings;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class SettingsManager {
    private final ITravelersBackpackContainer container;
    private byte[] craftingSettings;
    private byte[] toolSlotsSettings;
    public static final byte CRAFTING = 0;
    public static final byte TOOL_SLOTS = 1;
    public static final int HAS_CRAFTING_GRID = 0;
    public static final int SHOW_CRAFTING_GRID = 1;
    public static final int SHIFT_CLICK_TO_BACKPACK = 2;
    public static final int SHOW_TOOL_SLOTS = 0;
    public static final String CRAFTING_SETTINGS = "CraftingSettings";
    public static final String TOOL_SLOTS_SETTINGS = "ToolSlotsSettings";

    public SettingsManager(ITravelersBackpackContainer container) {
        this.craftingSettings = new byte[]{(byte)((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.craftingUpgrade.includeByDefault.get() != false ? 1 : 0), 0, 1};
        this.toolSlotsSettings = new byte[]{0};
        this.container = container;
    }

    public boolean hasCraftingGrid() {
        return this.getByte((byte)0, 0) == 1;
    }

    public boolean shiftClickToBackpack() {
        return this.getByte((byte)0, 2) == 1;
    }

    public boolean showCraftingGrid() {
        return this.getByte((byte)0, 1) == 1;
    }

    public boolean showToolSlots() {
        return this.getByte((byte)1, 0) == 1;
    }

    public byte getByte(byte dataArray, int place) {
        if (dataArray == 0) {
            return this.craftingSettings[place];
        }
        if (dataArray == 1) {
            return this.toolSlotsSettings[place];
        }
        return 0;
    }

    public void set(byte selectedDataArray, int place, byte value) {
        byte[] dataArray = new byte[]{};
        if (selectedDataArray == 0) {
            dataArray = this.craftingSettings;
        }
        if (selectedDataArray == 1) {
            dataArray = this.toolSlotsSettings;
        }
        dataArray[place] = value;
        this.setChanged();
    }

    public void saveSettings(CompoundTag compound) {
        compound.putByteArray(CRAFTING_SETTINGS, this.craftingSettings);
        compound.putByteArray(TOOL_SLOTS_SETTINGS, this.toolSlotsSettings);
    }

    public void saveSettings(ItemStack stack) {
        stack.set(ModDataComponents.SETTINGS, Settings.createSettings(Arrays.asList(ArrayUtils.toObject((byte[])this.craftingSettings)), Arrays.asList(ArrayUtils.toObject((byte[])this.toolSlotsSettings))));
    }

    public void loadSettings(CompoundTag compound) {
        byte[] byArray;
        byte[] byArray2;
        if (compound.contains(CRAFTING_SETTINGS)) {
            if (compound.getByteArray(CRAFTING_SETTINGS).length == 3) {
                byArray2 = compound.getByteArray(CRAFTING_SETTINGS);
            } else {
                byte[] byArray3 = new byte[3];
                byArray3[0] = 1;
                byArray3[1] = 0;
                byArray2 = byArray3;
                byArray3[2] = 1;
            }
        } else {
            byte[] byArray4 = new byte[3];
            byArray4[0] = (byte)((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.craftingUpgrade.includeByDefault.get() != false ? 1 : 0);
            byArray4[1] = 0;
            byArray2 = byArray4;
            byArray4[2] = 1;
        }
        this.craftingSettings = byArray2;
        if (compound.contains(TOOL_SLOTS_SETTINGS)) {
            byArray = compound.getByteArray(TOOL_SLOTS_SETTINGS);
        } else {
            byte[] byArray5 = new byte[1];
            byArray = byArray5;
            byArray5[0] = 0;
        }
        this.toolSlotsSettings = byArray;
    }

    public void loadSettings(ItemStack stack) {
        List settings = (List)stack.getOrDefault(ModDataComponents.SETTINGS, this.createDefaults());
        this.craftingSettings = ArrayUtils.toPrimitive((Byte[])((Byte[])((List)settings.get(0)).stream().toArray(Byte[]::new)));
        this.toolSlotsSettings = ArrayUtils.toPrimitive((Byte[])((Byte[])((List)settings.get(1)).stream().toArray(Byte[]::new)));
    }

    public void setChanged() {
        if (this.container.getScreenID() != 3) {
            this.container.setDataChanged(10);
        } else {
            this.container.setDataChanged();
        }
    }

    public void loadDefaults() {
        this.craftingSettings = new byte[]{(byte)((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.craftingUpgrade.includeByDefault.get() != false ? 1 : 0), 0, 1};
        this.toolSlotsSettings = new byte[]{0};
        this.setChanged();
    }

    public List<List<Byte>> createDefaults() {
        this.craftingSettings = new byte[]{(byte)((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.craftingUpgrade.includeByDefault.get() != false ? 1 : 0), 0, 1};
        this.toolSlotsSettings = new byte[]{0};
        return Settings.createSettings(Arrays.asList(ArrayUtils.toObject((byte[])this.craftingSettings)), Arrays.asList(ArrayUtils.toObject((byte[])this.toolSlotsSettings)));
    }

    public boolean isDefault() {
        return Arrays.equals(this.craftingSettings, new byte[]{(byte)((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.craftingUpgrade.includeByDefault.get() != false ? 1 : 0), 0, 1}) && Arrays.equals(this.toolSlotsSettings, new byte[]{0});
    }

    public List<List<Byte>> getSettings() {
        return Settings.createSettings(Arrays.asList(ArrayUtils.toObject((byte[])this.craftingSettings)), Arrays.asList(ArrayUtils.toObject((byte[])this.toolSlotsSettings)));
    }

    public SettingsManager getManager(List<List<Byte>> data) {
        this.craftingSettings = ArrayUtils.toPrimitive((Byte[])((Byte[])data.get(0).stream().toArray(Byte[]::new)));
        this.toolSlotsSettings = ArrayUtils.toPrimitive((Byte[])((Byte[])data.get(1).stream().toArray(Byte[]::new)));
        return this;
    }
}

