/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.init.ModFluids;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.util.ContainerUtils;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;

public class InventoryActions {
    public static boolean transferContainerTank(ITravelersBackpackContainer container, FluidTank tank, int slotIn, @Nullable Player player) {
        Optional fluidHandler;
        boolean hasFluidHandler;
        ItemStackHandler itemStackHandler = container.getFluidSlotsHandler();
        ItemStack stackIn = itemStackHandler.getStackInSlot(slotIn);
        int slotOut = slotIn + 1;
        if (tank == null || stackIn.isEmpty() || stackIn.getItem() == Items.AIR) {
            return false;
        }
        if (stackIn.getItem() instanceof PotionItem && stackIn.getItem() != Items.GLASS_BOTTLE && !(hasFluidHandler = FluidUtil.getFluidHandler((ItemStack)stackIn).isPresent())) {
            int amount = 250;
            FluidStack fluidStack = new FluidStack((Fluid)ModFluids.POTION_FLUID.get(), amount);
            FluidUtils.setFluidStackData(stackIn, fluidStack);
            if ((tank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)fluidStack)) && tank.getFluidAmount() + amount <= tank.getCapacity()) {
                ItemStack bottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                ItemStack currentStackOut = itemStackHandler.getStackInSlot(slotOut);
                if (currentStackOut.isEmpty() || currentStackOut.getItem() == bottle.getItem()) {
                    if (currentStackOut.getItem() == bottle.getItem()) {
                        if (currentStackOut.getCount() + 1 > currentStackOut.getMaxStackSize()) {
                            return false;
                        }
                        bottle.setCount(itemStackHandler.getStackInSlot(slotOut).getCount() + 1);
                    }
                    tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    ContainerUtils.removeItem(container, slotIn, 1);
                    itemStackHandler.setStackInSlot(slotOut, bottle);
                    if (player != null) {
                        player.level().playSound(null, player.position().x(), player.position().y() + 0.5, player.position().z(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    return true;
                }
            }
        }
        if (stackIn.getItem() == Items.GLASS_BOTTLE && tank.getFluid().getFluid() == ModFluids.POTION_FLUID.get() && tank.getFluidAmount() >= 250) {
            ItemStack stackOut = FluidUtils.getItemStackFromFluidStack(tank.getFluid());
            ItemStack currentStackOut = itemStackHandler.getStackInSlot(slotOut);
            if (currentStackOut.isEmpty()) {
                tank.drain(250, IFluidHandler.FluidAction.EXECUTE);
                ContainerUtils.removeItem(container, slotIn, 1);
                itemStackHandler.setStackInSlot(slotOut, stackOut);
                if (player != null) {
                    player.level().playSound(null, player.position().x(), player.position().y() + 0.5, player.position().z(), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return true;
            }
        }
        if ((fluidHandler = FluidUtil.getFluidHandler((ItemStack)stackIn)).isPresent()) {
            ItemStack slotOutStack;
            ItemStack stackOut;
            FluidTank tankCopy;
            ItemStack stackInCopy;
            Optional fluidstack = FluidUtil.getFluidContained((ItemStack)stackIn);
            if (fluidstack.isPresent() && fluidstack.map(FluidStack::getAmount).orElse(0) > 0) {
                int amount = fluidstack.map(FluidStack::getAmount).orElse(0);
                if (tank.getFluidAmount() > 0 && !FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)fluidstack.orElse(FluidStack.EMPTY))) {
                    return false;
                }
                stackInCopy = stackIn.copy();
                tankCopy = new FluidTank(tank.getCapacity());
                tankCopy.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                stackOut = FluidUtil.tryEmptyContainer((ItemStack)stackInCopy, (IFluidHandler)tankCopy, (int)amount, (Player)player, (boolean)false).getResult();
                if (!stackOut.isEmpty() && ((slotOutStack = itemStackHandler.getStackInSlot(slotOut)).isEmpty() || slotOutStack.getItem() == stackOut.getItem())) {
                    if (slotOutStack.getItem() == stackOut.getItem()) {
                        stackOut.setCount(slotOutStack.getCount() + 1);
                        if (stackOut.getCount() > slotOutStack.getMaxStackSize()) {
                            return false;
                        }
                    }
                    FluidUtil.tryEmptyContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, (Player)player, (boolean)true);
                    itemStackHandler.setStackInSlot(slotOut, stackOut);
                    ContainerUtils.removeItem(container, slotIn, 1);
                    return true;
                }
            }
            if (tank.isEmpty() || tank.getFluidAmount() <= 0) {
                return false;
            }
            if (InventoryActions.isFluidEqual(stackIn, tank)) {
                int amount = FluidUtil.getFluidHandler((ItemStack)stackIn).map(iFluidHandlerItem -> iFluidHandlerItem.getTankCapacity(0)).orElse(0);
                stackInCopy = stackIn.copy();
                tankCopy = new FluidTank(tank.getCapacity());
                tankCopy.fill(tank.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                stackOut = FluidUtil.tryFillContainer((ItemStack)stackInCopy, (IFluidHandler)tankCopy, (int)amount, (Player)player, (boolean)true).getResult();
                if (stackOut.isEmpty()) {
                    return false;
                }
                slotOutStack = itemStackHandler.getStackInSlot(slotOut);
                if (slotOutStack.isEmpty() || slotOutStack.getItem() == stackOut.getItem()) {
                    if (slotOutStack.getItem() == stackOut.getItem()) {
                        stackOut.setCount(slotOutStack.getCount() + 1);
                        if (stackOut.getCount() > slotOutStack.getMaxStackSize()) {
                            return false;
                        }
                    }
                    FluidUtil.tryFillContainer((ItemStack)stackIn, (IFluidHandler)tank, (int)amount, (Player)player, (boolean)true);
                    itemStackHandler.setStackInSlot(slotOut, stackOut);
                    ContainerUtils.removeItem(container, slotIn, 1);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isFluidEqual(ItemStack stackIn, FluidTank tank) {
        if (FluidUtil.getFluidContained((ItemStack)stackIn).isPresent() && FluidUtil.getFluidContained((ItemStack)stackIn).map(FluidStack::getAmount).orElse(0) > 0) {
            return FluidUtil.getFluidContained((ItemStack)stackIn).map(fluidstack -> FluidStack.isSameFluidSameComponents((FluidStack)fluidstack, (FluidStack)tank.getFluid())).orElse(false);
        }
        return !FluidUtil.getFluidContained((ItemStack)stackIn).isPresent();
    }
}

