/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import com.tiviacz.travelersbackpack.util.ContainerUtils;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CraftingContainerImproved
implements CraftingContainer {
    private final ItemStackHandler handler;
    private final TravelersBackpackBaseMenu menu;
    public boolean checkChanges = true;

    public CraftingContainerImproved(ITravelersBackpackContainer container, TravelersBackpackBaseMenu menu) {
        this.handler = container.getCraftingGridHandler();
        this.menu = menu;
    }

    public int getContainerSize() {
        return this.handler.getSlots();
    }

    public NonNullList<ItemStack> getStackList() {
        NonNullList stacks = NonNullList.create();
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            stacks.add(i, (Object)this.getItem(i));
        }
        return stacks;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.handler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        return slot >= this.getContainerSize() ? ItemStack.EMPTY : this.handler.getStackInSlot(slot);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return ContainerUtils.takeItem((IItemHandler)this.handler, slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = ContainerUtils.removeItem((IItemHandler)this.handler, slot, amount);
        if (!stack.isEmpty() && this.checkChanges) {
            this.menu.slotsChanged((Container)this);
        }
        return stack;
    }

    public void setItem(int slot, ItemStack stack) {
        this.handler.setStackInSlot(slot, stack);
        if (this.checkChanges) {
            this.menu.slotsChanged((Container)this);
        }
    }

    public void setChanged() {
    }

    public boolean stillValid(Player p_39340_) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
    }

    public int getHeight() {
        return 3;
    }

    public int getWidth() {
        return 3;
    }

    public List<ItemStack> getItems() {
        return List.copyOf(this.getStackList());
    }

    public void fillStackedContents(StackedContents contents) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            contents.accountSimpleStack(this.getItem(i));
        }
    }
}

