/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.entity.IEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.commands.AccessBackpackCommand;
import com.tiviacz.travelersbackpack.commands.ClearBackpackCommand;
import com.tiviacz.travelersbackpack.commands.RestoreBackpackCommand;
import com.tiviacz.travelersbackpack.commands.UnpackBackpackCommand;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipe;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModTags;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.items.UpgradeItem;
import com.tiviacz.travelersbackpack.network.ClientboundSendMessagePacket;
import com.tiviacz.travelersbackpack.network.ClientboundSyncAttachmentPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.LogHelper;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.command.ConfigCommand;

@EventBusSubscriber(modid="travelersbackpack", bus=EventBusSubscriber.Bus.GAME)
public class NeoForgeEventHandler {
    private static boolean checkAbilitiesForRemoval = true;
    private static long nextBackpackCountCheck = 0L;
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 100;

    @SubscribeEvent
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        Level level = event.getEntity().level();
        if (event.getNewSpawn() != null) {
            Block block = level.getBlockState(event.getNewSpawn()).getBlock();
            if (!level.isClientSide && block instanceof SleepingBagBlock && !event.isForced()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockEntity backpack;
        BlockEntity list;
        BlockEntity oldSleepingBag;
        TravelersBackpackBlockEntity blockEntity;
        BlockEntity context;
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.rightClickUnequip.get()).booleanValue() && !TravelersBackpack.enableIntegration() && AttachmentUtils.isWearingBackpack(player) && !level.isClientSide && player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND && player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
            TravelersBackpackItem item;
            Item item2;
            ItemStack backpackStack = AttachmentUtils.getWearingBackpack(player);
            context = new UseOnContext(level, player, InteractionHand.MAIN_HAND, backpackStack, event.getHitVec());
            boolean quickPickupFlag = level.getBlockState(pos).getBlock() instanceof TravelersBackpackBlock;
            if (!quickPickupFlag && (item2 = backpackStack.getItem()) instanceof TravelersBackpackItem && (item = (TravelersBackpackItem)item2).place(new BlockPlaceContext((UseOnContext)context)) == InteractionResult.sidedSuccess((boolean)level.isClientSide)) {
                player.swing(InteractionHand.MAIN_HAND, true);
                level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.05f, (1.0f + (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f) * 0.7f);
                AttachmentUtils.getAttachment(player).ifPresent(ITravelersBackpack::removeWearable);
                AttachmentUtils.synchronise(player);
                AttachmentUtils.synchroniseToOthers(player);
                event.setCanceled(true);
                return;
            }
        }
        if (player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND && player.getItemInHand(InteractionHand.MAIN_HAND).is(ModTags.SLEEPING_BAGS) && (context = level.getBlockEntity(pos)) instanceof TravelersBackpackBlockEntity) {
            blockEntity = (TravelersBackpackBlockEntity)context;
            oldSleepingBag = blockEntity.getProperSleepingBag(blockEntity.getSleepingBagColor()).getBlock().asItem().getDefaultInstance();
            blockEntity.setSleepingBagColor(ShapedBackpackRecipe.getProperColor(player.getItemInHand(InteractionHand.MAIN_HAND).getItem()));
            if (!level.isClientSide) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.above().getY(), (double)pos.getZ(), (ItemStack)oldSleepingBag);
                stack.shrink(1);
            }
            level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, (1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f) * 0.7f);
            player.swing(InteractionHand.MAIN_HAND, true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (player.isShiftKeyDown() && player.getItemInHand(InteractionHand.MAIN_HAND).getItem() == ModItems.BLANK_UPGRADE.get() && (oldSleepingBag = level.getBlockEntity(pos)) instanceof TravelersBackpackBlockEntity) {
            int fluidAmountRight;
            int fluidAmountLeft;
            blockEntity = (TravelersBackpackBlockEntity)oldSleepingBag;
            list = NonNullList.create();
            for (int i = 0; i < blockEntity.getCombinedHandler().getSlots(); ++i) {
                ItemStack stackInSlot = blockEntity.getCombinedHandler().getStackInSlot(i);
                if (stackInSlot.isEmpty()) continue;
                list.add((Object)stackInSlot);
                blockEntity.getCombinedHandler().setStackInSlot(i, ItemStack.EMPTY);
            }
            list.addAll(UpgradeItem.getUpgrades(blockEntity));
            if (!blockEntity.getSlotManager().getUnsortableSlots().isEmpty()) {
                blockEntity.getSlotManager().getUnsortableSlots().clear();
            }
            if (!blockEntity.getSlotManager().getMemorySlots().isEmpty()) {
                blockEntity.getSlotManager().getMemorySlots().clear();
            }
            int n = fluidAmountLeft = blockEntity.getLeftTank().isEmpty() ? 0 : blockEntity.getLeftTank().getFluidAmount();
            if (fluidAmountLeft > Tiers.LEATHER.getTankCapacity()) {
                blockEntity.getLeftTank().drain(fluidAmountLeft - Tiers.LEATHER.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
            int n2 = fluidAmountRight = blockEntity.getRightTank().isEmpty() ? 0 : blockEntity.getRightTank().getFluidAmount();
            if (fluidAmountRight > Tiers.LEATHER.getTankCapacity()) {
                blockEntity.getRightTank().drain(fluidAmountRight - Tiers.LEATHER.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
            if (!level.isClientSide) {
                Containers.dropContents((Level)level, (BlockPos)pos.above(), (NonNullList)list);
            }
            blockEntity.getHandler().setSize(Tiers.LEATHER.getStorageSlots());
            blockEntity.getToolSlotsHandler().setSize(Tiers.LEATHER.getToolSlots());
            blockEntity.resetTier();
            blockEntity.getLeftTank().setCapacity(Tiers.LEATHER.getTankCapacity());
            blockEntity.getRightTank().setCapacity(Tiers.LEATHER.getTankCapacity());
            blockEntity.getSettingsManager().loadDefaults();
            player.swing(InteractionHand.MAIN_HAND, true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.rightClickEquip.get()).booleanValue() && (list = event.getLevel().getBlockEntity(pos)) instanceof TravelersBackpackBlockEntity) {
            blockEntity = (TravelersBackpackBlockEntity)list;
            if (player.isShiftKeyDown() && !AttachmentUtils.isWearingBackpack(player) && !TravelersBackpack.enableIntegration()) {
                backpack = new ItemStack((ItemLike)level.getBlockState(pos).getBlock(), 1).copy();
                blockEntity.transferToItemStack((ItemStack)backpack);
                Direction direction = (Direction)level.getBlockState(pos).getValue((Property)TravelersBackpackBlock.FACING);
                if (!level.isClientSide && level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState())) {
                    AttachmentUtils.equipBackpack(player, (ItemStack)backpack);
                    blockEntity.removeSleepingBag(level, direction);
                    player.swing(InteractionHand.MAIN_HAND, true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
        if ((backpack = level.getBlockEntity(pos)) instanceof TravelersBackpackBlockEntity) {
            blockEntity = (TravelersBackpackBlockEntity)backpack;
            if (player.isShiftKeyDown() && hand == InteractionHand.MAIN_HAND && player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                backpack = new ItemStack((ItemLike)level.getBlockState(pos).getBlock(), 1).copy();
                blockEntity.transferToItemStack((ItemStack)backpack);
                Direction direction = (Direction)level.getBlockState(pos).getValue((Property)TravelersBackpackBlock.FACING);
                if (!level.isClientSide && level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState())) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, (ItemStack)backpack);
                    blockEntity.removeSleepingBag(level, direction);
                    level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, (1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f) * 0.7f);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEnderManAngerEvent(EnderManAngerEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.pumpkinAbility(event);
        }
    }

    @SubscribeEvent
    public static void blockBlazeProjectile(ProjectileImpactEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.blazeAbility(event);
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingChangeTargetEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.ghastAbility(event);
        }
    }

    @SubscribeEvent
    public static void onHit(AttackEntityEvent event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.beeAbility(event);
        }
    }

    @SubscribeEvent
    public static void onExpPickup(PlayerXpEvent.PickupXp event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue()) {
            BackpackAbilities.ABILITIES.lapisAbility(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && AttachmentUtils.isWearingBackpack(player = (Player)livingEntity) && ((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() && BackpackAbilities.creeperAbility(event)) {
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerDrops(LivingDropsEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && AttachmentUtils.isWearingBackpack(player = (Player)livingEntity)) {
            if (TravelersBackpack.enableIntegration()) {
                AttachmentUtils.getAttachment(player).ifPresent(attachment -> {
                    attachment.removeWearable();
                    attachment.synchronise();
                    attachment.synchroniseToOthers(player);
                });
                return;
            }
            if (player.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
                return;
            }
            ItemStack stack = AttachmentUtils.getWearingBackpack(player);
            if (BackpackUtils.onPlayerDrops(player.level(), player, stack)) {
                if (player.level().isClientSide) {
                    return;
                }
                ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), stack);
                itemEntity.setDefaultPickUpDelay();
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ClientboundSendMessagePacket(true, player.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                LogHelper.info("There's no space for backpack. Dropping backpack item at X: " + player.blockPosition().getX() + " Y: " + player.getY() + " Z: " + player.blockPosition().getZ(), new Object[0]);
                event.getDrops().add(itemEntity);
                AttachmentUtils.getAttachment(player).ifPresent(ITravelersBackpack::removeWearable);
                AttachmentUtils.synchronise(player);
            }
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().getType()) && AttachmentUtils.isWearingBackpack(event.getEntity())) {
            if (!(event.getSource().getEntity() instanceof Player)) {
                return;
            }
            ItemEntity itemEntity = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), AttachmentUtils.getWearingBackpack(event.getEntity()));
            event.getDrops().add(itemEntity);
        }
    }

    @SubscribeEvent
    public static void entityLeave(EntityLeaveLevelEvent event) {
        ItemEntity itemEntity;
        block8: {
            block7: {
                Entity entity = event.getEntity();
                if (!(entity instanceof ItemEntity)) break block7;
                itemEntity = (ItemEntity)entity;
                if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.voidProtection.get()).booleanValue()) break block8;
            }
            return;
        }
        if (itemEntity.getItem().getItem() instanceof TravelersBackpackItem) {
            if (event.getLevel().isClientSide) {
                return;
            }
            BlockPos entityPos = itemEntity.blockPosition();
            Vec3 entityPosCentered = entityPos.getCenter();
            double y = entityPosCentered.y();
            if (y < (double)event.getLevel().getMinBuildHeight()) {
                ItemEntity protectedItemEntity = new ItemEntity(event.getLevel(), entityPosCentered.x(), y, entityPosCentered.z(), itemEntity.getItem());
                protectedItemEntity.setNoGravity(true);
                protectedItemEntity.setDefaultPickUpDelay();
                for (double i = y = (double)event.getLevel().getMinBuildHeight(); i < (double)event.getLevel().getHeight(); i += 1.0) {
                    if (!event.getLevel().getBlockState(BlockPos.containing((Position)new Vec3(entityPosCentered.x(), i, entityPosCentered.z()))).canBeReplaced()) continue;
                    y = i;
                    break;
                }
                protectedItemEntity.setPos(entityPosCentered.x(), y, entityPosCentered.z());
                protectedItemEntity.setDeltaMovement(0.0, 0.0, 0.0);
                event.getLevel().addFreshEntity((Entity)protectedItemEntity);
            }
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        AttachmentUtils.getAttachment(oldPlayer).ifPresent(oldTravelersBackpack -> AttachmentUtils.getAttachment(event.getEntity()).ifPresent(newTravelersBackpack -> {
            newTravelersBackpack.setWearable(oldTravelersBackpack.getWearable());
            newTravelersBackpack.setContents(oldTravelersBackpack.getWearable());
        }));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        AttachmentUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        AttachmentUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        block8: {
            block7: {
                Entity entity = event.getEntity();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    AttachmentUtils.synchronise(player);
                }
                if ((entity = event.getEntity()) instanceof LivingEntity) {
                    IEntityTravelersBackpack travelersBackpack;
                    Optional<IEntityTravelersBackpack> data;
                    LivingEntity living = (LivingEntity)entity;
                    if (!event.loadedFromDisk() && ((Boolean)TravelersBackpackConfig.SERVER.world.spawnEntitiesWithBackpack.get()).booleanValue() && (data = AttachmentUtils.getEntityAttachment(living)).isPresent() && Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().getType()) && !(travelersBackpack = data.get()).hasWearable() && (double)event.getLevel().getRandom().nextFloat() < (Double)TravelersBackpackConfig.SERVER.world.chance.get()) {
                        boolean isNether = living.getType() == EntityType.PIGLIN || living.getType() == EntityType.WITHER_SKELETON;
                        RandomSource rand = event.getLevel().random;
                        ItemStack backpack = isNether ? ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.get(rand.nextIntBetweenInclusive(0, ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.size() - 1)).getDefaultInstance() : ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.get(rand.nextIntBetweenInclusive(0, ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.size() - 1)).getDefaultInstance();
                        backpack.set(ModDataComponents.SLEEPING_BAG_COLOR, (Object)DyeColor.values()[rand.nextIntBetweenInclusive(0, DyeColor.values().length - 1)].getId());
                        travelersBackpack.setWearable(backpack);
                        travelersBackpack.synchronise();
                    }
                }
                if (!((entity = event.getEntity()) instanceof ItemEntity)) break block7;
                itemEntity = (ItemEntity)entity;
                if (((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.invulnerableBackpack.get()).booleanValue()) break block8;
            }
            return;
        }
        if (itemEntity.getItem().getItem() instanceof TravelersBackpackItem) {
            itemEntity.setUnlimitedLifetime();
            itemEntity.setInvulnerable(true);
        }
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        ServerPlayer target;
        if (event.getTarget() instanceof Player && !event.getTarget().level().isClientSide) {
            target = (ServerPlayer)event.getTarget();
            AttachmentUtils.getAttachment((Player)target).ifPresent(data -> PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new ClientboundSyncAttachmentPacket(target.getId(), true, AttachmentUtils.getWearingBackpack((Player)target)), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getTarget().getType()) && !event.getTarget().level().isClientSide) {
            target = (LivingEntity)event.getTarget();
            AttachmentUtils.getEntityAttachment((LivingEntity)target).ifPresent(arg_0 -> NeoForgeEventHandler.lambda$playerTracking$4(event, (LivingEntity)target, arg_0));
        }
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        if (((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue() && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, AttachmentUtils.getWearingBackpack(event.getEntity()))) {
            TravelersBackpackContainer.abilityTick(event.getEntity());
            if (!checkAbilitiesForRemoval && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, AttachmentUtils.getWearingBackpack(event.getEntity()))) {
                checkAbilitiesForRemoval = true;
            }
        }
        if (!(!checkAbilitiesForRemoval || event.getEntity().level().isClientSide || AttachmentUtils.isWearingBackpack(event.getEntity()) && ((Boolean)TravelersBackpackConfig.SERVER.backpackAbilities.enableBackpackAbilities.get()).booleanValue())) {
            BackpackAbilities.ABILITIES.armorAbilityRemovals(event.getEntity());
            checkAbilitiesForRemoval = false;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.slownessDebuff.tooManyBackpacksSlowness.get()).booleanValue() || nextBackpackCountCheck > event.getLevel().getGameTime()) {
            return;
        }
        nextBackpackCountCheck = event.getLevel().getGameTime() + 100L;
        event.getLevel().players().forEach(player -> {
            if (player.isCreative() || player.isSpectator()) {
                return;
            }
            AtomicInteger numberOfBackpacks = NeoForgeEventHandler.checkBackpacksForSlowness(player);
            if (numberOfBackpacks.get() == 0) {
                return;
            }
            int maxNumberOfBackpacks = (Integer)TravelersBackpackConfig.SERVER.slownessDebuff.maxNumberOfBackpacks.get();
            if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * (Double)TravelersBackpackConfig.SERVER.slownessDebuff.slownessPerExcessedBackpack.get()));
                player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, numberOfSlownessLevels - 1, false, false));
            }
        });
    }

    public static AtomicInteger checkBackpacksForSlowness(Player player) {
        AtomicInteger atomic = new AtomicInteger(0);
        for (int i = 0; i < player.getInventory().items.size(); ++i) {
            if (!(((ItemStack)player.getInventory().items.get(i)).getItem() instanceof TravelersBackpackItem)) continue;
            atomic.incrementAndGet();
        }
        if (((ItemStack)player.getInventory().offhand.get(0)).getItem() instanceof TravelersBackpackItem) {
            atomic.incrementAndGet();
        }
        return atomic;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        new AccessBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new RestoreBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClearBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new UnpackBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void explosionDetonate(ExplosionEvent.Detonate event) {
        for (int i = 0; i < event.getAffectedEntities().size(); ++i) {
            ItemEntity itemEntity;
            Entity entity = (Entity)event.getAffectedEntities().get(i);
            if (!(entity instanceof ItemEntity) || !((itemEntity = (ItemEntity)entity).getItem().getItem() instanceof TravelersBackpackItem)) continue;
            event.getAffectedEntities().remove(i);
        }
    }

    @SubscribeEvent
    public static void addVillagerTrade(VillagerTradesEvent event) {
        if (((Boolean)TravelersBackpackConfig.COMMON.enableVillagerTrade.get()).booleanValue() && event.getType() == VillagerProfession.LIBRARIAN) {
            ((List)event.getTrades().get(3)).add((trader, random) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, random.nextInt(64) + 48), new ItemStack((ItemLike)((TravelersBackpackItem)((Object)((Object)ModItems.VILLAGER_TRAVELERS_BACKPACK.get()))).asItem(), 1), 1, 50, 0.5f));
        }
    }

    private static /* synthetic */ void lambda$playerTracking$4(PlayerEvent.StartTracking event, LivingEntity target, IEntityTravelersBackpack data) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new ClientboundSyncAttachmentPacket(target.getId(), false, data.getWearable()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

