/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventHandler;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ServerboundAbilitySliderPacket;
import com.tiviacz.travelersbackpack.network.ServerboundSpecialActionPacket;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="travelersbackpack", value={Dist.CLIENT})
public class NeoForgeClientEventHandler {
    @SubscribeEvent
    public static void renderBackpackIcon(ScreenEvent.Render.Post event) {
        Screen screen;
        if (!((Boolean)TravelersBackpackConfig.CLIENT.showBackpackIconInInventory.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (AttachmentUtils.isWearingBackpack((Player)player) && (screen = Minecraft.getInstance().screen) instanceof InventoryScreen) {
            InventoryScreen screen2 = (InventoryScreen)screen;
            if (TravelersBackpack.enableIntegration()) {
                return;
            }
            GuiGraphics guiGraphics = event.getGuiGraphics();
            guiGraphics.renderItem(AttachmentUtils.getWearingBackpack((Player)player), screen2.getGuiLeft() + 77, screen2.getGuiTop() + 61 - 18);
            if (event.getMouseX() >= screen2.getGuiLeft() + 77 && event.getMouseX() < screen2.getGuiLeft() + 77 + 16 && event.getMouseY() >= screen2.getGuiTop() + 61 - 18 && event.getMouseY() < screen2.getGuiTop() + 61 - 18 + 16) {
                AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(screen2.getGuiLeft() + 77), (int)(screen2.getGuiTop() + 61 - 18), (int)-1000);
                String button = ModClientEventHandler.OPEN_BACKPACK.getKey().getDisplayName().getString();
                List<Component> components = Arrays.asList(Component.translatable((String)"screen.travelersbackpack.open_inventory", (Object[])new Object[]{button}), Component.translatable((String)"screen.travelersbackpack.hide_icon"));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, components, Optional.empty(), event.getMouseX(), event.getMouseY());
            }
        }
    }

    @SubscribeEvent
    public static void hideBackpackIcon(ScreenEvent.MouseButtonPressed.Post event) {
        Screen screen;
        if (!((Boolean)TravelersBackpackConfig.CLIENT.showBackpackIconInInventory.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (AttachmentUtils.isWearingBackpack((Player)player) && (screen = Minecraft.getInstance().screen) instanceof InventoryScreen) {
            InventoryScreen screen2 = (InventoryScreen)screen;
            if (TravelersBackpack.enableIntegration()) {
                return;
            }
            if (event.getMouseX() >= (double)(screen2.getGuiLeft() + 77) && event.getMouseX() < (double)(screen2.getGuiLeft() + 77 + 16) && event.getMouseY() >= (double)(screen2.getGuiTop() + 61 - 18) && event.getMouseY() < (double)(screen2.getGuiTop() + 61 - 18 + 16) && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340) && event.getButton() == 0) {
                player.sendSystemMessage((Component)Component.translatable((String)"screen.travelersbackpack.hidden_icon_info"));
                TravelersBackpackConfig.CLIENT.showBackpackIconInInventory.set((Object)false);
                TravelersBackpackConfig.CLIENT.showBackpackIconInInventory.save();
            }
        }
    }

    @SubscribeEvent
    public static void clientTickEvent(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && AttachmentUtils.isWearingBackpack((Player)player)) {
            while (ModClientEventHandler.OPEN_BACKPACK.consumeClick()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSpecialActionPacket(0, 4, 0.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            while (ModClientEventHandler.ABILITY.consumeClick()) {
                if (!BackpackAbilities.ALLOWED_ABILITIES.contains(AttachmentUtils.getWearingBackpack((Player)player).getItem())) continue;
                boolean ability = AttachmentUtils.getBackpackInv((Player)player).getAbilityValue();
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundAbilitySliderPacket(2, !ability), (CustomPacketPayload[])new CustomPacketPayload[0]);
                player.displayClientMessage((Component)Component.translatable((String)(ability ? "screen.travelersbackpack.ability_disabled" : "screen.travelersbackpack.ability_enabled")), true);
            }
            if (player.getMainHandItem().getItem() instanceof HoseItem && player.getMainHandItem().has(ModDataComponents.HOSE_MODES)) {
                while (ModClientEventHandler.TOGGLE_TANK.consumeClick()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSpecialActionPacket(2, 2, 0.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (((Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get()).booleanValue()) {
                ItemStack heldItem = player.getMainHandItem();
                while (ModClientEventHandler.SWAP_TOOL.consumeClick()) {
                    if (heldItem.isEmpty()) continue;
                    if (((Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get()).booleanValue() && ToolSlotItemHandler.isValid(heldItem)) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSpecialActionPacket(2, 0, 1.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    if (!(heldItem.getItem() instanceof HoseItem) || !heldItem.has(ModDataComponents.HOSE_MODES)) continue;
                    PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSpecialActionPacket(2, 1, 1.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void mouseWheelDetect(InputEvent.MouseScrollingEvent event) {
        ItemStack backpack;
        LocalPlayer player;
        Minecraft mc = Minecraft.getInstance();
        double scrollDelta = event.getScrollDeltaY();
        if (!((Boolean)TravelersBackpackConfig.CLIENT.disableScrollWheel.get()).booleanValue() && scrollDelta != 0.0 && (player = mc.player) != null && player.isAlive() && ModClientEventHandler.SWAP_TOOL.isDown() && (backpack = AttachmentUtils.getWearingBackpack((Player)player)) != null && backpack.getItem() instanceof TravelersBackpackItem && !player.getMainHandItem().isEmpty()) {
            ItemStack heldItem = player.getMainHandItem();
            if (((Boolean)TravelersBackpackConfig.CLIENT.enableToolCycling.get()).booleanValue() && ToolSlotItemHandler.isValid(heldItem)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSpecialActionPacket(2, 0, scrollDelta), (CustomPacketPayload[])new CustomPacketPayload[0]);
                event.setCanceled(true);
            }
            if (heldItem.getItem() instanceof HoseItem && heldItem.has(ModDataComponents.HOSE_MODES)) {
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSpecialActionPacket(2, 1, scrollDelta), (CustomPacketPayload[])new CustomPacketPayload[0]);
                event.setCanceled(true);
            }
        }
    }
}

