/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.datagen.ModLootTableProvider;
import com.tiviacz.travelersbackpack.datagen.ModRecipeProvider;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;

@EventBusSubscriber(modid="travelersbackpack", bus=EventBusSubscriber.Bus.MOD)
public class ModEventHandler {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        boolean includeServer = event.includeServer();
        generator.addProvider(includeServer, (DataProvider)new ModRecipeProvider(output, event.getLookupProvider()));
        generator.addProvider(includeServer, (DataProvider)ModLootTableProvider.create(output, event.getLookupProvider()));
    }

    @SubscribeEvent
    public static void registerPayloadHandler(RegisterPayloadHandlersEvent event) {
        ModNetwork.register(event.registrar("travelersbackpack"));
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.TRAVELERS_BACKPACK.get(), (blockEntity, side) -> blockEntity.getHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)ModBlockEntityTypes.TRAVELERS_BACKPACK.get(), (blockEntity, side) -> {
            Direction direction = blockEntity.getBlockDirection((BlockEntity)blockEntity);
            if (side == null) {
                return blockEntity.getLeftTank();
            }
            if (direction == Direction.NORTH) {
                switch (side) {
                    case WEST: {
                        return blockEntity.getRightTank();
                    }
                    case EAST: {
                        return blockEntity.getLeftTank();
                    }
                }
            }
            if (direction == Direction.SOUTH) {
                switch (side) {
                    case EAST: {
                        return blockEntity.getRightTank();
                    }
                    case WEST: {
                        return blockEntity.getLeftTank();
                    }
                }
            }
            if (direction == Direction.EAST) {
                switch (side) {
                    case NORTH: {
                        return blockEntity.getRightTank();
                    }
                    case SOUTH: {
                        return blockEntity.getLeftTank();
                    }
                }
            }
            if (direction == Direction.WEST) {
                switch (side) {
                    case SOUTH: {
                        return blockEntity.getRightTank();
                    }
                    case NORTH: {
                        return blockEntity.getLeftTank();
                    }
                }
            }
            return blockEntity.getLeftTank();
        });
    }

    @SubscribeEvent
    public static void onModConfigLoad(ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getSpec() == TravelersBackpackConfig.serverSpec) {
            TravelersBackpackConfig.SERVER.initializeLists();
        }
    }

    @SubscribeEvent
    public static void onModConfigReload(ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getSpec() == TravelersBackpackConfig.serverSpec) {
            TravelersBackpackConfig.SERVER.initializeLists();
        }
    }
}

