/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.menu.slot.BackpackSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class TravelersBackpackConfig {
    public static final ModConfigSpec serverSpec;
    public static final Server SERVER;
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Server {
        private static final String REGISTRY_NAME_MATCHER = "([a-z0-9_.-]+:[a-z0-9_/.-]+)";
        public final BackpackSettings backpackSettings;
        public final World world;
        public final BackpackAbilities backpackAbilities;
        public final SlownessDebuff slownessDebuff;
        private boolean initialized = false;

        Server(ModConfigSpec.Builder builder) {
            builder.comment("Server config settings").push("server");
            this.backpackSettings = new BackpackSettings(builder, "backpackSettings");
            this.world = new World(builder, "world");
            this.backpackAbilities = new BackpackAbilities(builder, "backpackAbilities");
            this.slownessDebuff = new SlownessDebuff(builder, "slownessDebuff");
            builder.pop();
        }

        public void loadItemsFromConfig(List<? extends String> configList, List<Item> targetList) {
            for (String string : configList) {
                ResourceLocation res = ResourceLocation.tryParse((String)string);
                if (!BuiltInRegistries.ITEM.containsKey(res)) continue;
                targetList.add((Item)BuiltInRegistries.ITEM.get(res));
            }
        }

        public void loadEntityTypesFromConfig(List<? extends String> configList, List<EntityType> targetList) {
            for (String string : configList) {
                ResourceLocation res = ResourceLocation.tryParse((String)string);
                if (!BuiltInRegistries.ENTITY_TYPE.containsKey(res)) continue;
                targetList.add((EntityType)BuiltInRegistries.ENTITY_TYPE.get(res));
            }
        }

        public void initializeLists() {
            if (!serverSpec.isLoaded()) {
                return;
            }
            if (!this.initialized) {
                this.loadItemsFromConfig((List)TravelersBackpackConfig.SERVER.backpackSettings.toolSlotsAcceptableItems.get(), ToolSlotItemHandler.TOOL_SLOTS_ACCEPTABLE_ITEMS);
                this.loadItemsFromConfig((List)TravelersBackpackConfig.SERVER.backpackSettings.blacklistedItems.get(), BackpackSlotItemHandler.BLACKLISTED_ITEMS);
                this.loadItemsFromConfig((List)TravelersBackpackConfig.SERVER.world.overworldBackpacks.get(), ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES);
                this.loadItemsFromConfig((List)TravelersBackpackConfig.SERVER.world.netherBackpacks.get(), ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES);
                this.loadItemsFromConfig((List)TravelersBackpackConfig.SERVER.backpackAbilities.allowedAbilities.get(), com.tiviacz.travelersbackpack.common.BackpackAbilities.ALLOWED_ABILITIES);
                this.loadEntityTypesFromConfig((List)TravelersBackpackConfig.SERVER.world.possibleOverworldEntityTypes.get(), Reference.ALLOWED_TYPE_ENTRIES);
                this.loadEntityTypesFromConfig((List)TravelersBackpackConfig.SERVER.world.possibleNetherEntityTypes.get(), Reference.ALLOWED_TYPE_ENTRIES);
            }
            this.initialized = true;
        }

        public static class BackpackSettings {
            public final TierConfig leather;
            public final TierConfig iron;
            public final TierConfig gold;
            public final TierConfig diamond;
            public final TierConfig netherite;
            public final ModConfigSpec.BooleanValue enableTierUpgrades;
            public final CraftingUpgradeConfig craftingUpgrade;
            public final ModConfigSpec.BooleanValue rightClickEquip;
            public final ModConfigSpec.BooleanValue rightClickUnequip;
            public final ModConfigSpec.BooleanValue allowOnlyEquippedBackpack;
            public final ModConfigSpec.BooleanValue invulnerableBackpack;
            public final ModConfigSpec.BooleanValue toolSlotsAcceptEverything;
            public final ModConfigSpec.ConfigValue<List<? extends String>> toolSlotsAcceptableItems;
            public final ModConfigSpec.ConfigValue<List<? extends String>> blacklistedItems;
            public final ModConfigSpec.BooleanValue allowShulkerBoxes;
            public final ModConfigSpec.BooleanValue voidProtection;
            public final ModConfigSpec.BooleanValue backpackDeathPlace;
            public final ModConfigSpec.BooleanValue backpackForceDeathPlace;
            public final ModConfigSpec.BooleanValue enableSleepingBagSpawnPoint;
            public final ModConfigSpec.BooleanValue curiosIntegration;
            public final ModConfigSpec.BooleanValue accessoriesIntegration;

            BackpackSettings(ModConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.leather = new TierConfig(builder, "Leather", 27, 2, 3000);
                this.iron = new TierConfig(builder, "Iron", 36, 3, 4000);
                this.gold = new TierConfig(builder, "Gold", 45, 4, 5000);
                this.diamond = new TierConfig(builder, "Diamond", 54, 5, 6000);
                this.netherite = new TierConfig(builder, "Netherite", 63, 6, 7000);
                this.enableTierUpgrades = builder.define("enableTierUpgrades", true);
                this.craftingUpgrade = new CraftingUpgradeConfig(builder, "craftingUpgrade");
                this.rightClickEquip = builder.comment("Enables equipping the backpack on right-click from the ground").define("rightClickEquip", true);
                this.rightClickUnequip = builder.comment("Enables unequipping the backpack on right-click on the ground with empty hand").define("rightClickUnequip", false);
                this.allowOnlyEquippedBackpack = builder.comment("Allows to use only equipped backpack").define("allowOnlyEquippedBackpack", false);
                this.invulnerableBackpack = builder.comment("Backpack immune to any damage source (lava, fire), can't be destroyed, never disappears as floating item").define("invulnerableBackpack", true);
                this.toolSlotsAcceptEverything = builder.comment("Tool slots accept any item").define("toolSlotsAcceptEverything", false);
                this.toolSlotsAcceptableItems = builder.comment("List of items that can be put in tool slots (Use registry names, for example: \"minecraft:apple\", \"minecraft:flint\")").defineList("toolSlotsAcceptableItems", Collections.emptyList(), () -> "", mapping -> ((String)mapping).matches(Server.REGISTRY_NAME_MATCHER));
                this.blacklistedItems = builder.comment("List of items that can't be put in backpack inventory (Use registry names, for example: \"minecraft:apple\", \"minecraft:flint\")").defineList("blacklistedItems", Collections.emptyList(), () -> "", mapping -> ((String)mapping).matches(Server.REGISTRY_NAME_MATCHER));
                this.allowShulkerBoxes = builder.comment("Allows putting shulker boxes and other items with inventory in backpack").define("allowShulkerBoxes", false);
                this.voidProtection = builder.comment("Prevents backpack disappearing in void, spawns floating backpack above minimum Y when player dies in void").define("voidProtection", true);
                this.backpackDeathPlace = builder.comment("Places backpack at place where player died").define("backpackDeathPlace", true);
                this.backpackForceDeathPlace = builder.comment("Places backpack at place where player died, replacing all blocks that are breakable and do not have inventory (backpackDeathPlace must be true in order to work)").define("backpackForceDeathPlace", false);
                this.enableSleepingBagSpawnPoint = builder.define("enableSleepingBagSpawnPoint", false);
                this.accessoriesIntegration = builder.comment(new String[]{"If true, backpack can only be worn by placing it in Accessories 'Back' slot", "WARNING - Remember to TAKE OFF BACKPACK BEFORE enabling or disabling this integration!! - if not you'll lose your backpack"}).define("accessoriesIntegration", true);
                this.curiosIntegration = builder.comment(new String[]{"If true, backpack can only be worn by placing it in Curios 'Back' slot", "WARNING - Remember to TAKE OFF BACKPACK BEFORE enabling or disabling this integration!! - if not you'll lose your backpack"}).define("curiosIntegration", true);
                builder.pop();
            }

            public static class TierConfig {
                public final ModConfigSpec.IntValue inventorySlotCount;
                public final ModConfigSpec.IntValue toolSlotCount;
                public final ModConfigSpec.IntValue tankCapacity;

                public TierConfig(ModConfigSpec.Builder builder, String tier, int inventorySlotCountDefault, int toolSlotCountDefault, int tankCapacityDefault) {
                    builder.comment(tier + " Tier Backpack Settings").push(tier.toLowerCase(Locale.ENGLISH) + "TierBackpack");
                    this.inventorySlotCount = builder.comment("Number of inventory slots for the tier").defineInRange("inventorySlotCount", inventorySlotCountDefault, 1, 63);
                    this.toolSlotCount = builder.comment("Number of tool slots for the tier").defineInRange("toolSlotCount", toolSlotCountDefault, 0, 6);
                    this.tankCapacity = builder.comment("Tank capacity for the tier, 1000 equals 1 Bucket").defineInRange("tankCapacity", tankCapacityDefault, 1, 128000);
                    builder.pop();
                }
            }

            public static class CraftingUpgradeConfig {
                public final ModConfigSpec.BooleanValue enableUpgrade;
                public final ModConfigSpec.BooleanValue includeByDefault;
                public final ModConfigSpec.BooleanValue savesItems;

                public CraftingUpgradeConfig(ModConfigSpec.Builder builder, String path) {
                    builder.comment("Crafting Upgrade Settings").push(path);
                    this.enableUpgrade = builder.define("enableUpgrade", true);
                    this.includeByDefault = builder.comment("Newly crafted backpacks will have crafting upgrade included by default").define("includeByDefault", false);
                    this.savesItems = builder.comment("Whether crafting grid should save items").define("savesItems", true);
                    builder.pop();
                }
            }

            public record Tier(int inventorySlotCount, int toolSlotCount, int tankCapacity) {
            }
        }

        public static class World {
            public final ModConfigSpec.BooleanValue spawnEntitiesWithBackpack;
            public final ModConfigSpec.DoubleValue chance;
            public final ModConfigSpec.ConfigValue<List<? extends String>> possibleOverworldEntityTypes;
            public final ModConfigSpec.ConfigValue<List<? extends String>> possibleNetherEntityTypes;
            public final ModConfigSpec.ConfigValue<List<? extends String>> overworldBackpacks;
            public final ModConfigSpec.ConfigValue<List<? extends String>> netherBackpacks;

            World(ModConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.spawnEntitiesWithBackpack = builder.comment("Enables chance to spawn Zombie, Skeleton, Wither Skeleton, Piglin or Enderman with random backpack equipped").define("spawnEntitiesWithBackpack", true);
                this.chance = builder.comment("Defines spawn chance of entity with a backpack").defineInRange("chance", 0.005, 0.0, 1.0);
                this.possibleOverworldEntityTypes = builder.comment("List of overworld entity types that can spawn with equipped backpack. DO NOT ADD anything to this list, because the game will crash, remove entries if mob should not spawn with backpack").defineList("possibleOverworldEntityTypes", this::getPossibleOverworldEntityTypes, () -> "", mapping -> ((String)mapping).matches(Server.REGISTRY_NAME_MATCHER));
                this.possibleNetherEntityTypes = builder.comment("List of nether entity types that can spawn with equipped backpack. DO NOT ADD anything to this list, because the game will crash, remove entries if mob should not spawn with backpack").defineList("possibleNetherEntityTypes", this::getPossibleNetherEntityTypes, () -> "", mapping -> ((String)mapping).matches(Server.REGISTRY_NAME_MATCHER));
                this.overworldBackpacks = builder.comment("List of backpacks that can spawn on overworld mobs").defineList("overworldBackpacks", this::getOverworldBackpacksList, () -> "", mapping -> ((String)mapping).matches(Server.REGISTRY_NAME_MATCHER));
                this.netherBackpacks = builder.comment("List of backpacks that can spawn on nether mobs").defineList("netherBackpacks", this::getNetherBackpacksList, () -> "", mapping -> ((String)mapping).matches(Server.REGISTRY_NAME_MATCHER));
                builder.pop();
            }

            private List<String> getPossibleOverworldEntityTypes() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("minecraft:zombie");
                ret.add("minecraft:skeleton");
                ret.add("minecraft:enderman");
                return ret;
            }

            private List<String> getPossibleNetherEntityTypes() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("minecraft:wither_skeleton");
                ret.add("minecraft:piglin");
                return ret;
            }

            private List<String> getOverworldBackpacksList() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("travelersbackpack:standard");
                ret.add("travelersbackpack:diamond");
                ret.add("travelersbackpack:gold");
                ret.add("travelersbackpack:emerald");
                ret.add("travelersbackpack:iron");
                ret.add("travelersbackpack:lapis");
                ret.add("travelersbackpack:redstone");
                ret.add("travelersbackpack:coal");
                ret.add("travelersbackpack:bookshelf");
                ret.add("travelersbackpack:sandstone");
                ret.add("travelersbackpack:snow");
                ret.add("travelersbackpack:sponge");
                ret.add("travelersbackpack:cake");
                ret.add("travelersbackpack:cactus");
                ret.add("travelersbackpack:hay");
                ret.add("travelersbackpack:melon");
                ret.add("travelersbackpack:pumpkin");
                ret.add("travelersbackpack:creeper");
                ret.add("travelersbackpack:enderman");
                ret.add("travelersbackpack:skeleton");
                ret.add("travelersbackpack:spider");
                ret.add("travelersbackpack:bee");
                ret.add("travelersbackpack:wolf");
                ret.add("travelersbackpack:fox");
                ret.add("travelersbackpack:ocelot");
                ret.add("travelersbackpack:horse");
                ret.add("travelersbackpack:cow");
                ret.add("travelersbackpack:pig");
                ret.add("travelersbackpack:sheep");
                ret.add("travelersbackpack:chicken");
                ret.add("travelersbackpack:squid");
                return ret;
            }

            private List<String> getNetherBackpacksList() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("travelersbackpack:quartz");
                ret.add("travelersbackpack:nether");
                ret.add("travelersbackpack:blaze");
                ret.add("travelersbackpack:ghast");
                ret.add("travelersbackpack:magma_cube");
                ret.add("travelersbackpack:wither");
                return ret;
            }
        }

        public static class BackpackAbilities {
            public final ModConfigSpec.BooleanValue enableBackpackAbilities;
            public final ModConfigSpec.BooleanValue forceAbilityEnabled;
            public final ModConfigSpec.ConfigValue<List<? extends String>> allowedAbilities;

            BackpackAbilities(ModConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.enableBackpackAbilities = builder.define("enableBackpackAbilities", true);
                this.forceAbilityEnabled = builder.comment("Newly crafted backpacks will have ability enabled by default").define("forceAbilityEnabled", true);
                this.allowedAbilities = builder.comment("List of backpacks that are allowed to have an ability. DO NOT ADD anything to this list, because the game will crash, remove entries if backpack should not have ability").defineList("allowedAbilities", this::getAllowedAbilities, () -> "", mapping -> ((String)mapping).matches(Server.REGISTRY_NAME_MATCHER));
                builder.pop();
            }

            private List<String> getAllowedAbilities() {
                ArrayList<String> ret = new ArrayList<String>();
                ret.add("travelersbackpack:netherite");
                ret.add("travelersbackpack:diamond");
                ret.add("travelersbackpack:gold");
                ret.add("travelersbackpack:emerald");
                ret.add("travelersbackpack:iron");
                ret.add("travelersbackpack:lapis");
                ret.add("travelersbackpack:redstone");
                ret.add("travelersbackpack:bookshelf");
                ret.add("travelersbackpack:sponge");
                ret.add("travelersbackpack:cake");
                ret.add("travelersbackpack:cactus");
                ret.add("travelersbackpack:melon");
                ret.add("travelersbackpack:pumpkin");
                ret.add("travelersbackpack:creeper");
                ret.add("travelersbackpack:dragon");
                ret.add("travelersbackpack:enderman");
                ret.add("travelersbackpack:blaze");
                ret.add("travelersbackpack:ghast");
                ret.add("travelersbackpack:magma_cube");
                ret.add("travelersbackpack:spider");
                ret.add("travelersbackpack:wither");
                ret.add("travelersbackpack:bat");
                ret.add("travelersbackpack:bee");
                ret.add("travelersbackpack:ocelot");
                ret.add("travelersbackpack:cow");
                ret.add("travelersbackpack:chicken");
                ret.add("travelersbackpack:squid");
                return ret;
            }
        }

        public static class SlownessDebuff {
            public final ModConfigSpec.BooleanValue tooManyBackpacksSlowness;
            public final ModConfigSpec.IntValue maxNumberOfBackpacks;
            public final ModConfigSpec.DoubleValue slownessPerExcessedBackpack;

            SlownessDebuff(ModConfigSpec.Builder builder, String path) {
                builder.push(path);
                this.tooManyBackpacksSlowness = builder.comment("Player gets slowness effect, if carries too many backpacks in inventory").define("tooManyBackpacksSlowness", false);
                this.maxNumberOfBackpacks = builder.comment("Maximum number of backpacks, which can be carried in inventory, without slowness effect").defineInRange("maxNumberOfBackpacks", 3, 1, 37);
                this.slownessPerExcessedBackpack = builder.defineInRange("slownessPerExcessedBackpack", 1.0, 0.1, 5.0);
                builder.pop();
            }
        }
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue enableLoot;
        public final ModConfigSpec.BooleanValue enableVillagerTrade;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("Common config settings").push("common");
            this.enableLoot = builder.comment("Enables backpacks spawning in loot chests").define("enableLoot", true);
            this.enableVillagerTrade = builder.comment("Enables trade for Villager Backpack in Librarian villager trades").define("enableVillagerTrade", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue showBackpackIconInInventory;
        public final ModConfigSpec.BooleanValue sendBackpackCoordinatesMessage;
        public final ModConfigSpec.BooleanValue enableToolCycling;
        public final ModConfigSpec.BooleanValue disableScrollWheel;
        public final ModConfigSpec.BooleanValue enableLegacyGui;
        public final ModConfigSpec.BooleanValue obtainTips;
        public final ModConfigSpec.BooleanValue renderTools;
        public final ModConfigSpec.BooleanValue renderBackpackWithElytra;
        public final ModConfigSpec.BooleanValue disableBackpackRender;
        public final Overlay overlay;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("Client-only settings").push("client");
            this.showBackpackIconInInventory = builder.comment("Whether the backpack icon should be visible in player's inventory").define("showBackpackIconInInventory", true);
            this.sendBackpackCoordinatesMessage = builder.comment("Sends a message to the player on death with backpack coordinates").define("sendBackpackCoordinatesMessage", true);
            this.enableToolCycling = builder.comment("Enables tool cycling via keybind (Default Z) + scroll combination, while backpack is worn").define("enableToolCycling", true);
            this.disableScrollWheel = builder.comment("Allows tool cycling using keybinding only (Default Z)").define("disableScrollWheel", false);
            this.enableLegacyGui = builder.comment("Enables legacy GUI (Blue slots for storage, brown for crafting and green for tools)").define("enableLegacyGui", false);
            this.obtainTips = builder.comment("Enables tip, how to obtain a backpack, if there's no crafting recipe for it").define("obtainTips", true);
            this.renderTools = builder.comment("Render tools in tool slots on the backpack, while worn").define("renderTools", true);
            this.renderBackpackWithElytra = builder.comment("Render backpack if elytra is present").define("renderBackpackWithElytra", true);
            this.disableBackpackRender = builder.comment("Disable backpack rendering").define("disableBackpackRender", false);
            this.overlay = new Overlay(builder, "The position of the Overlay on the screen", "overlay", true, 20, 30);
            builder.pop();
        }

        public static class Overlay {
            public final ModConfigSpec.BooleanValue enableOverlay;
            public final ModConfigSpec.IntValue offsetX;
            public final ModConfigSpec.IntValue offsetY;

            Overlay(ModConfigSpec.Builder builder, String comment, String path, boolean defaultOverlay, int defaultX, int defaultY) {
                builder.comment(comment).push(path);
                this.enableOverlay = builder.comment("Enables tanks and tool slots overlay, while backpack is worn").define("enableOverlay", defaultOverlay);
                this.offsetX = builder.comment("Offsets to left side").defineInRange("offsetX", defaultX, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.offsetY = builder.comment("Offsets to up").defineInRange("offsetY", defaultY, Integer.MIN_VALUE, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }
}

