/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.jei;

import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.compat.jei.BlockEntityTransferHandler;
import com.tiviacz.travelersbackpack.compat.jei.BlockEntityTransferInfo;
import com.tiviacz.travelersbackpack.compat.jei.ItemTransferHandler;
import com.tiviacz.travelersbackpack.compat.jei.ItemTransferInfo;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.common.Internal;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;

@JeiPlugin
public class TravelersBackpackPlugin
implements IModPlugin {
    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new ItemTransferHandler(Internal.getServerConnection(), registration.getJeiHelpers().getStackHelper(), registration.getTransferHelper(), new ItemTransferInfo()), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlockEntityTransferHandler(Internal.getServerConnection(), registration.getJeiHelpers().getStackHelper(), registration.getTransferHelper(), new BlockEntityTransferInfo()), RecipeTypes.CRAFTING);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(TravelersBackpackScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<TravelersBackpackScreen>(this){

            public List<Rect2i> getGuiExtraAreas(TravelersBackpackScreen gui) {
                ArrayList<Rect2i> ret = new ArrayList<Rect2i>();
                int[] s = gui.settingsWidget.getWidgetSizeAndPos();
                ret.add(new Rect2i(s[0], s[1], s[2], s[3]));
                int[] sort = gui.sortWidget.getWidgetSizeAndPos();
                if (gui.sortWidget.isVisible()) {
                    ret.add(new Rect2i(sort[0], sort[1], sort[2], sort[3]));
                }
                int[] memory = gui.memoryWidget.getWidgetSizeAndPos();
                if (gui.memoryWidget.isVisible()) {
                    ret.add(new Rect2i(memory[0], memory[1], memory[2], memory[3]));
                }
                int[] crafting = gui.craftingWidget.getWidgetSizeAndPos();
                if (gui.craftingWidget.isVisible()) {
                    ret.add(new Rect2i(crafting[0], crafting[1], crafting[2], crafting[3]));
                }
                return ret;
            }
        });
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"travelersbackpack");
    }
}

