/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.emi;

import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import com.tiviacz.travelersbackpack.network.ServerboundSettingsPacket;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.widget.Bounds;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.PacketDistributor;

@EmiEntrypoint
public class EmiCompat
implements EmiPlugin {
    public void register(EmiRegistry emiRegistry) {
        emiRegistry.addExclusionArea(TravelersBackpackScreen.class, (screen, consumer) -> {
            if (screen.settingsWidget != null) {
                int[] s = screen.settingsWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(s[0], s[1], s[2], s[3]));
            }
            if (screen.sortWidget != null && screen.sortWidget.isVisible()) {
                int[] sort = screen.sortWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(sort[0], sort[1], sort[2], sort[3]));
            }
            if (screen.memoryWidget != null && screen.memoryWidget.isVisible()) {
                int[] memory = screen.memoryWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(memory[0], memory[1], memory[2], memory[3]));
            }
            if (screen.craftingWidget != null && screen.craftingWidget.isVisible()) {
                int[] crafting = screen.craftingWidget.getWidgetSizeAndPos();
                consumer.accept(new Bounds(crafting[0], crafting[1], crafting[2], crafting[3]));
            }
        });
        emiRegistry.addRecipeHandler((MenuType)ModMenuTypes.TRAVELERS_BACKPACK_BLOCK_ENTITY.get(), new GridMenuInfo());
        emiRegistry.addRecipeHandler((MenuType)ModMenuTypes.TRAVELERS_BACKPACK_ITEM.get(), new GridMenuInfo());
    }

    private static class GridMenuInfo<T extends TravelersBackpackBaseMenu>
    implements StandardRecipeHandler<T> {
        private GridMenuInfo() {
        }

        @Nullable
        public Slot getOutputSlot(T handler) {
            return handler.getSlot(0);
        }

        public List<Slot> getInputSources(T handler) {
            int i;
            ArrayList<Slot> list = new ArrayList<Slot>();
            for (i = 1; i <= ((TravelersBackpackBaseMenu)((Object)handler)).container.getHandler().getSlots(); ++i) {
                list.add(handler.getSlot(i));
            }
            for (i = ((TravelersBackpackBaseMenu)((Object)handler)).container.getCombinedHandler().getSlots(); i < ((TravelersBackpackBaseMenu)((Object)handler)).container.getCombinedHandler().getSlots() + 36; ++i) {
                if (((TravelersBackpackBaseMenu)((Object)handler)).container.getScreenID() == 1 && handler.getSlot(i) instanceof DisabledSlot) continue;
                list.add(handler.getSlot(i));
            }
            return list;
        }

        public List<Slot> getCraftingSlots(T handler) {
            ArrayList<Slot> list = new ArrayList<Slot>();
            int firstCraftSlot = ((TravelersBackpackBaseMenu)((Object)handler)).container.getCombinedHandler().getSlots() - 8;
            for (int i = 0; i < 9; ++i) {
                list.add(handler.getSlot(firstCraftSlot + i));
            }
            return list;
        }

        public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
            ((TravelersBackpackBaseMenu)context.getScreenHandler()).container.getSettingsManager().set((byte)0, 1, (byte)1);
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSettingsPacket(((TravelersBackpackBaseMenu)context.getScreenHandler()).container.getScreenID(), 0, 1, 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return super.craft(recipe, context);
        }

        public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
            return super.canCraft(recipe, context) && ((TravelersBackpackBaseMenu)context.getScreenHandler()).container.getSettingsManager().hasCraftingGrid();
        }

        public boolean supportsRecipe(EmiRecipe recipe) {
            return VanillaEmiRecipeCategories.CRAFTING.equals(recipe.getCategory()) && recipe.supportsRecipeTree();
        }
    }
}

