/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.curios;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.client.model.TravelersBackpackWearableModel;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackBlockEntityRenderer;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.client.ICurioRenderer;
import top.theillusivec4.curios.api.type.capability.ICurio;

public record TravelersBackpackCurio(ItemStack stack) implements ICurio
{
    public static void registerCurio(RegisterCapabilitiesEvent event) {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> {
            ItemLike[] itemLikeArray = new ItemLike[1];
            itemLikeArray[0] = () -> ((DeferredHolder)holder).get();
            event.registerItem(CuriosCapability.ITEM, (stack, context) -> new TravelersBackpackCurio((ItemStack)stack), itemLikeArray);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerCurioRenderer() {
        ModItems.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof TravelersBackpackItem).forEach(holder -> CuriosRendererRegistry.register((Item)((Item)holder.get()), Renderer::new));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean canEquip(SlotContext context) {
        return (Boolean)TravelersBackpackConfig.SERVER.backpackSettings.curiosIntegration.get();
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.curiosIntegration.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.containerMenu instanceof TravelersBackpackItemMenu) {
                return;
            }
            if (!player.level().isClientSide) {
                AttachmentUtils.getAttachment(player).ifPresent(data -> {
                    data.setWearable(this.stack);
                    data.setContents(this.stack);
                    data.synchronise();
                    data.synchroniseToOthers(player);
                });
            }
        }
    }

    public void onEquipFromUse(SlotContext slotContext) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.curiosIntegration.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.level().isClientSide) {
                AttachmentUtils.getAttachment(player).ifPresent(data -> {
                    data.setWearable(this.stack);
                    data.setContents(this.stack);
                    data.synchronise();
                    data.synchroniseToOthers(player);
                });
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.curiosIntegration.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.containerMenu instanceof TravelersBackpackItemMenu) {
                return;
            }
            if (!player.level().isClientSide) {
                AttachmentUtils.getAttachment(player).ifPresent(data -> {
                    data.removeWearable();
                    data.synchronise();
                    data.synchroniseToOthers(player);
                });
            }
        }
    }

    public void curioTick(SlotContext slotContext) {
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.curiosIntegration.get()).booleanValue()) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.containerMenu instanceof TravelersBackpackItemMenu || !AttachmentUtils.isWearingBackpack(player)) {
                return;
            }
            TravelersBackpackContainer container = AttachmentUtils.getBackpackInv(player);
            if (!ItemStack.isSameItemSameComponents((ItemStack)container.getItemStack(), (ItemStack)this.getStack())) {
                this.getStack().applyComponents(container.getItemStack().getComponentsPatch());
            }
        }
    }

    @Nonnull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit) {
        return ICurio.DropRule.DEFAULT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer
    implements ICurioRenderer {
        public TravelersBackpackWearableModel model;

        public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            LivingEntity livingEntity = slotContext.entity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                livingEntity = renderLayerParent.getModel();
                if (livingEntity instanceof HumanoidModel) {
                    Item item;
                    boolean flag;
                    HumanoidModel humanoidModel = (HumanoidModel)livingEntity;
                    TravelersBackpackContainer container = AttachmentUtils.getBackpackInv(player);
                    if (container == null) {
                        return;
                    }
                    this.model = new TravelersBackpackWearableModel((LivingEntity)player, renderTypeBuffer, TravelersBackpackBlockEntityRenderer.createTravelersBackpack(true).bakeRoot());
                    boolean bl = flag = container.getItemStack().getItem() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || container.getItemStack().getItem() == ModItems.SNOW_TRAVELERS_BACKPACK.get();
                    if (container.getItemStack().isEmpty() || !((item = container.getItemStack().getItem()) instanceof TravelersBackpackItem)) {
                        return;
                    }
                    TravelersBackpackItem travelersBackpackItem = (TravelersBackpackItem)item;
                    ResourceLocation loc = travelersBackpackItem.getBackpackTexture();
                    boolean isColorable = false;
                    boolean isCustomSleepingBag = false;
                    if (container.getItemStack().has(DataComponents.DYED_COLOR) && container.getItemStack().getItem() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
                        isColorable = true;
                        loc = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/model/dyed.png");
                    }
                    if (container.getItemStack().has(ModDataComponents.SLEEPING_BAG_COLOR)) {
                        isCustomSleepingBag = true;
                    }
                    VertexConsumer vertexConsumer = renderTypeBuffer.getBuffer(flag ? RenderType.entityTranslucentCull((ResourceLocation)loc) : RenderType.entitySolid((ResourceLocation)loc));
                    matrixStack.pushPose();
                    if (player.isCrouching()) {
                        matrixStack.translate(0.0, -0.155, 0.025);
                    }
                    humanoidModel.copyPropertiesTo((HumanoidModel)this.model);
                    this.model.setupAngles(humanoidModel);
                    matrixStack.translate(0.0, 0.175, 0.325);
                    matrixStack.scale(0.85f, 0.85f, 0.85f);
                    if (isColorable) {
                        this.model.renderToBuffer(matrixStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.opaque((int)((DyedItemColor)container.getItemStack().get(DataComponents.DYED_COLOR)).rgb()));
                        loc = ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"textures/model/dyed_extras.png");
                        vertexConsumer = renderTypeBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
                    }
                    this.model.renderToBuffer(matrixStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
                    loc = isCustomSleepingBag ? ResourceUtils.getSleepingBagTexture(container.getSleepingBagColor()) : ResourceUtils.getDefaultSleepingBagTexture();
                    vertexConsumer = renderTypeBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)loc));
                    this.model.sleepingBag.render(matrixStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
                    matrixStack.popPose();
                }
            }
        }
    }
}

