/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.craftingtweaks;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.CraftingWidget;
import com.tiviacz.travelersbackpack.compat.craftingtweaks.ICraftingTweaks;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksClientAPI;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.util.ObfuscationReflectionHelper;

public class TravelersBackpackCraftingGridAddition
implements ICraftingTweaks {
    @OnlyIn(value=Dist.CLIENT)
    private TravelersBackpackScreen screen;
    private static final Method ADD_RENDERABLE_WIDGET = ObfuscationReflectionHelper.findMethod(Screen.class, (String)"addRenderableWidget", (Class[])new Class[]{GuiEventListener.class});
    private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();

    public static void registerCraftingTweaksAddition() {
        CraftingWidget.setCraftingTweaksAddition(new TravelersBackpackCraftingGridAddition());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addButton(AbstractWidget widget) {
        this.widgets.add(widget);
        try {
            ADD_RENDERABLE_WIDGET.invoke((Object)this.screen, widget);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            TravelersBackpack.LOGGER.error("Error calling addButton in Screen class", (Throwable)e);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onCraftingSlotsHidden() {
        if (this.widgets.isEmpty()) {
            return;
        }
        List screenChildren = (List)ObfuscationReflectionHelper.getPrivateValue(Screen.class, (Object)((Object)this.screen), (String)"children");
        List screenRenderables = (List)ObfuscationReflectionHelper.getPrivateValue(Screen.class, (Object)((Object)this.screen), (String)"renderables");
        if (screenChildren == null || screenRenderables == null) {
            return;
        }
        this.widgets.forEach(screenChildren::remove);
        this.widgets.forEach(screenRenderables::remove);
        this.widgets.clear();
    }

    @Override
    public void onCraftingSlotsDisplayed() {
        Slot thirdSlot = ((TravelersBackpackBaseMenu)this.screen.getMenu()).getSlot(this.screen.container.getCombinedHandler().getSlots() - 6);
        CraftingTweaksProviderManager.getDefaultCraftingGrid((AbstractContainerMenu)this.screen.getMenu()).ifPresent(craftingGrid -> {
            this.addButton(CraftingTweaksClientAPI.createTweakButtonRelative((CraftingGrid)craftingGrid, (AbstractContainerScreen)this.screen, (int)this.getButtonX(thirdSlot), (int)this.getButtonY(thirdSlot, 0), (TweakType)TweakType.Rotate));
            this.addButton(CraftingTweaksClientAPI.createTweakButtonRelative((CraftingGrid)craftingGrid, (AbstractContainerScreen)this.screen, (int)this.getButtonX(thirdSlot), (int)this.getButtonY(thirdSlot, 1), (TweakType)TweakType.Balance));
            this.addButton(CraftingTweaksClientAPI.createTweakButtonRelative((CraftingGrid)craftingGrid, (AbstractContainerScreen)this.screen, (int)this.getButtonX(thirdSlot), (int)this.getButtonY(thirdSlot, 2), (TweakType)TweakType.Clear));
        });
    }

    @Override
    public void setScreen(TravelersBackpackScreen screen) {
        this.screen = screen;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getButtonX(Slot thirdSlot) {
        return thirdSlot.x + 19;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int getButtonY(Slot thirdSlot, int index) {
        return thirdSlot.y + 18 * index;
    }
}

