/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class ShapelessBackpackRecipe
extends ShapelessRecipe {
    public ShapelessBackpackRecipe(String groupIn, CraftingBookCategory category, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(groupIn, category, recipeOutputIn, recipeItemsIn);
    }

    public ItemStack assemble(CraftingInput pInput, HolderLookup.Provider pRegistries) {
        ItemStack output = this.result.copy();
        if (!output.isEmpty()) {
            for (int i = 0; i < pInput.size(); ++i) {
                ItemStack ingredient = pInput.getItem(i);
                if (ingredient.isEmpty() || !(ingredient.getItem() instanceof TravelersBackpackItem)) continue;
                output.applyComponents(ingredient.getComponentsPatch());
                break;
            }
        }
        return output;
    }

    private ItemStack damageShears(ItemStack stack) {
        Player craftingPlayer = CommonHooks.getCraftingPlayer();
        if (craftingPlayer == null || craftingPlayer.level() == null || !(craftingPlayer instanceof ServerPlayer)) {
            if (stack.getDamageValue() + 1 <= stack.getMaxDamage()) {
                stack.setDamageValue(stack.getDamageValue() + 1);
                return stack;
            }
            return ItemStack.EMPTY;
        }
        ServerPlayer serverPlayer = (ServerPlayer)craftingPlayer;
        stack.hurtAndBreak(1, serverPlayer.serverLevel(), serverPlayer, item -> {
            EventHooks.onPlayerDestroyItem((Player)craftingPlayer, (ItemStack)stack, null);
            stack.setCount(0);
        });
        return stack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventoryCrafting) {
        NonNullList remainingItems = NonNullList.withSize((int)inventoryCrafting.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemstack = inventoryCrafting.getItem(i);
            if (!itemstack.isEmpty() && itemstack.getItem() instanceof ShearsItem) {
                remainingItems.set(i, (Object)this.damageShears(itemstack.copy()));
                continue;
            }
            remainingItems.set(i, (Object)CommonHooks.getCraftingRemainingItem((ItemStack)itemstack));
        }
        return remainingItems;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return RecipeType.CRAFTING;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessBackpackRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<ShapelessBackpackRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340779_ -> p_340779_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.getGroup()), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_301133_ -> p_301133_.category()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
            Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(p_300975_ -> p_300975_.getIngredients())).apply((Applicative)p_340779_, ShapelessBackpackRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessBackpackRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ShapelessBackpackRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapelessBackpackRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ShapelessBackpackRecipe fromNetwork(RegistryFriendlyByteBuf p_319905_) {
            String s = p_319905_.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)p_319905_.readEnum(CraftingBookCategory.class);
            int i = p_319905_.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)p_319905_));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_319905_);
            return new ShapelessBackpackRecipe(s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        private static void toNetwork(RegistryFriendlyByteBuf p_320371_, ShapelessBackpackRecipe p_320323_) {
            p_320371_.writeUtf(p_320323_.getGroup());
            p_320371_.writeEnum((Enum)p_320323_.category());
            p_320371_.writeVarInt(p_320323_.getIngredients().size());
            for (Ingredient ingredient : p_320323_.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)p_320371_, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)p_320371_, (Object)p_320323_.result);
        }
    }
}

