/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.components.FluidTanks;
import com.tiviacz.travelersbackpack.components.Settings;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BackpackUpgradeRecipe
extends SmithingTransformRecipe {
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;
    final ItemStack result;

    public BackpackUpgradeRecipe(Ingredient pTemplate, Ingredient pBase, Ingredient pAddition, ItemStack pResult) {
        super(pTemplate, pBase, pAddition, pResult);
        this.template = pTemplate;
        this.base = pBase;
        this.addition = pAddition;
        this.result = pResult;
    }

    public ItemStack assemble(SmithingRecipeInput pInput, HolderLookup.Provider pRegistries) {
        ItemStack result = pInput.getItem(1).transmuteCopy((ItemLike)this.result.getItem(), this.result.getCount());
        result.applyComponents(this.result.getComponentsPatch());
        ItemStack base = pInput.getItem(1);
        ItemStack addition = pInput.getItem(2);
        int tier = (Integer)base.getOrDefault(ModDataComponents.TIER, (Object)0);
        if (addition.is(Tiers.of(tier).getTierUpgradeIngredient())) {
            this.upgradeInventory(result, Tiers.of(tier).getNextTier());
            return result;
        }
        if (addition.is((Item)ModItems.CRAFTING_UPGRADE.get())) {
            if (base.has(ModDataComponents.SETTINGS)) {
                List oldSettings = (List)base.get(ModDataComponents.SETTINGS);
                List craftingSettings = (List)oldSettings.get(0);
                if ((Byte)craftingSettings.get(0) == 0) {
                    List<Byte> newCraftingSettings = Arrays.asList((byte)1, (Byte)craftingSettings.get(1), (Byte)craftingSettings.get(2));
                    List<List> newSettings = Arrays.asList(newCraftingSettings, (List)oldSettings.get(1));
                    result.set(ModDataComponents.SETTINGS, newSettings);
                    return result;
                }
            } else {
                List<Byte> newCraftingSettings = Arrays.asList((byte)1, (byte)0, (byte)1);
                List<List<Byte>> newSettings = Settings.createSettings(newCraftingSettings, Settings.createDefaultToolSettings());
                result.set(ModDataComponents.SETTINGS, newSettings);
                return result;
            }
        }
        return ItemStack.EMPTY;
    }

    public void upgradeInventory(ItemStack stack, Tiers.Tier nextTier) {
        stack.set(ModDataComponents.TIER, (Object)nextTier.getOrdinal());
        NonNullList<ItemStack> oldContents = ((BackpackContainerContents)stack.getOrDefault(ModDataComponents.BACKPACK_CONTAINER, (Object)BackpackContainerContents.fromItems(nextTier.getStorageSlots(), (List<ItemStack>)NonNullList.withSize((int)nextTier.getStorageSlots(), (Object)ItemStack.EMPTY)))).getItems();
        BackpackContainerContents newContents = BackpackContainerContents.upgradeContents(nextTier.getStorageSlots(), oldContents);
        stack.set(ModDataComponents.BACKPACK_CONTAINER, (Object)newContents);
        NonNullList<ItemStack> oldTools = ((BackpackContainerContents)stack.getOrDefault(ModDataComponents.TOOLS_CONTAINER, (Object)BackpackContainerContents.fromItems(nextTier.getToolSlots(), (List<ItemStack>)NonNullList.withSize((int)nextTier.getToolSlots(), (Object)ItemStack.EMPTY)))).getItems();
        BackpackContainerContents newTools = BackpackContainerContents.upgradeContents(nextTier.getToolSlots(), oldTools);
        stack.set(ModDataComponents.TOOLS_CONTAINER, (Object)newTools);
        FluidTanks oldTanks = (FluidTanks)stack.getOrDefault(ModDataComponents.FLUID_TANKS, (Object)FluidTanks.createTanks(nextTier.getTankCapacity()));
        FluidTanks newTanks = new FluidTanks(nextTier.getTankCapacity(), oldTanks.leftFluidStack(), oldTanks.rightFluidStack());
        stack.set(ModDataComponents.FLUID_TANKS, (Object)newTanks);
    }

    public boolean matches(SmithingRecipeInput pInput, Level level) {
        ItemStack addition = pInput.getItem(2);
        boolean flag = true;
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.craftingUpgrade.enableUpgrade.get()).booleanValue()) {
            boolean bl = flag = !addition.is((Item)ModItems.CRAFTING_UPGRADE.get());
        }
        if (!((Boolean)TravelersBackpackConfig.SERVER.backpackSettings.enableTierUpgrades.get()).booleanValue()) {
            flag = !addition.is((Item)ModItems.IRON_TIER_UPGRADE.get()) && !addition.is((Item)ModItems.GOLD_TIER_UPGRADE.get()) && !addition.is((Item)ModItems.DIAMOND_TIER_UPGRADE.get()) && !addition.is((Item)ModItems.NETHERITE_TIER_UPGRADE.get());
        }
        return flag && super.matches(pInput, level);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.BACKPACK_UPGRADE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BackpackUpgradeRecipe> {
        private static final MapCodec<BackpackUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340782_ -> p_340782_.group((App)Ingredient.CODEC.fieldOf("template").forGetter(p_301310_ -> p_301310_.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(p_300938_ -> p_300938_.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter(p_301153_ -> p_301153_.addition), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_300935_ -> p_300935_.result)).apply((Applicative)p_340782_, BackpackUpgradeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BackpackUpgradeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BackpackUpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BackpackUpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static BackpackUpgradeRecipe fromNetwork(RegistryFriendlyByteBuf p_320375_) {
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)p_320375_);
            Ingredient ingredient1 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)p_320375_);
            Ingredient ingredient2 = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)p_320375_);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)p_320375_);
            return new BackpackUpgradeRecipe(ingredient, ingredient1, ingredient2, itemstack);
        }

        private static void toNetwork(RegistryFriendlyByteBuf p_320743_, BackpackUpgradeRecipe p_319840_) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)p_320743_, (Object)p_319840_.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)p_320743_, (Object)p_319840_.base);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)p_320743_, (Object)p_319840_.addition);
            ItemStack.STREAM_CODEC.encode((Object)p_320743_, (Object)p_319840_.result);
        }
    }
}

