/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBlockEntityMenu;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.ContainerSorter;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.util.ContainerUtils;
import com.tiviacz.travelersbackpack.util.FluidUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ServerActions {
    public static void swapTool(Player player, double scrollDelta) {
        block10: {
            int i;
            ItemStack[] tools;
            int j;
            int firstSlot;
            ItemStack heldItem;
            ItemStackHandler inv;
            block11: {
                int i2;
                if (!AttachmentUtils.isWearingBackpack(player)) break block10;
                TravelersBackpackContainer inventory = AttachmentUtils.getBackpackInv(player);
                inv = inventory.getToolSlotsHandler();
                heldItem = player.getMainHandItem();
                int toolSlots = inv.getSlots();
                if (ContainerUtils.isEmpty(inv)) {
                    return;
                }
                firstSlot = 0;
                int lastSlot = firstSlot + (toolSlots - 1);
                j = 0;
                for (int i3 = firstSlot; i3 <= lastSlot; ++i3) {
                    if (inv.getStackInSlot(i3).isEmpty()) continue;
                    ++j;
                }
                tools = new ItemStack[j];
                if (!(scrollDelta < 0.0)) break block11;
                int slot = 0;
                for (int i4 = firstSlot; i4 <= firstSlot + j - 1; ++i4) {
                    tools[slot] = inv.getStackInSlot(i4).copy();
                    ++slot;
                }
                ItemStack tempStack = tools[tools.length - 1];
                for (i2 = tools.length - 1; i2 >= 0; --i2) {
                    if (i2 - 1 < 0) {
                        tools[0] = heldItem;
                        player.setItemInHand(InteractionHand.MAIN_HAND, tempStack);
                        continue;
                    }
                    tools[i2] = tools[i2 - 1];
                }
                slot = 0;
                for (i2 = firstSlot; i2 <= firstSlot + j - 1; ++i2) {
                    inv.setStackInSlot(i2, tools[slot]);
                    ++slot;
                }
                break block10;
            }
            if (!(scrollDelta > 0.0)) break block10;
            int slot = 0;
            for (int i5 = firstSlot; i5 <= firstSlot + j - 1; ++i5) {
                tools[slot] = inv.getStackInSlot(i5).copy();
                ++slot;
            }
            ItemStack tempStack = tools[0];
            for (i = 0; i <= tools.length - 1; ++i) {
                if (i + 1 > tools.length - 1) {
                    tools[tools.length - 1] = heldItem;
                    player.setItemInHand(InteractionHand.MAIN_HAND, tempStack);
                    continue;
                }
                tools[i] = tools[i + 1];
            }
            slot = 0;
            for (i = firstSlot; i <= firstSlot + j - 1; ++i) {
                inv.setStackInSlot(i, tools[slot]);
                ++slot;
            }
        }
    }

    public static void equipBackpack(Player player) {
        Optional<ITravelersBackpack> data = AttachmentUtils.getAttachment(player);
        Level level = player.level();
        if (!level.isClientSide) {
            if (!data.map(ITravelersBackpack::hasWearable).orElse(false).booleanValue()) {
                if (player.containerMenu instanceof TravelersBackpackItemMenu) {
                    player.containerMenu.removed(player);
                }
                ItemStack stack = player.getMainHandItem().copy();
                data.ifPresent(inv -> inv.setWearable(stack));
                data.ifPresent(inv -> inv.setContents(stack));
                player.getMainHandItem().shrink(1);
                level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, (1.0f + (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f) * 0.7f);
                AttachmentUtils.synchronise(player);
                AttachmentUtils.synchroniseToOthers(player);
            }
            player.closeContainer();
        }
    }

    public static void unequipBackpack(Player player) {
        Optional<ITravelersBackpack> data = AttachmentUtils.getAttachment(player);
        Level level = player.level();
        if (!level.isClientSide) {
            if (player.containerMenu instanceof TravelersBackpackItemMenu) {
                player.containerMenu.removed(player);
            }
            ItemStack wearable = data.map(ITravelersBackpack::getWearable).orElse(ItemStack.EMPTY).copy();
            if (!player.getInventory().add(wearable)) {
                player.sendSystemMessage((Component)Component.translatable((String)"action.travelersbackpack.unequip_nospace"));
                player.closeContainer();
                return;
            }
            if (data.map(ITravelersBackpack::hasWearable).orElse(false).booleanValue()) {
                data.ifPresent(ITravelersBackpack::removeWearable);
                level.playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.05f, (1.0f + (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f) * 0.7f);
                AttachmentUtils.synchronise(player);
                AttachmentUtils.synchroniseToOthers(player);
            }
            player.closeContainer();
        }
    }

    public static void switchAbilitySlider(Player player, boolean sliderValue) {
        TravelersBackpackContainer container = AttachmentUtils.getBackpackInv(player);
        container.setAbility(sliderValue);
        container.setDataChanged(7, 4);
        if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, container.getItemStack()) && !sliderValue) {
            BackpackAbilities.ABILITIES.abilityRemoval(container.getItemStack(), player);
        }
        if (container.getItemStack().getItem() == ModItems.CHICKEN_TRAVELERS_BACKPACK.get() && container.getLastTime() <= 0) {
            BackpackAbilities.ABILITIES.chickenAbility(player, true);
        }
    }

    public static void switchAbilitySliderBlockEntity(Player player, BlockPos pos, boolean sliderValue) {
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
            blockEntity2.setAbility(sliderValue);
            blockEntity2.setDataChanged();
            blockEntity2.getLevel().updateNeighborsAt(pos, blockEntity2.getBlockState().getBlock());
            if (blockEntity2.getBlockState().getBlock() == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
                ((TravelersBackpackBlock)blockEntity2.getBlockState().getBlock()).tryAbsorbWater(blockEntity2.getLevel(), pos);
            }
        }
    }

    public static void sortBackpack(Player player, byte screenID, byte button, boolean shiftPressed) {
        AbstractContainerMenu abstractContainerMenu;
        if (screenID == 3 && (abstractContainerMenu = player.containerMenu) instanceof TravelersBackpackBlockEntityMenu) {
            TravelersBackpackBlockEntityMenu menu = (TravelersBackpackBlockEntityMenu)abstractContainerMenu;
            if (player.level().getBlockEntity(menu.container.getPosition()) instanceof TravelersBackpackBlockEntity) {
                ContainerSorter.selectSort(menu.container, player, button, shiftPressed);
            }
        } else if (screenID == 1) {
            AbstractContainerMenu abstractContainerMenu2 = player.containerMenu;
            if (abstractContainerMenu2 instanceof TravelersBackpackItemMenu) {
                TravelersBackpackItemMenu menu = (TravelersBackpackItemMenu)abstractContainerMenu2;
                ContainerSorter.selectSort(menu.container, player, button, shiftPressed);
            }
        } else if (screenID == 2) {
            ContainerSorter.selectSort(AttachmentUtils.getBackpackInv(player), player, button, shiftPressed);
        }
    }

    public static void toggleSleepingBag(Player player, BlockPos pos) {
        Level level = player.level();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity blockEntity2 = (TravelersBackpackBlockEntity)blockEntity;
            if (!blockEntity2.isSleepingBagDeployed()) {
                if (blockEntity2.deploySleepingBag(level, pos)) {
                    player.closeContainer();
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"action.travelersbackpack.deploy_sleeping_bag"));
                }
            } else {
                blockEntity2.removeSleepingBag(level, blockEntity2.getBlockDirection(blockEntity2));
            }
            player.closeContainer();
        }
    }

    public static void emptyTank(double tankType, Player player, Level level, byte screenID) {
        FluidTank tank;
        ITravelersBackpackContainer container = null;
        if (screenID == 2) {
            container = AttachmentUtils.getBackpackInv(player);
        }
        if (screenID == 1) {
            container = ((TravelersBackpackItemMenu)player.containerMenu).container;
        }
        if (screenID == 3) {
            container = ((TravelersBackpackBlockEntityMenu)player.containerMenu).container;
        }
        if (container == null) {
            return;
        }
        FluidTank fluidTank = tank = tankType == 1.0 ? container.getLeftTank() : container.getRightTank();
        if (!level.isClientSide) {
            level.playSound(null, player.blockPosition(), FluidUtils.getFluidEmptySound(tank.getFluid().getFluid()), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        tank.setFluid(FluidStack.EMPTY);
        container.setDataChanged(4);
    }

    public static boolean setFluidEffect(Level level, Player player, FluidTank tank) {
        FluidStack fluidStack = tank.getFluid();
        boolean done = false;
        if (EffectFluidRegistry.hasExecutableEffects(fluidStack, level, (Entity)player)) {
            done = EffectFluidRegistry.executeEffects(fluidStack, (Entity)player, level);
        }
        return done;
    }

    public static void switchHoseMode(Player player, double scrollDelta) {
        ItemStack hose = player.getMainHandItem();
        if (hose.getItem() instanceof HoseItem) {
            List settings = (List)hose.getOrDefault(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if (scrollDelta > 0.0) {
                int nextMode = (Integer)settings.get(0) + 1;
                hose.set(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(nextMode == 4 ? 1 : nextMode), (Integer)settings.get(1)));
            } else if (scrollDelta < 0.0) {
                int nextMode = (Integer)settings.get(0) - 1;
                hose.set(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(nextMode == 0 ? 3 : nextMode), (Integer)settings.get(1)));
            }
        }
    }

    public static void toggleHoseTank(Player player) {
        ItemStack hose = player.getMainHandItem();
        if (hose.getItem() instanceof HoseItem) {
            List settings = (List)hose.getOrDefault(ModDataComponents.HOSE_MODES, List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if ((Integer)settings.get(1) == 1) {
                hose.set(ModDataComponents.HOSE_MODES, List.of((Integer)settings.get(0), Integer.valueOf(2)));
            } else {
                hose.set(ModDataComponents.HOSE_MODES, List.of((Integer)settings.get(0), Integer.valueOf(1)));
            }
        }
    }
}

