/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BackpackAbilities {
    public static final BackpackAbilities ABILITIES = new BackpackAbilities();
    public final AttributeModifier NETHERITE_ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"netherite_backpack_armor"), 4.0, AttributeModifier.Operation.ADD_VALUE);
    public final AttributeModifier DIAMOND_ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"diamond_backpack_armor"), 3.0, AttributeModifier.Operation.ADD_VALUE);
    public final AttributeModifier IRON_ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"iron_backpack_armor"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    public final AttributeModifier GOLD_ARMOR_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"gold_backpack_armor"), 2.0, AttributeModifier.Operation.ADD_VALUE);
    public final AttributeModifier ENDERMAN_REACH_DISTANCE_MODIFIER = new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"travelersbackpack", (String)"enderman_backpack_reach"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    private final TargetingConditions ocelotAbilityTargeting = TargetingConditions.forCombat().range(64.0);
    public static final List<Item> ALLOWED_ABILITIES = new ArrayList<Item>();
    public static final Item[] ALL_ABILITIES_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get(), (Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.MELON_TRAVELERS_BACKPACK.get(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.DRAGON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get(), (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get(), (Item)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPIDER_TRAVELERS_BACKPACK.get(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.BAT_TRAVELERS_BACKPACK.get(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get(), (Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.SQUID_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_ABILITIES_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get(), (Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.DRAGON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get(), (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get(), (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get(), (Item)ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPIDER_TRAVELERS_BACKPACK.get(), (Item)ModItems.WITHER_TRAVELERS_BACKPACK.get(), (Item)ModItems.BAT_TRAVELERS_BACKPACK.get(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get(), (Item)ModItems.OCELOT_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get(), (Item)ModItems.SQUID_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_ABILITIES_REMOVAL_LIST = new Item[]{(Item)ModItems.NETHERITE_TRAVELERS_BACKPACK.get(), (Item)ModItems.DIAMOND_TRAVELERS_BACKPACK.get(), (Item)ModItems.GOLD_TRAVELERS_BACKPACK.get(), (Item)ModItems.IRON_TRAVELERS_BACKPACK.get(), (Item)ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()};
    public static final Item[] ITEM_TIMER_ABILITIES_LIST = new Item[]{(Item)ModItems.CAKE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CREEPER_TRAVELERS_BACKPACK.get(), (Item)ModItems.COW_TRAVELERS_BACKPACK.get(), (Item)ModItems.CHICKEN_TRAVELERS_BACKPACK.get()};
    public static final Item[] BLOCK_TIMER_ABILITIES_LIST = new Item[]{(Item)ModItems.MELON_TRAVELERS_BACKPACK.get()};
    public static final Item[] BLOCK_ABILITIES_LIST = new Item[]{(Item)ModItems.EMERALD_TRAVELERS_BACKPACK.get(), (Item)ModItems.REDSTONE_TRAVELERS_BACKPACK.get(), (Item)ModItems.BOOKSHELF_TRAVELERS_BACKPACK.get(), (Item)ModItems.SPONGE_TRAVELERS_BACKPACK.get(), (Item)ModItems.CACTUS_TRAVELERS_BACKPACK.get(), (Item)ModItems.MELON_TRAVELERS_BACKPACK.get()};

    public void abilityTick(@Nullable ItemStack stack, @Nullable Player player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        if (blockEntity == null) {
            if (stack.getItem() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.ARMOR, this.NETHERITE_ARMOR_MODIFIER);
            }
            if (stack.getItem() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.ARMOR, this.DIAMOND_ARMOR_MODIFIER);
            }
            if (stack.getItem() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.ARMOR, this.GOLD_ARMOR_MODIFIER);
            }
            if (stack.getItem() == ModItems.EMERALD_TRAVELERS_BACKPACK.get()) {
                this.emeraldAbility(player, null);
            }
            if (stack.getItem() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.ARMOR, this.IRON_ARMOR_MODIFIER);
            }
            if (stack.getItem() == ModItems.CAKE_TRAVELERS_BACKPACK.get()) {
                this.cakeAbility(player);
            }
            if (stack.getItem() == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
                this.cactusAbility(player, null);
            }
            if (stack.getItem() == ModItems.DRAGON_TRAVELERS_BACKPACK.get()) {
                this.dragonAbility(player);
            }
            if (stack.getItem() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
                this.attributeAbility(player, false, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
            }
            if (stack.getItem() == ModItems.BLAZE_TRAVELERS_BACKPACK.get()) {
                this.blazeAbility(player);
            }
            if (stack.getItem() == ModItems.MAGMA_CUBE_TRAVELERS_BACKPACK.get()) {
                this.magmaCubeAbility(player);
            }
            if (stack.getItem() == ModItems.SPIDER_TRAVELERS_BACKPACK.get()) {
                this.spiderAbility(player);
            }
            if (stack.getItem() == ModItems.WITHER_TRAVELERS_BACKPACK.get()) {
                this.witherAbility(player);
            }
            if (stack.getItem() == ModItems.BAT_TRAVELERS_BACKPACK.get()) {
                this.batAbility(player);
            }
            if (stack.getItem() == ModItems.OCELOT_TRAVELERS_BACKPACK.get()) {
                this.ocelotAbility(player);
            }
            if (stack.getItem() == ModItems.COW_TRAVELERS_BACKPACK.get()) {
                this.cowAbility(player);
            }
            if (stack.getItem() == ModItems.CHICKEN_TRAVELERS_BACKPACK.get()) {
                this.chickenAbility(player, false);
            }
            if (stack.getItem() == ModItems.SQUID_TRAVELERS_BACKPACK.get()) {
                this.squidAbility(player);
            }
        } else {
            Item item = blockEntity.getItemStack().getItem();
            if (item == ModItems.CACTUS_TRAVELERS_BACKPACK.get()) {
                this.cactusAbility(null, blockEntity);
            }
        }
    }

    public void abilityRemoval(@Nullable ItemStack stack, @Nullable Player player) {
        if (stack.getItem() == ModItems.NETHERITE_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.NETHERITE_ARMOR_MODIFIER);
        }
        if (stack.getItem() == ModItems.DIAMOND_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.DIAMOND_ARMOR_MODIFIER);
        }
        if (stack.getItem() == ModItems.IRON_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.IRON_ARMOR_MODIFIER);
        }
        if (stack.getItem() == ModItems.GOLD_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.GOLD_ARMOR_MODIFIER);
        }
        if (stack.getItem() == ModItems.ENDERMAN_TRAVELERS_BACKPACK.get()) {
            this.attributeAbility(player, true, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
        }
    }

    public void animateTick(TravelersBackpackBlockEntity blockEntity, BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (blockEntity != null && blockEntity.getAbilityValue()) {
            Block block = stateIn.getBlock();
            if (block == ModBlocks.EMERALD_TRAVELERS_BACKPACK.get()) {
                this.emeraldAbility(null, blockEntity);
            }
            if (block == ModBlocks.BOOKSHELF_TRAVELERS_BACKPACK.get()) {
                this.bookshelfAbility(null, blockEntity);
            }
            if (block == ModBlocks.SPONGE_TRAVELERS_BACKPACK.get()) {
                this.spongeAbility(blockEntity);
            }
        }
    }

    public void emeraldAbility(@Nullable Player player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        Level level;
        Level level2 = level = player == null ? blockEntity.getLevel() : player.level();
        if (player == null || level.random.nextInt(10) == 1) {
            float f = level.random.nextFloat() * (float)Math.PI * 2.0f;
            float f1 = level.random.nextFloat() * 0.5f + 0.5f;
            float f2 = Mth.sin((float)f) * 0.5f * f1;
            float f3 = Mth.cos((float)f) * 0.5f * f1;
            level.addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, player == null ? (double)((float)blockEntity.getBlockPos().getX() + f2 + 0.5f) : player.position().x + (double)f2, player == null ? (double)((float)blockEntity.getBlockPos().getY() + level.random.nextFloat()) : player.getBoundingBox().minY + (double)level.random.nextFloat() + 0.5, player == null ? (double)((float)blockEntity.getBlockPos().getZ() + f3 + 0.5f) : player.position().z + (double)f3, (double)((float)Math.pow(2.0, (double)(level.random.nextInt(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void attributeAbility(Player player, boolean isRemoval, Holder<Attribute> attribute, AttributeModifier modifier) {
        AttributeInstance armor = player.getAttribute(attribute);
        if (isRemoval && armor != null && armor.hasModifier(modifier.id())) {
            armor.removeModifier(modifier.id());
        }
        if (!isRemoval && armor != null && !armor.hasModifier(modifier.id())) {
            armor.addPermanentModifier(modifier);
        }
    }

    public void armorAbilityRemovals(Player player) {
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.NETHERITE_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.DIAMOND_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.IRON_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.ARMOR, this.GOLD_ARMOR_MODIFIER);
        this.attributeAbility(player, true, (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, this.ENDERMAN_REACH_DISTANCE_MODIFIER);
    }

    public void lapisAbility(Player player) {
        if (ABILITIES.checkBackpack(player, (Item)ModItems.LAPIS_TRAVELERS_BACKPACK.get())) {
            int number = player.getRandom().nextIntBetweenInclusive(0, 1);
            player.giveExperiencePoints(number);
            BackpackAbilities.sendParticlesPacket((ParticleOptions)ParticleTypes.GLOW, player, number);
        }
    }

    public void bookshelfAbility(@Nullable Player player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        BlockPos enchanting = BackpackUtils.findBlock3D(blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ(), Blocks.ENCHANTING_TABLE, 2, 2);
        if (enchanting != null) {
            if (!blockEntity.getLevel().isEmptyBlock(new BlockPos((enchanting.getX() - blockEntity.getBlockPos().getX()) / 2 + blockEntity.getBlockPos().getX(), enchanting.getY(), (enchanting.getZ() - blockEntity.getBlockPos().getZ()) / 2 + blockEntity.getBlockPos().getZ()))) {
                return;
            }
            for (int o = 0; o < 4; ++o) {
                blockEntity.getLevel().addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)enchanting.getX() + 0.5, (double)enchanting.getY() + 2.0, (double)enchanting.getZ() + 0.5, (double)((float)(blockEntity.getBlockPos().getX() - enchanting.getX()) + blockEntity.getLevel().random.nextFloat()) - 0.5, (double)((float)(blockEntity.getBlockPos().getY() - enchanting.getY()) - blockEntity.getLevel().random.nextFloat() - 1.0f), (double)((float)(blockEntity.getBlockPos().getZ() - enchanting.getZ()) + blockEntity.getLevel().random.nextFloat()) - 0.5);
            }
        }
    }

    public void spongeAbility(TravelersBackpackBlockEntity blockEntity) {
        if (!blockEntity.getLeftTank().isEmpty() && !blockEntity.getRightTank().isEmpty() && blockEntity.getLeftTank().getFluid().getFluid().isSame((Fluid)Fluids.WATER) && blockEntity.getRightTank().getFluid().getFluid().isSame((Fluid)Fluids.WATER) && blockEntity.getLeftTank().getFluidAmount() == blockEntity.getLeftTank().getCapacity() && blockEntity.getRightTank().getFluidAmount() == blockEntity.getRightTank().getCapacity()) {
            float f = blockEntity.getLevel().random.nextFloat() * (float)Math.PI * 2.0f;
            float f1 = blockEntity.getLevel().random.nextFloat() * 0.5f + 0.5f;
            float f2 = Mth.sin((float)f) * 0.5f * f1;
            float f3 = Mth.cos((float)f) * 0.5f * f1;
            blockEntity.getLevel().addParticle((ParticleOptions)ParticleTypes.SPLASH, (double)((float)blockEntity.getBlockPos().getX() + f2 + 0.5f), (double)((float)blockEntity.getBlockPos().getY() + blockEntity.getLevel().random.nextFloat()), (double)((float)blockEntity.getBlockPos().getZ() + f3 + 0.5f), (double)((float)Math.pow(2.0, (double)(blockEntity.getLevel().random.nextInt(169) - 12) / 12.0)) / 24.0, -1.0, 0.0);
        }
    }

    public void cakeAbility(Player player) {
        TravelersBackpackContainer container = AttachmentUtils.getBackpackInv(player);
        if (container.getLastTime() <= 0) {
            player.getFoodData().eat(2, 0.1f);
            player.level().playSound(null, player.blockPosition(), SoundEvents.CAKE_ADD_CANDLE, SoundSource.AMBIENT, 1.0f, (player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.3f + 1.0f);
            if (!player.level().isClientSide) {
                Level level = player.level();
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    for (int i = 0; i < 3; ++i) {
                        float f = server.random.nextFloat() * (float)Math.PI * 2.0f;
                        float f1 = server.random.nextFloat() * 0.5f + 0.5f;
                        float f2 = Mth.sin((float)f) * 0.5f * f1;
                        float f3 = Mth.cos((float)f) * 0.5f * f1;
                        server.sendParticles((ParticleOptions)ParticleTypes.HEART, player.position().x + (double)f2, player.getBoundingBox().minY + (double)player.level().random.nextFloat() + 0.5, player.position().z + (double)f3, 3, (double)((float)Math.pow(2.0, (double)(player.level().random.nextInt(169) - 12) / 12.0)) / 24.0, -1.0, 0.0, 0.0);
                    }
                }
                container.setLastTime(TimeUtils.randomTime(player.level().random, 360, 360 + player.getFoodData().getFoodLevel() * 12));
                container.setDataChanged(8);
            }
        }
    }

    public void chickenAbility(Player player, boolean firstSwitch) {
        TravelersBackpackContainer container = AttachmentUtils.getBackpackInv(player);
        if (firstSwitch && container.getLastTime() <= 0 && !player.level().isClientSide) {
            container.setLastTime(TimeUtils.randomTime(player.level().random, 360, 600));
            container.setDataChanged(8);
            return;
        }
        if (container.getLastTime() <= 0) {
            player.level().playSound(null, player.blockPosition(), SoundEvents.CHICKEN_EGG, SoundSource.AMBIENT, 1.0f, (player.level().random.nextFloat() - player.level().random.nextFloat()) * 0.3f + 1.0f);
            player.spawnAtLocation((ItemLike)Items.EGG);
            if (!player.level().isClientSide) {
                container.setLastTime(TimeUtils.randomTime(player.level().random, 360, 600));
                container.setDataChanged(8);
            }
        }
    }

    public void cactusAbility(@Nullable Player player, @Nullable TravelersBackpackBlockEntity blockEntity) {
        if (player == null && blockEntity != null) {
            FluidTank leftTank = blockEntity.getLeftTank();
            FluidTank rightTank = blockEntity.getRightTank();
            int drops = 0;
            if (this.isUnderRain(blockEntity.getBlockPos(), blockEntity.getLevel())) {
                ++drops;
            }
            FluidStack water = new FluidStack((Fluid)Fluids.WATER, drops);
            if (!blockEntity.getLevel().isClientSide && blockEntity.getLastTime() <= 0 && drops > 0) {
                blockEntity.setLastTime(5);
                if (leftTank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)leftTank.getFluid(), (FluidStack)water)) {
                    leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                if (rightTank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)rightTank.getFluid(), (FluidStack)water)) {
                    rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                blockEntity.setDataChanged(4);
            }
        } else if (player != null && blockEntity == null) {
            TravelersBackpackContainer container = AttachmentUtils.getBackpackInv(player);
            FluidTank leftTank = container.getLeftTank();
            FluidTank rightTank = container.getRightTank();
            int drops = 0;
            if (player.isInWater()) {
                drops += 2;
            }
            if (this.isUnderRain(player.blockPosition(), player.level())) {
                ++drops;
            }
            FluidStack water = new FluidStack((Fluid)Fluids.WATER, drops);
            if (!container.getLevel().isClientSide && container.getLastTime() <= 0 && drops > 0) {
                container.setLastTime(5);
                if (leftTank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)leftTank.getFluid(), (FluidStack)water)) {
                    leftTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                if (rightTank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)rightTank.getFluid(), (FluidStack)water)) {
                    rightTank.fill(water, IFluidHandler.FluidAction.EXECUTE);
                }
                container.setDataChanged(4);
            }
        }
    }

    public static void melonAbility(TravelersBackpackBlockEntity blockEntity) {
        if (blockEntity.getAbilityValue() && blockEntity.getLastTime() <= 0) {
            Block.popResource((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos(), (ItemStack)new ItemStack((ItemLike)Items.MELON_SLICE, blockEntity.getLevel().random.nextInt(0, 3)));
            blockEntity.setLastTime(TimeUtils.randomTime(blockEntity.getLevel().random, 120, 480));
            blockEntity.setDataChanged();
        }
    }

    public static void pumpkinAbility(EnderManAngerEvent event) {
        if (ABILITIES.checkBackpack(event.getPlayer(), (Item)ModItems.PUMPKIN_TRAVELERS_BACKPACK.get())) {
            event.setCanceled(true);
        }
    }

    public static boolean creeperAbility(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            TravelersBackpackContainer container = AttachmentUtils.getBackpackInv(player);
            if (player.isDeadOrDying() && container != null && container.getItemStack().getItem() == ModItems.CREEPER_TRAVELERS_BACKPACK.get() && container.getAbilityValue() && container.getLastTime() <= 0) {
                player.setHealth(1.0f);
                player.removeAllEffects();
                player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 450, 1));
                player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 400, 0));
                player.level().explode((Entity)player, player.damageSources().playerAttack(player), null, player.getRandomX(0.5), player.getY(), player.getRandomZ(0.5), 3.0f, false, Level.ExplosionInteraction.NONE);
                player.level().playSound(null, player.blockPosition(), SoundEvents.CREEPER_PRIMED, SoundSource.AMBIENT, 1.2f, 0.5f);
                if (!player.level().isClientSide) {
                    container.setLastTime(TimeUtils.randomTime(player.level().random, 600, 900));
                    container.setDataChanged(8);
                }
                event.setCanceled(true);
                return true;
            }
        }
        return false;
    }

    public void dragonAbility(Player player) {
        this.magmaCubeAbility(player);
        this.squidAbility(player);
        this.addTimedMobEffect(player, (Holder<MobEffect>)MobEffects.REGENERATION, 0, 210, 0, false, false, true);
        this.addTimedMobEffect(player, (Holder<MobEffect>)MobEffects.DAMAGE_BOOST, 210, 240, 0, false, false, true);
    }

    public void blazeAbility(Player player) {
        if (player.fallDistance >= 3.0f) {
            for (int i = 0; i < 4; ++i) {
                player.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, player.getRandomX(0.5), player.getRandomY(), player.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
            player.fallDistance = 0.0f;
        }
    }

    public static void blazeAbility(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (projectile instanceof SmallFireball) {
            Player player;
            EntityHitResult result;
            Entity entity;
            SmallFireball fireball = (SmallFireball)projectile;
            if (event.getRayTraceResult().getType() == HitResult.Type.ENTITY && (entity = (result = (EntityHitResult)event.getRayTraceResult()).getEntity()) instanceof Player && ABILITIES.checkBackpack(player = (Player)entity, (Item)ModItems.BLAZE_TRAVELERS_BACKPACK.get())) {
                player.level().playSound(null, player.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 1.0f, 0.8f + player.level().random.nextFloat() * 0.4f);
                BackpackAbilities.sendParticlesPacket((ParticleOptions)ParticleTypes.FLAME, player, 3);
                fireball.discard();
                event.setCanceled(true);
            }
        }
    }

    public static void ghastAbility(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Ghast) {
            Player player;
            Ghast ghast = (Ghast)livingEntity;
            livingEntity = event.getOriginalAboutToBeSetTarget();
            if (livingEntity instanceof Player && ABILITIES.checkBackpack(player = (Player)livingEntity, (Item)ModItems.GHAST_TRAVELERS_BACKPACK.get()) && ghast.getLastHurtByMob() != player) {
                event.setCanceled(true);
            }
        }
    }

    public void magmaCubeAbility(Player player) {
        this.addTimedMobEffect(player, (Holder<MobEffect>)MobEffects.FIRE_RESISTANCE, 210, 240, 0, false, false, true);
    }

    public void spiderAbility(Player player) {
        if (player.horizontalCollision && !player.isInFluidType()) {
            if (player.isFallFlying()) {
                player.stopFallFlying();
            }
            if (!player.onGround() && player.isCrouching()) {
                player.setDeltaMovement(player.getDeltaMovement().x, 0.0, player.getDeltaMovement().z);
            } else {
                player.setDeltaMovement(player.getDeltaMovement().x, 0.2, player.getDeltaMovement().z);
                Level level = player.level();
                BlockState state = level.getBlockState(player.blockPosition().relative(player.getDirection()));
                player.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state).setPos(player.blockPosition()), player.getX() + (level.random.nextDouble() - 0.5) * (double)player.getDimensions(Pose.STANDING).width(), player.getY() + 0.1, player.getZ() + (level.random.nextDouble() - 0.5) * (double)player.getDimensions(Pose.STANDING).width(), 0.0, 1.5, 0.0);
            }
        }
    }

    public void witherAbility(Player player) {
        if (player.getEffect(MobEffects.WITHER) != null) {
            player.removeEffect(MobEffects.WITHER);
        }
    }

    public void batAbility(Player player) {
        this.addTimedMobEffect(player, (Holder<MobEffect>)MobEffects.NIGHT_VISION, 210, 240, 0, false, false, true);
    }

    public static void beeAbility(AttackEntityEvent event) {
        if (ABILITIES.checkBackpack(event.getEntity(), (Item)ModItems.BEE_TRAVELERS_BACKPACK.get())) {
            DamageSource damageSource = event.getEntity().damageSources().sting((LivingEntity)event.getEntity());
            boolean flag = event.getTarget().hurt(damageSource, 1.0f);
            if (flag) {
                Level level = event.getEntity().level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)event.getTarget(), (DamageSource)damageSource);
                }
                if ((level = event.getTarget()) instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)level;
                    living.setStingerCount(living.getStingerCount() + 1);
                    living.addEffect(new MobEffectInstance(MobEffects.POISON, 80, 0), (Entity)event.getEntity());
                }
            }
        }
    }

    public void ocelotAbility(Player player) {
        if (player.level().getNearestEntity(Monster.class, this.ocelotAbilityTargeting, (LivingEntity)player, player.getX(), player.getY(), player.getZ(), player.getBoundingBox().inflate(6.0, 2.0, 6.0)) != null) {
            this.addTimedMobEffect(player, (Holder<MobEffect>)MobEffects.MOVEMENT_SPEED, 20, 30, 0, false, false, true);
        }
    }

    public void cowAbility(Player player) {
        if (!player.getActiveEffects().isEmpty() && AttachmentUtils.getBackpackInv(player).getLastTime() <= 0) {
            player.removeEffectsCuredBy(EffectCures.MILK);
            if (!player.level().isClientSide) {
                player.level().levelEvent(2007, player.blockPosition(), 0xFFFFFF);
            }
            player.level().playSound(null, player.blockPosition(), SoundEvents.HONEYCOMB_WAX_ON, SoundSource.PLAYERS, 1.0f, player.getRandom().nextFloat() * 0.1f + 0.9f);
            AttachmentUtils.getBackpackInv(player).setLastTime(TimeUtils.randomTime(player.level().random, 450, 600));
            AttachmentUtils.getBackpackInv(player).setDataChanged(8);
        }
    }

    public void squidAbility(Player player) {
        if (player.isInWater()) {
            this.addTimedMobEffect(player, (Holder<MobEffect>)MobEffects.WATER_BREATHING, 210, 240, 0, false, false, true);
            this.batAbility(player);
        }
    }

    private boolean isUnderRain(BlockPos pos, Level level) {
        return level.canSeeSky(pos) && level.isRaining();
    }

    public boolean checkBackpack(Player player, Item item) {
        return AttachmentUtils.isWearingBackpack(player) && AttachmentUtils.getBackpackInv(player).getItemStack().getItem() == item && AttachmentUtils.getBackpackInv(player).getAbilityValue();
    }

    public void addTimedMobEffect(Player player, Holder<MobEffect> effect, int minDuration, int maxDuration, int amplifier, boolean ambient, boolean showParticle, boolean showIcon) {
        if (!player.hasEffect(effect)) {
            player.addEffect(new MobEffectInstance(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        } else if (player.hasEffect(effect) && player.getEffect(effect).getDuration() <= minDuration) {
            player.addEffect(new MobEffectInstance(effect, maxDuration, amplifier, ambient, showParticle, showIcon));
        }
    }

    public static void sendParticlesPacket(ParticleOptions type, Player player, int count) {
        for (int i = 0; i < count; ++i) {
            double d0 = player.level().random.nextGaussian() * 0.02;
            double d1 = player.level().random.nextGaussian() * 0.02;
            double d2 = player.level().random.nextGaussian() * 0.02;
            Level level = player.level();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel server = (ServerLevel)level;
            server.sendParticles(type, player.getRandomX(1.0), player.getRandomY() + 0.5, player.getRandomZ(1.0), 1, d0, d1, d2, 0.0);
        }
    }

    public static boolean isOnList(Item[] list, ItemStack stackToCheck) {
        return Arrays.stream(list).anyMatch(s -> s == stackToCheck.getItem());
    }
}

