/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class UnpackBackpackCommand {
    public UnpackBackpackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.literal((String)"tb").requires(player -> player.hasPermission(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"unpack").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(source -> this.unpackTargetBlockEntity((CommandSourceStack)source.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)source, (String)"pos"))))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(source -> this.unpackTargetInventory((CommandSourceStack)source.getSource(), EntityArgument.getPlayer((CommandContext)source, (String)"target")))));
        dispatcher.register(tbCommand);
    }

    public int unpackTargetBlockEntity(CommandSourceStack source, BlockPos blockPos) throws CommandSyntaxException {
        if (source.getLevel().getBlockEntity(blockPos) instanceof TravelersBackpackBlockEntity) {
            TravelersBackpackBlockEntity inv = (TravelersBackpackBlockEntity)source.getLevel().getBlockEntity(blockPos);
            NonNullList stacks = NonNullList.create();
            for (int i = 0; i < inv.getCombinedHandler().getSlots(); ++i) {
                ItemStack stackInSlot = inv.getCombinedHandler().getStackInSlot(i);
                if (stackInSlot.isEmpty()) continue;
                stacks.add((Object)stackInSlot);
                inv.getCombinedHandler().setStackInSlot(i, ItemStack.EMPTY);
            }
            if (!stacks.isEmpty()) {
                if (!source.getLevel().isClientSide) {
                    Containers.dropContents((Level)source.getLevel(), (BlockPos)blockPos, (NonNullList)stacks);
                }
                source.sendSuccess(() -> Component.literal((String)("Dropping contents of backpack placed at " + blockPos.toShortString())), true);
                return 1;
            }
            source.sendFailure((Component)Component.literal((String)("There's no contents in backpack at coordinates " + blockPos.toShortString())));
            return -1;
        }
        source.sendFailure((Component)Component.literal((String)("There's no backpack at coordinates " + blockPos.toShortString())));
        return -1;
    }

    public int unpackTargetInventory(CommandSourceStack source, ServerPlayer serverPlayer) throws CommandSyntaxException {
        boolean hasBackpack = AttachmentUtils.isWearingBackpack((Player)serverPlayer);
        if (hasBackpack) {
            AtomicBoolean flag = new AtomicBoolean(false);
            AttachmentUtils.getAttachment((Player)serverPlayer).ifPresent(data -> {
                NonNullList stacks = NonNullList.create();
                for (int i = 0; i < data.getContainer().getCombinedHandler().getSlots(); ++i) {
                    ItemStack stackInSlot = data.getContainer().getCombinedHandler().getStackInSlot(i);
                    if (stackInSlot.isEmpty()) continue;
                    stacks.add((Object)stackInSlot);
                    data.getContainer().getCombinedHandler().setStackInSlot(i, ItemStack.EMPTY);
                }
                if (!stacks.isEmpty() && !source.getLevel().isClientSide) {
                    Containers.dropContents((Level)source.getLevel(), (BlockPos)serverPlayer.blockPosition(), (NonNullList)stacks);
                    flag.set(true);
                }
            });
            if (flag.get()) {
                source.sendSuccess(() -> Component.literal((String)("Dropping contents of " + serverPlayer.getDisplayName().getString() + " backpack at " + serverPlayer.blockPosition().toShortString())), true);
                return 1;
            }
            source.sendFailure((Component)Component.literal((String)("There's no contents in " + serverPlayer.getDisplayName().getString() + " backpack")));
            return -1;
        }
        source.sendFailure((Component)Component.literal((String)("Player " + serverPlayer.getDisplayName().getString() + " is not wearing backpack")));
        return -1;
    }
}

