/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ClearBackpackCommand {
    public ClearBackpackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.literal((String)"tb").requires(player -> player.hasPermission(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"remove").executes(source -> ClearBackpackCommand.removeBackpack((CommandSourceStack)source.getSource(), ((CommandSourceStack)source.getSource()).getPlayerOrException()))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(source -> ClearBackpackCommand.removeBackpack((CommandSourceStack)source.getSource(), EntityArgument.getPlayer((CommandContext)source, (String)"player")))));
        tbCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(source -> ClearBackpackCommand.clearBackpack((CommandSourceStack)source.getSource(), ((CommandSourceStack)source.getSource()).getPlayerOrException()))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(source -> ClearBackpackCommand.clearBackpack((CommandSourceStack)source.getSource(), EntityArgument.getPlayer((CommandContext)source, (String)"player")))));
        dispatcher.register(tbCommand);
    }

    private static int removeBackpack(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        if (AttachmentUtils.isWearingBackpack((Player)player)) {
            AttachmentUtils.getAttachment((Player)player).ifPresent(data -> {
                data.setWearable(ItemStack.EMPTY);
                data.setContents(ItemStack.EMPTY);
                data.synchronise();
                data.synchroniseToOthers((Player)player);
            });
            source.sendSuccess(() -> Component.literal((String)("Removed Traveler's Backpack from " + player.getDisplayName().getString())), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)("Player " + player.getDisplayName().getString() + " is not wearing backpack")));
        return -1;
    }

    private static int clearBackpack(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        if (AttachmentUtils.isWearingBackpack((Player)player)) {
            AttachmentUtils.getAttachment((Player)player).ifPresent(data -> {
                ItemStack stack = data.getWearable();
                data.setWearable(stack);
                data.setContents(stack);
                data.synchronise();
                data.synchroniseToOthers((Player)player);
            });
            source.sendSuccess(() -> Component.literal((String)("Cleared contents of Traveler's Backpack from " + player.getDisplayName().getString())), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)("Player " + player.getDisplayName().getString() + " is not wearing backpack")));
        return -1;
    }
}

