/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.AttachmentUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;

public class AccessBackpackCommand {
    public AccessBackpackCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder tbCommand = (LiteralArgumentBuilder)Commands.literal((String)"tb").requires(player -> player.hasPermission(2));
        tbCommand.then(((LiteralArgumentBuilder)Commands.literal((String)"access").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(source -> this.openTargetBlockEntity((CommandSourceStack)source.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)source, (String)"pos"))))).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).executes(source -> this.openTargetInventory((CommandSourceStack)source.getSource(), EntityArgument.getPlayer((CommandContext)source, (String)"target")))));
        dispatcher.register(tbCommand);
    }

    public int openTargetBlockEntity(CommandSourceStack source, BlockPos blockPos) throws CommandSyntaxException {
        if (source.getLevel().getBlockEntity(blockPos) instanceof TravelersBackpackBlockEntity) {
            source.getPlayerOrException().openMenu((MenuProvider)((TravelersBackpackBlockEntity)source.getLevel().getBlockEntity(blockPos)), blockPos);
            source.sendSuccess(() -> Component.literal((String)("Accessing backpack of " + blockPos.toShortString())), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)("There's no backpack at coordinates " + blockPos.toShortString())));
        return -1;
    }

    public int openTargetInventory(CommandSourceStack source, ServerPlayer serverPlayer) throws CommandSyntaxException {
        ServerPlayer self = source.getPlayerOrException();
        boolean hasBackpack = AttachmentUtils.isWearingBackpack((Player)serverPlayer);
        if (hasBackpack) {
            self.openMenu((MenuProvider)AttachmentUtils.getBackpackInv((Player)serverPlayer), packetBuffer -> packetBuffer.writeByte((byte)2).writeBoolean(true).writeInt(serverPlayer.getId()));
            source.sendSuccess(() -> Component.literal((String)("Accessing backpack of " + serverPlayer.getDisplayName().getString())), true);
            return 1;
        }
        source.sendFailure((Component)Component.literal((String)"Can't access backpack"));
        return -1;
    }
}

