/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;

public abstract class WidgetBase
implements Renderable,
GuiEventListener,
NarratableEntry {
    public final TravelersBackpackScreen screen;
    protected int x;
    protected int y;
    protected int zOffset = 0;
    protected int width;
    protected int height;
    protected boolean isWidgetActive = false;
    protected boolean isVisible;
    protected boolean showTooltip;

    public WidgetBase(TravelersBackpackScreen screen, int x, int y, int width, int height) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.zOffset != 0) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, (float)this.zOffset);
        }
        RenderSystem.enableDepthTest();
        this.renderBg(guiGraphics, Minecraft.getInstance(), mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.zOffset != 0) {
            guiGraphics.pose().popPose();
        }
    }

    abstract void renderBg(GuiGraphics var1, Minecraft var2, int var3, int var4);

    abstract void renderTooltip(GuiGraphics var1, int var2, int var3);

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        return pMouseX >= (double)this.x && pMouseY >= (double)this.y && pMouseX < (double)(this.x + this.width) && pMouseY < (double)(this.y + this.height);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.isMouseOver(pMouseX, pMouseY)) {
            this.setWidgetStatus(!this.isWidgetActive);
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }

    public void setWidgetStatus(boolean status) {
        this.isWidgetActive = status;
    }

    public boolean isWidgetActive() {
        return this.isWidgetActive;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visibility) {
        this.isVisible = visibility;
    }

    public void setTooltipVisible(boolean visible) {
        this.showTooltip = visible;
    }

    public boolean isSettingsChild() {
        return true;
    }

    public boolean in(int mouseX, int mouseY, int x, int y, int width, int height) {
        return x <= mouseX && mouseX <= x + width && y <= mouseY && mouseY <= y + height;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public int[] getWidgetSizeAndPos() {
        int[] size = new int[]{this.x, this.y, this.width, this.height};
        return size;
    }
}

