/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.network.ServerboundSettingsPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class ToolSlotsWidget
extends WidgetBase {
    public ToolSlotsWidget(TravelersBackpackScreen screen, int x, int y, int width, int height) {
        super(screen, x, y, width, height);
        this.isVisible = screen.container.getToolSlotsHandler().getSlots() > 0;
        this.isWidgetActive = screen.container.getSettingsManager().showToolSlots();
    }

    @Override
    void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isVisible()) {
            if (!this.screen.container.getSettingsManager().showToolSlots()) {
                guiGraphics.blit(TravelersBackpackScreen.SETTINGS_TRAVELERS_BACKPACK, this.x, this.y, 64, 0, this.width, this.height);
            } else {
                guiGraphics.blit(TravelersBackpackScreen.SETTINGS_TRAVELERS_BACKPACK, this.x, this.y, 64, 16, this.width, this.height);
            }
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isVisible() && this.isMouseOver(mouseX, mouseY)) {
            if (this.screen.container.getSettingsManager().showToolSlots()) {
                this.screen.container.getSettingsManager().set((byte)1, 0, (byte)0);
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSettingsPacket(this.screen.container.getScreenID(), 1, 0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.setWidgetStatus(false);
            } else {
                this.screen.container.getSettingsManager().set((byte)1, 0, (byte)1);
                PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSettingsPacket(this.screen.container.getScreenID(), 1, 0, 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
                this.setWidgetStatus(true);
            }
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }

    @Override
    void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public boolean isCoveringButton() {
        return Math.max(3, this.screen.container.getRows()) <= this.screen.container.getToolSlotsHandler().getSlots() && this.isWidgetActive();
    }

    public boolean isCoveringAbility() {
        if (this.screen.container.getRows() <= 4) {
            return this.screen.container.getToolSlotsHandler().getSlots() >= 2 && this.isWidgetActive();
        }
        return this.screen.container.getToolSlotsHandler().getSlots() >= 3 && this.isWidgetActive();
    }

    @Override
    public boolean isSettingsChild() {
        return false;
    }

    public void setFocused(boolean pFocused) {
    }

    public boolean isFocused() {
        return false;
    }
}

