/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.network.ServerboundSlotPacket;
import com.tiviacz.travelersbackpack.network.ServerboundSorterPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class SortWidget
extends WidgetBase {
    public SortWidget(TravelersBackpackScreen screen, int x, int y, int width, int height) {
        super(screen, x, y, width, height);
        this.isVisible = false;
        this.showTooltip = true;
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isVisible()) {
            if (this.isWidgetActive()) {
                guiGraphics.blit(TravelersBackpackScreen.SETTINGS_TRAVELERS_BACKPACK, this.x, this.y, 0, 41, this.width, this.height);
            } else {
                guiGraphics.blit(TravelersBackpackScreen.SETTINGS_TRAVELERS_BACKPACK, this.x, this.y, 32, this.isWidgetActive ? 19 : 0, this.width, this.height);
            }
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY) && this.showTooltip) {
            ArrayList<Component> components = new ArrayList<Component>(TextUtils.getTranslatedSplittedText("screen.travelersbackpack.unsortable", null));
            if (mouseX >= this.x + 1 && mouseY >= this.y + 15 && mouseX < this.x + 11 && mouseY < this.y + 25) {
                components.add((Component)Component.translatable((String)"screen.travelersbackpack.select_all"));
            }
            if (mouseX >= this.x + 13 && mouseY >= this.y + 15 && mouseX < this.x + 23 && mouseY < this.y + 25) {
                components.add((Component)Component.translatable((String)"screen.travelersbackpack.remove_all"));
            }
            guiGraphics.renderComponentTooltip(this.screen.getFont(), components, mouseX, mouseY);
        }
    }

    @Override
    public void setWidgetStatus(boolean status) {
        super.setWidgetStatus(status);
        this.screen.memoryWidget.setTooltipVisible(!status);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int pButton) {
        if (!this.screen.settingsWidget.isWidgetActive()) {
            return false;
        }
        if (this.screen.container.getSlotManager().isSelectorActive((byte)1)) {
            return false;
        }
        if (this.isMouseOver(mouseX, mouseY) && this.isWidgetActive) {
            if (mouseX >= (double)(this.x + 1) && mouseY >= (double)(this.y + 15) && mouseX < (double)(this.x + 11) && mouseY < (double)(this.y + 25)) {
                for (int i = 1; i <= this.screen.container.getHandler().getSlots(); ++i) {
                    if (this.screen.container.getSlotManager().isSlot((byte)0, i - 1)) continue;
                    this.screen.container.getSlotManager().setUnsortableSlot(i - 1);
                }
                this.screen.playUIClickSound();
                return true;
            }
            if (mouseX >= (double)(this.x + 13) && mouseY >= (double)(this.y + 15) && mouseX < (double)(this.x + 23) && mouseY < (double)(this.y + 25)) {
                this.screen.container.getSlotManager().clearUnsortables();
                this.screen.playUIClickSound();
                return true;
            }
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            this.setWidgetStatus(!this.isWidgetActive);
            if (this.isWidgetActive) {
                this.height = 30;
                this.width = 28;
                this.zOffset = 1;
            }
            if (!this.isWidgetActive) {
                this.height = 18;
                this.width = 15;
                this.zOffset = 0;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSorterPacket(this.screen.container.getScreenID(), 4, BackpackUtils.isShiftPressed()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSlotPacket(this.screen.container.getScreenID(), this.screen.container.getSlotManager().isSelectorActive((byte)0), this.screen.container.getSlotManager().getUnsortableSlots()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.screen.container.getSlotManager().setSelectorActive((byte)0, !this.screen.container.getSlotManager().isSelectorActive((byte)0));
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }

    public void setFocused(boolean p_265728_) {
    }

    public boolean isFocused() {
        return false;
    }

    @Override
    public int[] getWidgetSizeAndPos() {
        int[] size = new int[]{this.x, this.y, this.width, this.height};
        return size;
    }
}

