/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.network.ServerboundMemoryPacket;
import com.tiviacz.travelersbackpack.network.ServerboundSorterPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.TextUtils;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class MemoryWidget
extends WidgetBase {
    public MemoryWidget(TravelersBackpackScreen screen, int x, int y, int width, int height) {
        super(screen, x, y, width, height);
        this.isVisible = false;
        this.showTooltip = true;
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isVisible()) {
            guiGraphics.blit(TravelersBackpackScreen.SETTINGS_TRAVELERS_BACKPACK, this.x, this.y, 16, this.isWidgetActive ? 19 : 0, this.width, this.height);
        }
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY) && this.showTooltip) {
            guiGraphics.renderComponentTooltip(this.screen.getFont(), TextUtils.getTranslatedSplittedText("screen.travelersbackpack.memory", null), mouseX, mouseY);
        }
    }

    @Override
    public void setWidgetStatus(boolean status) {
        super.setWidgetStatus(status);
        this.screen.sortWidget.setTooltipVisible(!status);
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (!this.screen.settingsWidget.isWidgetActive()) {
            return false;
        }
        if (this.screen.container.getSlotManager().isSelectorActive((byte)0)) {
            return false;
        }
        if (this.isMouseOver(pMouseX, pMouseY)) {
            this.setWidgetStatus(!this.isWidgetActive);
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSorterPacket(this.screen.container.getScreenID(), 5, BackpackUtils.isShiftPressed()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundMemoryPacket(this.screen.container.getScreenID(), this.screen.container.getSlotManager().isSelectorActive((byte)1), this.screen.container.getSlotManager().getMemorySlots().stream().map(Pair::getFirst).collect(Collectors.toList()), this.screen.container.getSlotManager().getMemorySlots().stream().map(Pair::getSecond).collect(Collectors.toList())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.screen.container.getSlotManager().setSelectorActive((byte)1, !this.screen.container.getSlotManager().isSelectorActive((byte)1));
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }

    public void setFocused(boolean p_265728_) {
    }

    public boolean isFocused() {
        return false;
    }
}

